/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyJavaObject;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;

public class JavaUtil {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$org$jruby$RubyObject;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Number;

    public static boolean isCompatible(RubyObject arg, Class javaClass) {
        if (arg.isNil()) {
            return true;
        }
        if (javaClass == (class$java$lang$Object == null ? (class$java$lang$Object = JavaUtil.class$("java.lang.Object")) : class$java$lang$Object) || javaClass == null) {
            return true;
        }
        if (javaClass.isPrimitive()) {
            String cName = javaClass.getName();
            if (cName == "boolean") {
                return true;
            }
            return arg instanceof RubyNumeric || arg instanceof RubyString;
        }
        if (javaClass.isArray()) {
            if (!(arg instanceof RubyArray)) {
                return false;
            }
            Class<?> arrayClass = javaClass.getComponentType();
            int i = 0;
            while (i < ((RubyArray)arg).getLength()) {
                if (!JavaUtil.isCompatible(((RubyArray)arg).entry(i), arrayClass)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if ((class$java$util$List == null ? (class$java$util$List = JavaUtil.class$("java.util.List")) : class$java$util$List).isAssignableFrom(javaClass)) {
            return arg instanceof RubyArray;
        }
        if ((class$java$util$Map == null ? (class$java$util$Map = JavaUtil.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(javaClass)) {
            return arg instanceof RubyHash;
        }
        return javaClass.isAssignableFrom(arg.getJavaClass());
    }

    public static Object convertRubyToJava(Ruby ruby, RubyObject rubyObject) {
        return JavaUtil.convertRubyToJava(ruby, rubyObject, null);
    }

    public static Object convertRubyToJava(Ruby ruby, RubyObject rubyObject, Class javaClass) {
        if (rubyObject == null || rubyObject == ruby.getNil()) {
            return null;
        }
        if ((javaClass == (class$java$lang$Object == null ? (class$java$lang$Object = JavaUtil.class$("java.lang.Object")) : class$java$lang$Object) || javaClass == null) && (javaClass = rubyObject.getJavaClass()) == (class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = JavaUtil.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject)) {
            Class clazz = javaClass = class$java$lang$String == null ? (class$java$lang$String = JavaUtil.class$("java.lang.String")) : class$java$lang$String;
        }
        if (javaClass.isPrimitive()) {
            String cName = javaClass.getName();
            if (cName == "boolean") {
                return new Boolean(rubyObject.isTrue());
            }
            if (cName == "float") {
                if (rubyObject.respondsTo("to_f")) {
                    return new Float(((RubyNumeric)rubyObject.funcall("to_f")).getDoubleValue());
                }
                return new Float(0.0);
            }
            if (cName == "double") {
                if (rubyObject.respondsTo("to_f")) {
                    return new Double(((RubyNumeric)rubyObject.funcall("to_f")).getDoubleValue());
                }
                return new Double(0.0);
            }
            if (cName == "long") {
                if (rubyObject.respondsTo("to_i")) {
                    return new Long(((RubyNumeric)rubyObject.funcall("to_i")).getLongValue());
                }
                return new Long(0L);
            }
            if (cName == "int") {
                if (rubyObject.respondsTo("to_i")) {
                    return new Integer((int)((RubyNumeric)rubyObject.funcall("to_i")).getLongValue());
                }
                return new Integer(0);
            }
            if (cName == "short") {
                if (rubyObject.respondsTo("to_i")) {
                    return new Short((short)((RubyNumeric)rubyObject.funcall("to_i")).getLongValue());
                }
                return new Short(0);
            }
            if (cName == "byte") {
                if (rubyObject.respondsTo("to_i")) {
                    return new Byte((byte)((RubyNumeric)rubyObject.funcall("to_i")).getLongValue());
                }
                return new Byte(0);
            }
            String s = ((RubyString)rubyObject.funcall("to_s")).getValue();
            if (s.length() > 0) {
                return new Character(s.charAt(0));
            }
            return new Character('\u0000');
        }
        if (javaClass == (class$java$lang$String == null ? (class$java$lang$String = JavaUtil.class$("java.lang.String")) : class$java$lang$String)) {
            return ((RubyString)rubyObject.funcall("to_s")).getValue();
        }
        if (javaClass.isArray()) {
            try {
                Class<?> arrayClass = javaClass.getComponentType();
                int len = ((RubyArray)rubyObject).getLength();
                Object javaObject = Array.newInstance(arrayClass, len);
                int i = 0;
                while (i < len) {
                    Object item = JavaUtil.convertRubyToJava(ruby, ((RubyArray)rubyObject).entry(i), arrayClass);
                    Array.set(javaObject, i, item);
                    ++i;
                }
                return javaObject;
            }
            catch (NegativeArraySizeException ex) {
                return null;
            }
        }
        if ((class$java$util$List == null ? (class$java$util$List = JavaUtil.class$("java.util.List")) : class$java$util$List).isAssignableFrom(javaClass)) {
            if (javaClass == (class$java$util$List == null ? (class$java$util$List = JavaUtil.class$("java.util.List")) : class$java$util$List)) {
                javaClass = class$java$util$ArrayList == null ? (class$java$util$ArrayList = JavaUtil.class$("java.util.ArrayList")) : class$java$util$ArrayList;
            }
            try {
                List javaObject = (List)javaClass.newInstance();
                int len = ((RubyArray)rubyObject).getLength();
                int i = 0;
                while (i < len) {
                    javaObject.add(JavaUtil.convertRubyToJava(ruby, ((RubyArray)rubyObject).entry(i), null));
                    ++i;
                }
                return javaObject;
            }
            catch (InstantiationException iExcptn) {
            }
            catch (IllegalAccessException iaExcptn) {
                // empty catch block
            }
            return null;
        }
        if ((class$java$util$Map == null ? (class$java$util$Map = JavaUtil.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(javaClass)) {
            if (javaClass == (class$java$util$Map == null ? (class$java$util$Map = JavaUtil.class$("java.util.Map")) : class$java$util$Map)) {
                javaClass = class$java$util$HashMap == null ? (class$java$util$HashMap = JavaUtil.class$("java.util.HashMap")) : class$java$util$HashMap;
            }
            try {
                Map javaObject = (Map)javaClass.newInstance();
                Iterator iter = ((RubyHash)rubyObject).getValueMap().entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    javaObject.put(JavaUtil.convertRubyToJava(ruby, (RubyObject)entry.getKey(), null), JavaUtil.convertRubyToJava(ruby, (RubyObject)entry.getValue(), null));
                }
                return javaObject;
            }
            catch (InstantiationException iExcptn) {
            }
            catch (IllegalAccessException iaExcptn) {
                // empty catch block
            }
            return null;
        }
        return ((RubyJavaObject)rubyObject).getValue();
    }

    public static RubyObject[] convertJavaArrayToRuby(Ruby ruby, Object[] objects) {
        RubyObject[] rubyObjects = new RubyObject[objects.length];
        int i = 0;
        while (i < objects.length) {
            rubyObjects[i] = JavaUtil.convertJavaToRuby(ruby, objects[i]);
            ++i;
        }
        return rubyObjects;
    }

    public static RubyObject convertJavaToRuby(Ruby ruby, Object object) {
        if (object == null) {
            return ruby.getNil();
        }
        Class<?> javaClass = object.getClass();
        if (javaClass.isPrimitive()) {
            String cName = javaClass.getName();
            if (cName == "boolean") {
                return RubyBoolean.newBoolean(ruby, (Boolean)object);
            }
            if (cName == "float" || cName == "double") {
                return RubyFloat.newFloat(ruby, ((Number)object).doubleValue());
            }
            if (cName == "char") {
                return RubyFixnum.newFixnum(ruby, ((Character)object).charValue());
            }
            return RubyFixnum.newFixnum(ruby, ((Number)object).longValue());
        }
        if (javaClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JavaUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return RubyBoolean.newBoolean(ruby, (Boolean)object);
        }
        if (javaClass == (class$java$lang$Float == null ? (class$java$lang$Float = JavaUtil.class$("java.lang.Float")) : class$java$lang$Float) || javaClass == (class$java$lang$Double == null ? (class$java$lang$Double = JavaUtil.class$("java.lang.Double")) : class$java$lang$Double)) {
            return RubyFloat.newFloat(ruby, ((Number)object).doubleValue());
        }
        if (javaClass == (class$java$lang$Character == null ? (class$java$lang$Character = JavaUtil.class$("java.lang.Character")) : class$java$lang$Character)) {
            return RubyFixnum.newFixnum(ruby, ((Character)object).charValue());
        }
        if ((class$java$lang$Number == null ? (class$java$lang$Number = JavaUtil.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(javaClass)) {
            return RubyFixnum.newFixnum(ruby, ((Number)object).longValue());
        }
        if (javaClass == (class$java$lang$String == null ? (class$java$lang$String = JavaUtil.class$("java.lang.String")) : class$java$lang$String)) {
            return RubyString.newString(ruby, object.toString());
        }
        if (javaClass.isArray()) {
            Class<?> arrayClass = javaClass.getComponentType();
            int len = Array.getLength(object);
            RubyObject[] items = new RubyObject[len];
            int i = 0;
            while (i < len) {
                items[i] = JavaUtil.convertJavaToRuby(ruby, Array.get(object, i));
                ++i;
            }
            return RubyArray.newArray(ruby, items);
        }
        if ((class$java$util$List == null ? (class$java$util$List = JavaUtil.class$("java.util.List")) : class$java$util$List).isAssignableFrom(javaClass)) {
            int len = ((List)object).size();
            RubyObject[] items = new RubyObject[len];
            int i = 0;
            while (i < len) {
                items[i] = JavaUtil.convertJavaToRuby(ruby, ((List)object).get(i));
                ++i;
            }
            return RubyArray.newArray(ruby, items);
        }
        if ((class$java$util$Map == null ? (class$java$util$Map = JavaUtil.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(javaClass)) {
            int len = ((Map)object).size();
            RubyObject[] items = new RubyObject[len * 2];
            Iterator iter = ((Map)object).entrySet().iterator();
            int i = 0;
            while (i < len) {
                Map.Entry entry = iter.next();
                items[2 * i] = JavaUtil.convertJavaToRuby(ruby, entry.getKey());
                items[2 * i + 1] = JavaUtil.convertJavaToRuby(ruby, entry.getValue());
                ++i;
            }
            return RubyHash.create(ruby, null, items);
        }
        return new RubyJavaObject(ruby, (RubyClass)ruby.getJavaSupport().loadClass(javaClass, null), object);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

