/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.regexp;

import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.exceptions.RubyRegexpException;

public abstract class IRegexpAdapter {
    public abstract void compile(Ruby var1, String var2) throws RubyRegexpException;

    public abstract void setCasefold(boolean var1);

    public abstract boolean getCasefold();

    public abstract void setExtended(boolean var1);

    public abstract void setMultiline(boolean var1);

    public abstract RubyObject search(Ruby var1, String var2, int var3);

    public String unextend(String re) {
        boolean inClass = false;
        int len = re.length();
        StringBuffer sbuf = new StringBuffer(len);
        int pos = 0;
        while (pos < len) {
            char c = re.charAt(pos);
            if (c == '\\' && ++pos < len) {
                sbuf.append('\\').append(re.charAt(pos));
            } else if (c == '[' && ++pos < len) {
                sbuf.append(c);
                inClass = true;
                c = re.charAt(pos);
                if (c == ']') {
                    sbuf.append(c);
                }
            } else if (c == ']') {
                sbuf.append(c);
                inClass = false;
            } else if (c == '#') {
                if (pos > 2 && re.charAt(pos - 2) == '(' && re.charAt(pos - 1) == '?') {
                    sbuf.append(c);
                } else {
                    ++pos;
                    while (pos < len && re.charAt(pos) != '\n' && re.charAt(pos) != '\r') {
                        ++pos;
                    }
                }
            } else if (inClass || !Character.isWhitespace(c)) {
                sbuf.append(c);
            }
            ++pos;
        }
        return sbuf.toString();
    }
}

