/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.IErrno;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;

public class RubyExceptions
implements IErrno {
    private RubyClass systemExit = null;
    private RubyClass fatal = null;
    private RubyClass interrupt = null;
    private RubyClass signalException = null;
    private RubyClass standardError = null;
    private RubyClass typeError = null;
    private RubyClass argumentError = null;
    private RubyClass indexError = null;
    private RubyClass rangeError = null;
    private RubyClass scriptError = null;
    private RubyClass syntaxError = null;
    private RubyClass nameError = null;
    private RubyClass loadError = null;
    private RubyClass notImplementedError = null;
    private RubyClass runtimeError = null;
    private RubyClass securityError = null;
    private RubyClass noMemError = null;
    private RubyClass regexpError = null;
    private RubyClass ioError = null;
    private RubyClass eofError = null;
    private RubyClass systemCallError = null;
    private RubyClass localJumpError = null;
    private Ruby ruby = null;
    private RubyModule errnoModule;
    private RubyClass _ENOTEMPTY;
    private RubyClass _ERANGE;
    private RubyClass _ESPIPE;
    private RubyClass _ENFILE;
    private RubyClass _EXDEV;
    private RubyClass _ENOMEM;
    private RubyClass _E2BIG;
    private RubyClass _ENOENT;
    private RubyClass _ENOSYS;
    private RubyClass _EDOM;
    private RubyClass _ENOSPC;
    private RubyClass _EINVAL;
    private RubyClass _EEXIST;
    private RubyClass _EAGAIN;
    private RubyClass _ENXIO;
    private RubyClass _EILSEQ;
    private RubyClass _ENOLCK;
    private RubyClass _EPIPE;
    private RubyClass _EFBIG;
    private RubyClass _EISDIR;
    private RubyClass _EBUSY;
    private RubyClass _ECHILD;
    private RubyClass _EIO;
    private RubyClass _EPERM;
    private RubyClass _EDEADLOCK;
    private RubyClass _ENAMETOOLONG;
    private RubyClass _EMLINK;
    private RubyClass _ENOTTY;
    private RubyClass _ENOTDIR;
    private RubyClass _EFAULT;
    private RubyClass _EBADF;
    private RubyClass _EINTR;
    private RubyClass _EWOULDBLOCK;
    private RubyClass _EDEADLK;
    private RubyClass _EROFS;
    private RubyClass _EMFILE;
    private RubyClass _ENODEV;
    private RubyClass _EACCES;
    private RubyClass _ENOEXEC;
    private RubyClass _ESRCH;

    public RubyExceptions(Ruby ruby) {
        this.ruby = ruby;
    }

    public void initDefaultExceptionClasses() {
        RubyClass exceptionClass = this.ruby.getClasses().getExceptionClass();
        this.systemExit = this.ruby.defineClass("SystemExit", exceptionClass);
        this.fatal = this.ruby.defineClass("Fatal", exceptionClass);
        this.interrupt = this.ruby.defineClass("Interrupt", exceptionClass);
        this.signalException = this.ruby.defineClass("SignalException", exceptionClass);
        this.standardError = this.ruby.defineClass("StandardError", exceptionClass);
        this.typeError = this.ruby.defineClass("TypeError", this.standardError);
        this.argumentError = this.ruby.defineClass("ArgumentError", this.standardError);
        this.indexError = this.ruby.defineClass("IndexError", this.standardError);
        this.rangeError = this.ruby.defineClass("RangeError", this.standardError);
        this.scriptError = this.ruby.defineClass("ScriptError", exceptionClass);
        this.syntaxError = this.ruby.defineClass("SyntaxError", this.scriptError);
        this.nameError = this.ruby.defineClass("NameError", this.scriptError);
        this.loadError = this.ruby.defineClass("LoadError", this.scriptError);
        this.notImplementedError = this.ruby.defineClass("NotImplementedError", this.scriptError);
        this.runtimeError = this.ruby.defineClass("RuntimeError", this.standardError);
        this.securityError = this.ruby.defineClass("SecurityError", this.standardError);
        this.noMemError = this.ruby.defineClass("NoMemError", exceptionClass);
        this.regexpError = this.ruby.defineClass("RegexpError", this.standardError);
        this.ioError = this.ruby.defineClass("IOError", this.standardError);
        this.eofError = this.ruby.defineClass("EOFError", this.ioError);
        this.systemCallError = this.ruby.defineClass("SystemCallError", this.standardError);
        this.localJumpError = this.ruby.defineClass("LocalJumpError", this.standardError);
        this.errnoModule = this.ruby.defineModule("Errno");
        this._ENOTEMPTY = this.setSysErr(1, "ENOTEMPTY");
        this._ERANGE = this.setSysErr(2, "ERANGE");
        this._ESPIPE = this.setSysErr(3, "ESPIPE");
        this._ENFILE = this.setSysErr(4, "ENFILE");
        this._EXDEV = this.setSysErr(5, "EXDEV");
        this._ENOMEM = this.setSysErr(6, "ENOMEM");
        this._E2BIG = this.setSysErr(7, "E2BIG");
        this._ENOENT = this.setSysErr(8, "ENOENT");
        this._ENOSYS = this.setSysErr(9, "ENOSYS");
        this._EDOM = this.setSysErr(10, "EDOM");
        this._ENOSPC = this.setSysErr(11, "ENOSPC");
        this._EINVAL = this.setSysErr(42, "EINVAL");
        this._EEXIST = this.setSysErr(43, "EEXIST");
        this._EAGAIN = this.setSysErr(44, "EAGAIN");
        this._ENXIO = this.setSysErr(45, "ENXIO");
        this._EILSEQ = this.setSysErr(46, "EILSEQ");
        this._ENOLCK = this.setSysErr(47, "ENOLCK");
        this._EPIPE = this.setSysErr(48, "EPIPE");
        this._EFBIG = this.setSysErr(49, "EFBIG");
        this._EISDIR = this.setSysErr(50, "EISDIR");
        this._EBUSY = this.setSysErr(51, "EBUSY");
        this._ECHILD = this.setSysErr(52, "ECHILD");
        this._EIO = this.setSysErr(53, "EIO");
        this._EPERM = this.setSysErr(54, "EPERM");
        this._EDEADLOCK = this.setSysErr(55, "EDEADLOCK");
        this._ENAMETOOLONG = this.setSysErr(56, "ENAMETOOLONG");
        this._EMLINK = this.setSysErr(57, "EMLINK");
        this._ENOTTY = this.setSysErr(58, "ENOTTY");
        this._ENOTDIR = this.setSysErr(59, "ENOTDIR");
        this._EFAULT = this.setSysErr(60, "EFAULT");
        this._EBADF = this.setSysErr(61, "EBADF");
        this._EINTR = this.setSysErr(62, "EINTR");
        this._EWOULDBLOCK = this.setSysErr(63, "EWOULDBLOCK");
        this._EDEADLK = this.setSysErr(64, "EDEADLK");
        this._EROFS = this.setSysErr(65, "EROFS");
        this._EMFILE = this.setSysErr(66, "EMFILE");
        this._ENODEV = this.setSysErr(67, "ENODEV");
        this._EACCES = this.setSysErr(68, "EACCES");
        this._ENOEXEC = this.setSysErr(69, "ENOEXEC");
        this._ESRCH = this.setSysErr(70, "ESRCH");
    }

    private RubyClass setSysErr(int i, String iName) {
        RubyClass lError = this.errnoModule.defineClassUnder(iName, this.systemCallError);
        lError.defineConstant("Errno", RubyFixnum.newFixnum(this.ruby, i));
        return lError;
    }

    public RubyModule getErrnoModule() {
        return this.errnoModule;
    }

    public RubyClass getSystemCallError() {
        return this.systemCallError;
    }

    public RubyClass getArgumentError() {
        return this.argumentError;
    }

    public RubyClass getFatal() {
        return this.fatal;
    }

    public RubyClass getIndexError() {
        return this.indexError;
    }

    public RubyClass getInterrupt() {
        return this.interrupt;
    }

    public RubyClass getLoadError() {
        return this.loadError;
    }

    public RubyClass getNameError() {
        return this.nameError;
    }

    public RubyClass getNoMemError() {
        return this.noMemError;
    }

    public RubyClass getNotImplementedError() {
        return this.notImplementedError;
    }

    public RubyClass getRangeError() {
        return this.rangeError;
    }

    public RubyClass getRuntimeError() {
        return this.runtimeError;
    }

    public RubyClass getScriptError() {
        return this.scriptError;
    }

    public RubyClass getSecurityError() {
        return this.securityError;
    }

    public RubyClass getSignalException() {
        return this.signalException;
    }

    public RubyClass getStandardError() {
        return this.standardError;
    }

    public RubyClass getSyntaxError() {
        return this.syntaxError;
    }

    public RubyClass getSystemExit() {
        return this.systemExit;
    }

    public RubyClass getTypeError() {
        return this.typeError;
    }

    public RubyClass getRegexpError() {
        return this.regexpError;
    }

    public RubyClass getIOError() {
        return this.ioError;
    }

    public RubyClass getEOFError() {
        return this.eofError;
    }

    public RubyClass getLocalJumpError() {
        return this.localJumpError;
    }
}

