/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyObject;

public class RubyVarmap {
    private String name = null;
    private RubyObject val = null;
    private RubyVarmap next = null;
    private static Map oldMap = new HashMap();

    public RubyVarmap(String name, RubyObject val, RubyVarmap next) {
        this.name = name;
        this.val = val;
        this.next = next;
    }

    public RubyVarmap() {
    }

    public static void push(Ruby ruby) {
        ruby.varMapStack.push(ruby.getDynamicVars());
        ruby.setDynamicVars(null);
    }

    public static void pop(Ruby ruby) {
        ruby.setDynamicVars((RubyVarmap)ruby.varMapStack.pop());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String id) {
        this.name = id;
    }

    public RubyVarmap getNext() {
        return this.next;
    }

    public void setNext(RubyVarmap next) {
        this.next = next;
    }

    public RubyObject getVal() {
        return this.val;
    }

    public void setVal(RubyObject val) {
        this.val = val;
    }

    public static boolean isDefined(Ruby ruby, String name) {
        RubyVarmap vars = ruby.getDynamicVars();
        while (vars != null) {
            if (name.equals(vars.name)) {
                return true;
            }
            vars = vars.next;
        }
        return false;
    }

    public static boolean isCurrent(Ruby ruby, String name) {
        RubyVarmap vars = ruby.getDynamicVars();
        while (vars != null) {
            if (vars.name == null) break;
            if (vars.name.equals(name)) {
                return true;
            }
            vars = vars.next;
        }
        return false;
    }

    public RubyObject getRef(Ruby ruby, String name) {
        if (name.equals(this.name)) {
            return this.getVal();
        }
        if (this.next != null) {
            return this.next.getRef(ruby, name);
        }
        return ruby.getNil();
    }

    public static void push(Ruby ruby, String rubyId, RubyObject val) {
        ruby.setDynamicVars(new RubyVarmap(rubyId, val, ruby.getDynamicVars()));
    }

    public static RubyVarmap assignInternal(RubyVarmap varMap, String id, RubyObject value, boolean current) {
        int n = 0;
        RubyVarmap tmpMap = varMap;
        while (tmpMap != null) {
            if (current && tmpMap.getName() == null && ++n == 2) break;
            if (id.equals(tmpMap.getName())) {
                tmpMap.setVal(value);
                return varMap;
            }
            tmpMap = tmpMap.getNext();
        }
        if (varMap == null) {
            return new RubyVarmap(id, value, null);
        }
        tmpMap = new RubyVarmap(id, value, varMap.getNext());
        varMap.setNext(tmpMap);
        return varMap;
    }

    public static void assign(Ruby ruby, String id, RubyObject value) {
        ruby.setDynamicVars(RubyVarmap.assignInternal(ruby.getDynamicVars(), id, value, false));
    }

    public static void assignCurrent(Ruby ruby, String id, RubyObject value) {
        ruby.setDynamicVars(RubyVarmap.assignInternal(ruby.getDynamicVars(), id, value, true));
    }

    public static List getNames(Ruby ruby) {
        RubyVarmap vars = ruby.getDynamicVars();
        ArrayList<String> names = new ArrayList<String>();
        while (vars != null) {
            if (vars.name == null) break;
            names.add(vars.name);
            vars = vars.next;
        }
        return names;
    }
}

