/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.runtime.Scope;
import org.jruby.util.collections.AbstractStack;
import org.jruby.util.collections.StackElement;

public class ScopeStack
extends AbstractStack {
    private Ruby ruby;

    public ScopeStack(Ruby ruby) {
        this.ruby = ruby;
    }

    public void push(List localNames) {
        this.push();
        this.setLocalNames(localNames);
        if (localNames != null) {
            this.setLocalValues(new ArrayList<RubyObject>(Collections.nCopies(localNames.size(), this.ruby.getNil())));
        }
    }

    public void push(StackElement newElement) {
        if (this.top != null) {
            ((Scope)this.top).setMethodScope(this.ruby.getActMethodScope());
        }
        super.push(newElement);
        this.ruby.setActMethodScope(0);
    }

    public void push() {
        this.push(new Scope());
    }

    public StackElement pop() {
        Scope result = (Scope)super.pop();
        this.ruby.setActMethodScope(result.getMethodScope());
        return result;
    }

    public void setTop(StackElement newElement) {
        this.top = newElement;
    }

    public int getFlags() {
        return ((Scope)this.top).getFlags();
    }

    public void setFlags(int flags) {
        ((Scope)this.top).setFlags(flags);
    }

    public RubyObject getSuperObject() {
        return ((Scope)this.top).getSuperObject();
    }

    public void setSuperObject(RubyObject superObject) {
        ((Scope)this.top).setSuperObject(superObject);
    }

    public List getLocalNames() {
        return ((Scope)this.top).getLocalNames();
    }

    public void setLocalNames(List localName) {
        ((Scope)this.top).setLocalNames(localName);
    }

    public List getLocalValues() {
        return ((Scope)this.top).getLocalValues();
    }

    public void setLocalValues(List localValue) {
        ((Scope)this.top).setLocalValues(localValue);
    }

    public RubyObject getValue(int count) {
        return ((Scope)this.top).getValue(count);
    }

    public void setValue(int count, RubyObject value) {
        ((Scope)this.top).setValue(count, value);
    }
}

