/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;

public class ScriptTestSuite
extends TestSuite {
    public ScriptTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        Ruby ruby = Ruby.getDefaultInstance(null);
        ruby.initLoad(new ArrayList());
        suite.addTest((Test)new ScriptTest(ruby, "testRegexp"));
        suite.addTest((Test)new ScriptTest(ruby, "testStringEval"));
        suite.addTest((Test)new ScriptTest(ruby, "testHereDocument"));
        suite.addTest((Test)new ScriptTest(ruby, "testClass"));
        suite.addTest((Test)new ScriptTest(ruby, "testVariableAndMethod"));
        suite.addTest((Test)new ScriptTest(ruby, "testIf"));
        suite.addTest((Test)new ScriptTest(ruby, "testLoops"));
        suite.addTest((Test)new ScriptTest(ruby, "testMethods"));
        suite.addTest((Test)new ScriptTest(ruby, "testGlobalVars"));
        suite.addTest((Test)new ScriptTest(ruby, "testClasses"));
        suite.addTest((Test)new ScriptTest(ruby, "testNumber"));
        suite.addTest((Test)new ScriptTest(ruby, "testFloat"));
        suite.addTest((Test)new ScriptTest(ruby, "testBlock"));
        suite.addTest((Test)new ScriptTest(ruby, "testRange"));
        suite.addTest((Test)new ScriptTest(ruby, "testString"));
        suite.addTest((Test)new ScriptTest(ruby, "testFile"));
        suite.addTest((Test)new ScriptTest(ruby, "testMarshal"));
        suite.addTest((Test)new ScriptTest(ruby, "testHash"));
        suite.addTest((Test)new ScriptTest(ruby, "testSymbol"));
        suite.addTest((Test)new ScriptTest(ruby, "testRandom"));
        return suite;
    }

    private static class ScriptTest
    extends TestCase {
        private final Ruby ruby;
        private final String filename;
        private final File script;

        public ScriptTest(Ruby ruby, String filename) {
            super(filename);
            this.ruby = ruby;
            this.filename = filename;
            this.script = new File("test/" + filename + ".rb");
        }

        /*
         * WARNING - void declaration
         */
        public void runTest() throws Throwable {
            String line;
            StringBuffer scriptString = new StringBuffer((int)this.script.length());
            BufferedReader br = new BufferedReader(new FileReader(this.script));
            while ((line = br.readLine()) != null) {
                void var3_3;
                scriptString.append((String)var3_3).append('\n');
            }
            br.close();
            scriptString.append("$curtestOK").append('\n');
            RubyBoolean isOk = (RubyBoolean)this.ruby.evalScript(scriptString.toString());
            if (isOk.isFalse()) {
                Assert.fail((String)(this.filename + " failed"));
            }
            System.out.flush();
        }
    }
}

