/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.test;

import java.io.File;
import java.util.ArrayList;
import junit.framework.Assert;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.test.TestRubyBase;

public class TestRuby
extends TestRubyBase {
    public TestRuby(String name) {
        super(name);
    }

    public void setUp() {
        this.ruby = Ruby.getDefaultInstance(null);
    }

    public void testInitLoad() {
        ArrayList<String> list = new ArrayList<String>();
        System.setProperty("jruby.home", "");
        list.add("toto");
        this.ruby.initLoad(list);
        RubyObject lCol = this.ruby.getGlobalVar("$:");
        RubyObject lI = this.ruby.getGlobalVar("$-I");
        RubyObject lLoad = this.ruby.getGlobalVar("$LOAD_PATH");
        Assert.assertTrue((lCol == lI && lI == lLoad && lLoad != null ? 1 : 0) != 0);
        RubyArray lLoadA = (RubyArray)lLoad;
        Assert.assertTrue((RubyNumeric.num2long(lLoadA.nitems()) == 2L ? 1 : 0) != 0);
        this.assertTrue(new RubyString(this.ruby, "toto").equal(lLoadA.shift()));
        this.assertTrue(new RubyString(this.ruby, ".").equal(lLoadA.shift()));
        System.setProperty("jruby.home", "RubyHome");
        this.ruby.initLoad(new ArrayList());
        String wanted = File.separatorChar == '/' ? "RubyHome/lib/ruby/site_ruby/1.6RubyHome/lib/ruby/site_ruby/1.6/javaRubyHome/lib/ruby/site_rubyRubyHome/lib/ruby/1.6RubyHome/lib/ruby/1.6/java." : "RubyHome\\lib\\ruby\\site_ruby\\1.6RubyHome\\lib\\ruby\\site_ruby\\1.6\\javaRubyHome\\lib\\ruby\\site_rubyRubyHome\\lib\\ruby\\1.6RubyHome\\lib\\ruby\\1.6\\java.";
        Assert.assertEquals((Object)wanted, (Object)this.eval("puts $:"));
    }

    public void testFindFile() {
        ArrayList<String> list = new ArrayList<String>();
        this.ruby.initLoad(list);
        list.clear();
        File testFile = new File("fib.rb");
        try {
            this.ruby.findFile(this.ruby, testFile);
            Assert.fail((String)"should have thrown an exception, the file fib.rb is not \t\t\t\t\tin the search path");
        }
        catch (Exception exception) {
            // empty catch block
        }
        list.add("./samples");
        this.ruby.initLoad(list);
        Assert.assertEquals((Object)new File("./samples/fib.rb"), (Object)this.ruby.findFile(this.ruby, testFile));
    }

    public void testVarAndMet() {
        ArrayList list = new ArrayList();
        this.ruby.initLoad(list);
        this.eval("load './test/testVariableAndMethod.rb'");
        Assert.assertEquals((Object)"Hello World", (Object)this.eval("puts($a)"));
        Assert.assertEquals((Object)"dlroW olleH", (Object)this.eval("puts $b"));
        Assert.assertEquals((Object)"Hello World", (Object)this.eval("puts $d.reverse, $c, $e.reverse"));
        Assert.assertEquals((Object)"135 20 3", (Object)this.eval("puts $f, \" \", $g, \" \",  $h"));
    }

    private void assertTrue(RubyObject iObj) {
        Assert.assertTrue((boolean)iObj.isTrue());
    }

    public void tearDown() {
        super.tearDown();
    }
}

