/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIncludedClass;
import org.jruby.RubyMethod;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.AttrSetNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.RubyFrozenException;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.exceptions.TypeError;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.CacheEntry;
import org.jruby.internal.runtime.methods.CallbackMethod;
import org.jruby.internal.runtime.methods.EvaluateMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.internal.runtime.methods.WrapperCallable;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Callback;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.Iter;
import org.jruby.runtime.Namespace;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Asserts;
import org.jruby.util.IdUtil;
import org.jruby.util.RubyHashMap;
import org.jruby.util.RubyMap;
import org.jruby.util.RubyMapMethod;

public class RubyModule
extends RubyObject {
    private RubyClass superClass;
    private String classId;
    private String classPath;
    private RubyMap methods = new RubyHashMap();
    static /* synthetic */ Class class$org$jruby$RubyModule;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;

    public RubyModule(Ruby ruby) {
        this(ruby, null);
    }

    public RubyModule(Ruby ruby, RubyClass rubyClass) {
        this(ruby, rubyClass, null);
    }

    public RubyModule(Ruby ruby, RubyClass rubyClass, RubyClass superClass) {
        super(ruby, rubyClass);
        this.superClass = superClass;
    }

    public RubyClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(RubyClass superClass) {
        this.superClass = superClass;
    }

    public RubyMap getMethods() {
        return this.methods;
    }

    public void setMethods(RubyMap methods) {
        this.methods = methods;
    }

    public boolean isModule() {
        return true;
    }

    public boolean isClass() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isIncluded() {
        return false;
    }

    public static void createModuleClass(RubyClass moduleClass) {
        Callback op_eqq = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_eqq", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject);
        Callback op_cmp = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_cmp", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject);
        Callback op_lt = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_lt", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject);
        Callback op_le = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_le", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject);
        Callback op_gt = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_gt", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject);
        Callback op_ge = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_ge", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject);
        Callback clone = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "rbClone");
        Callback dup = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "dup");
        Callback to_s = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "to_s");
        Callback included_modules = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "included_modules");
        Callback name = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "name");
        Callback ancestors = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "ancestors");
        Callback attr = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "attr", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject);
        Callback attr_reader = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "attr_reader");
        Callback attr_writer = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "attr_writer");
        Callback attr_accessor = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "attr_accessor");
        Callback newModule = CallbackFactory.getSingletonMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "newModule");
        Callback initialize = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "initialize");
        Callback instance_methods = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "instance_methods");
        Callback public_instance_methods = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "instance_methods");
        Callback protected_instance_methods = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "protected_instance_methods");
        Callback private_instance_methods = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "private_instance_methods");
        Callback constants = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "constants");
        Callback const_get = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "const_get", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject);
        Callback const_set = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "const_set", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject, class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject);
        Callback const_defined = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "const_defined", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject);
        Callback class_variables = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "class_variables");
        Callback remove_class_variable = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "remove_class_variable", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject);
        Callback append_features = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "append_features", class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule);
        Callback extend_object = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "extend_object", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject);
        Callback include = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "include");
        Callback rbPublic = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "rbPublic");
        Callback rbProtected = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "rbProtected");
        Callback rbPrivate = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "rbPrivate");
        Callback module_function = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "module_function");
        Callback method_defined = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "method_defined", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject);
        Callback public_class_method = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "public_class_method");
        Callback private_class_method = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "private_class_method");
        Callback module_eval = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "module_eval");
        Callback remove_method = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "remove_method", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject);
        Callback undef_method = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "undef_method", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject);
        Callback alias_method = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "alias_method", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject, class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyModule.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject);
        moduleClass.defineMethod("===", op_eqq);
        moduleClass.defineMethod("<=>", op_cmp);
        moduleClass.defineMethod("<", op_lt);
        moduleClass.defineMethod("<=", op_le);
        moduleClass.defineMethod(">", op_gt);
        moduleClass.defineMethod(">=", op_ge);
        moduleClass.defineMethod("clone", clone);
        moduleClass.defineMethod("dup", dup);
        moduleClass.defineMethod("to_s", to_s);
        moduleClass.defineMethod("included_modules", included_modules);
        moduleClass.defineMethod("name", name);
        moduleClass.defineMethod("ancestors", ancestors);
        moduleClass.definePrivateMethod("attr", attr);
        moduleClass.definePrivateMethod("attr_reader", attr_reader);
        moduleClass.definePrivateMethod("attr_writer", attr_writer);
        moduleClass.definePrivateMethod("attr_accessor", attr_accessor);
        moduleClass.defineSingletonMethod("new", newModule);
        moduleClass.defineMethod("initialize", initialize);
        moduleClass.defineMethod("instance_methods", instance_methods);
        moduleClass.defineMethod("public_instance_methods", public_instance_methods);
        moduleClass.defineMethod("protected_instance_methods", protected_instance_methods);
        moduleClass.defineMethod("private_instance_methods", private_instance_methods);
        moduleClass.defineMethod("constants", constants);
        moduleClass.defineMethod("const_get", const_get);
        moduleClass.defineMethod("const_set", const_set);
        moduleClass.defineMethod("const_defined?", const_defined);
        moduleClass.definePrivateMethod("method_added", CallbackFactory.getNilMethod(1));
        moduleClass.defineMethod("class_variables", class_variables);
        moduleClass.definePrivateMethod("remove_class_variable", remove_class_variable);
        moduleClass.definePrivateMethod("append_features", append_features);
        moduleClass.definePrivateMethod("extend_object", extend_object);
        moduleClass.definePrivateMethod("include", include);
        moduleClass.definePrivateMethod("public", rbPublic);
        moduleClass.definePrivateMethod("protected", rbProtected);
        moduleClass.definePrivateMethod("private", rbPrivate);
        moduleClass.definePrivateMethod("module_function", module_function);
        moduleClass.defineMethod("method_defined?", method_defined);
        moduleClass.defineMethod("public_class_method", public_class_method);
        moduleClass.defineMethod("private_class_method", private_class_method);
        moduleClass.defineMethod("module_eval", module_eval);
        moduleClass.defineMethod("class_eval", module_eval);
        moduleClass.defineMethod("remove_method", remove_method);
        moduleClass.defineMethod("undef_method", undef_method);
        moduleClass.defineMethod("alias_method", alias_method);
        moduleClass.defineSingletonMethod("nesting", CallbackFactory.getSingletonMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "nesting"));
    }

    public String getClassname() {
        RubyModule module = this;
        while (module.isIncluded() || module.isSingleton()) {
            module = module.getSuperClass();
        }
        if (module == null) {
            module = this.getRuntime().getClasses().getObjectClass();
        }
        if (this.classPath == null && this.classId != null) {
            this.classPath = this.classId;
            this.classId = null;
        }
        if (this.classPath == null) {
            return module.findClassPath();
        }
        return this.classPath;
    }

    public String findClassPath() {
        FindClassPathResult arg = new FindClassPathResult();
        arg.klass = this;
        arg.track = this.getRuntime().getClasses().getObjectClass();
        arg.prev = null;
        if (this.getRuntime().getClasses().getObjectClass().getInstanceVariables() != null) {
            this.getRuntime().getClasses().getObjectClass().getInstanceVariables().foreach(new FindClassPathMapMethod(), arg);
        }
        if (arg.name == null) {
            this.getRuntime().getClasses().getClassMap().foreach(new FindClassPathMapMethod(), arg);
        }
        if (arg.name != null) {
            this.classPath = arg.path;
            return arg.path;
        }
        return null;
    }

    public RubyIncludedClass newIncludeClass(RubyClass superClass) {
        return new RubyIncludedClass(this.getRuntime(), superClass, this);
    }

    public void setName(String name) {
        this.classId = name;
    }

    public void setClassPath(RubyModule outer, String name) {
        if (outer == this.getRuntime().getClasses().getObjectClass()) {
            this.classPath = name;
        } else {
            this.classPath = outer.getClassPath();
            this.classPath = this.classPath + "::" + name;
        }
    }

    public String getClassPath() {
        String path = this.getClassname();
        if (path != null) {
            return path;
        }
        String s = "Module";
        if (this.isClass()) {
            s = "Class";
        }
        return "<" + s + " 01x" + Integer.toHexString(System.identityHashCode(this)) + ">";
    }

    public RubyModule getClassVarSingleton() {
        return this;
    }

    public void setClassVar(String name, IRubyObject value) {
        RubyModule tmp = this;
        while (tmp != null) {
            if (tmp.getInstanceVariables() != null && tmp.getInstanceVariables().get(name) != null) {
                if (tmp.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
                    throw new RubySecurityException(this.getRuntime(), "Insecure: can't modify class variable");
                }
                tmp.getInstanceVariables().put(name, value);
                return;
            }
            tmp = tmp.getSuperClass();
        }
        throw new NameError(this.getRuntime(), "uninitialized class variable " + name + " in " + this.toName());
    }

    public void declareClassVar(String name, IRubyObject value) {
        RubyModule tmp = this;
        while (tmp != null) {
            if (tmp.getInstanceVariables() != null && tmp.getInstanceVariables().get(name) != null) {
                if (tmp.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
                    throw new RubySecurityException(this.getRuntime(), "Insecure: can't modify class variable");
                }
                tmp.getInstanceVariables().put(name, value);
            }
            tmp = tmp.getSuperClass();
        }
        this.setAv(name, value, false);
    }

    public IRubyObject getClassVar(String name) {
        RubyModule tmp = this;
        while (tmp != null) {
            if (tmp.getInstanceVariables() != null && tmp.getInstanceVariables().get(name) != null) {
                return (IRubyObject)tmp.getInstanceVariables().get(name);
            }
            tmp = tmp.getSuperClass();
        }
        throw new NameError(this.getRuntime(), "uninitialized class variable " + name + " in " + this.toName());
    }

    public boolean isClassVarDefined(String name) {
        RubyModule tmp = this;
        while (tmp != null) {
            if (tmp.getInstanceVariables() != null && tmp.getInstanceVariables().get(name) != null) {
                return true;
            }
            tmp = tmp.getSuperClass();
        }
        return false;
    }

    public void setConstant(String name, IRubyObject value) {
        this.setAv(name, value, true);
    }

    public IRubyObject getConstant(String name) {
        boolean mod_retry = false;
        RubyModule tmp = this;
        while (true) {
            if (tmp != null) {
                if (!tmp.getInstanceVariable(name).isNil()) {
                    return tmp.getInstanceVariable(name);
                }
                if (tmp == this.getRuntime().getClasses().getObjectClass() && this.getRuntime().getTopConstant(name) != null) {
                    return this.getRuntime().getTopConstant(name);
                }
                tmp = tmp.getSuperClass();
                continue;
            }
            if (mod_retry || !this.isModule()) break;
            mod_retry = true;
            tmp = this.getRuntime().getClasses().getObjectClass();
        }
        String javaClassName = this.getRuntime().getJavaSupport().getJavaName(name);
        if (javaClassName == null) {
            javaClassName = name;
        }
        try {
            Class javaClass = this.getRuntime().getJavaSupport().loadJavaClass(javaClassName);
            return this.getRuntime().getJavaSupport().loadClass(javaClass, null);
        }
        catch (NameError excptn) {
            if (this != this.getRuntime().getClasses().getObjectClass()) {
                throw new NameError(this.getRuntime(), "uninitialized constant " + name + " at " + this.getClassPath());
            }
            throw new NameError(this.getRuntime(), "uninitialized constant " + name);
        }
    }

    public void includeModule(IRubyObject arg) {
        this.testFrozen();
        if (!this.isTaint()) {
            this.runtime.secure(4);
        }
        if (arg == null || arg == this) {
            return;
        }
        if (!(arg instanceof RubyModule)) {
            throw new TypeError(this.runtime, "Wrong argument type " + arg.getInternalClass().toName() + " (expected Module).");
        }
        RubyModule module = (RubyModule)arg;
        boolean changed = false;
        RubyModule type = this;
        block0: while (module != null) {
            if (this.getMethods() == module.getMethods()) {
                throw new ArgumentError(this.runtime, "Cyclic include detected.");
            }
            RubyClass p = this.getSuperClass();
            while (p != null) {
                if (p.isIncluded() && p.getMethods() == module.getMethods()) {
                    type = p;
                    module = module.getSuperClass();
                    continue block0;
                }
                p = p.getSuperClass();
            }
            type.setSuperClass(module.newIncludeClass(type.getSuperClass()));
            type = type.getSuperClass();
            changed = true;
            module = module.getSuperClass();
        }
        if (changed) {
            this.runtime.getMethodCache().clear();
        }
    }

    protected void setAv(String name, IRubyObject value, boolean constant) {
        String dest;
        String string = dest = constant ? "constant" : "class variable";
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw new RubySecurityException(this.getRuntime(), "Insecure: can't set " + dest);
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuntime(), "class/module");
        }
        if (!constant || !this.getInstanceVariable(name).isNil()) {
            // empty if block
        }
        this.setInstanceVariable(name, value);
    }

    public void addMethod(String name, ICallable method) {
        if (this == this.getRuntime().getClasses().getObjectClass()) {
            this.getRuntime().secure(4);
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuntime(), "Insecure: can't define method");
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuntime(), "class/module");
        }
        this.runtime.getMethodCache().clearByName(name);
        this.getMethods().put(name, method);
    }

    public void defineMethod(String name, Callback method) {
        Visibility noex = name.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(name, new CallbackMethod(method, noex));
    }

    public void defineProtectedMethod(String name, Callback method) {
        this.addMethod(name, new CallbackMethod(method, Visibility.PROTECTED));
    }

    public void definePrivateMethod(String name, Callback method) {
        this.addMethod(name, new CallbackMethod(method, Visibility.PRIVATE));
    }

    public void undefMethod(String name) {
        this.addMethod(name, UndefinedMethod.getInstance());
    }

    protected void testFrozen() {
        String desc = "something(?!)";
        if (this.isFrozen()) {
            if (this.isSingleton()) {
                desc = "object";
            } else if (this.isIncluded() || this.isModule()) {
                desc = "module";
            } else if (this.isClass()) {
                desc = "class";
            }
            throw new RubyFrozenException(this.getRuntime(), desc);
        }
    }

    public void undef(String name) {
        ICallable method;
        Ruby ruby = this.getRuntime();
        if (this == ruby.getClasses().getObjectClass()) {
            ruby.secure(4);
        }
        if (ruby.getSafeLevel() >= 4 && !this.isTaint()) {
            throw new SecurityException("Insecure: can't undef");
        }
        this.testFrozen();
        if (name.equals("__id__") || name.equals("__send__")) {
            // empty if block
        }
        if ((method = this.searchMethod(name)).isUndefined()) {
            String s0 = " class";
            RubyModule c = this;
            if (c.isSingleton()) {
                IRubyObject obj = this.getInstanceVariable("__attached__");
                if (obj instanceof RubyModule) {
                    c = (RubyModule)obj;
                    s0 = "";
                }
            } else if (c.isModule()) {
                s0 = " module";
            }
            throw new NameError(ruby, "Undefined method " + name + " for" + s0 + " '" + c.toName() + "'");
        }
        this.addMethod(name, UndefinedMethod.getInstance());
    }

    public void defineModuleFunction(String name, Callback method) {
        this.definePrivateMethod(name, method);
        this.defineSingletonMethod(name, method);
    }

    public void defineAlias(String newName, String oldName) {
        this.aliasMethod(newName, oldName);
    }

    public void defineAttribute(String name, boolean read, boolean write) {
        this.addAttribute(name, read, write, true);
    }

    public boolean isConstantDefined(String name) {
        RubyModule tmp = this;
        while (tmp != null) {
            if (!tmp.getInstanceVariable(name).isNil()) {
                return true;
            }
            tmp = tmp.getSuperClass();
        }
        if (this.isModule()) {
            return this.getRuntime().getClasses().getObjectClass().isConstantDefined(name);
        }
        if (this.getRuntime().isClassDefined(name)) {
            return true;
        }
        return this.runtime.getLoadService().isAutoloadDefined(name);
    }

    public boolean isConstantDefinedAt(String name) {
        if (!this.getInstanceVariable(name).isNil()) {
            return true;
        }
        if (this == this.runtime.getClasses().getObjectClass()) {
            return this.isConstantDefined(name);
        }
        return false;
    }

    public ICallable searchMethod(String name) {
        ICallable method = (ICallable)this.getMethods().get(name);
        if (method == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().searchMethod(name);
            }
            return UndefinedMethod.getInstance();
        }
        method.setImplementationClass(this);
        return method;
    }

    public Visibility getMethodNoex(String name) {
        return this.getMethodBody(name).getVisibility();
    }

    protected CacheEntry getMethodBody(String name) {
        ICallable method = this.searchMethod(name);
        if (method.isUndefined()) {
            this.getRuntime().getMethodCache().saveUndefinedEntry(this, name);
            return null;
        }
        CacheEntry result = new CacheEntry(this, method.getVisibility());
        if (method instanceof AliasMethod) {
            result.setName(name);
            result.setOrigin(((AliasMethod)method).getOrigin());
            result.setOriginalName(((AliasMethod)method).getOldName());
            result.setMethod(((AliasMethod)method).getOldMethod());
            result.setRecvClass(((AliasMethod)method).getOrigin());
        } else {
            result.setName(name);
            result.setOrigin(method.getImplementationClass());
            result.setOriginalName(name);
            result.setMethod(method);
            result.setRecvClass(method.getImplementationClass());
        }
        this.getRuntime().getMethodCache().saveEntry(this, name, result);
        return result;
    }

    public final IRubyObject call(IRubyObject recv, String name, IRubyObject[] args, CallType callType) {
        CacheEntry ent;
        if (args == null) {
            args = new IRubyObject[]{};
        }
        if ((ent = this.getRuntime().getMethodCache().getEntry(this, name)) == null) {
            ent = this.getMethodBody(name);
        }
        if (ent == null || ent.getMethod().isUndefined()) {
            if (callType.isSuper()) {
                throw new NameError(this.runtime, "super: no superclass method '" + name + "'");
            }
            if (callType.isVariable()) {
                this.runtime.getLastCallStatus().setVariable();
            } else {
                this.runtime.getLastCallStatus().setNormal();
            }
            return this.callMethodMissing(recv, name, args);
        }
        RubyModule klass = ent.getOrigin();
        name = ent.getOriginalName();
        ICallable method = ent.getMethod();
        if (!name.equals("method_missing")) {
            if (method.getVisibility().isPrivate() && callType.isNormal()) {
                this.runtime.getLastCallStatus().setPrivate();
                return this.callMethodMissing(recv, name, args);
            }
            if (method.getVisibility().isProtected()) {
                RubyModule defined = klass;
                while (defined.isIncluded()) {
                    defined = defined.getInternalClass();
                }
                if (!this.runtime.getCurrentFrame().getSelf().isKindOf(defined)) {
                    this.runtime.getLastCallStatus().setProtected();
                    return this.callMethodMissing(recv, name, args);
                }
            }
        }
        return klass.call0(recv, name, args, method, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject callMethodMissing(IRubyObject receiver, String name, IRubyObject[] args) {
        if (name == "method_missing") {
            IRubyObject iRubyObject;
            this.runtime.getFrameStack().push();
            try {
                iRubyObject = receiver.method_missing(args);
                Object var6_6 = null;
                this.runtime.getFrameStack().pop();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.runtime.getFrameStack().pop();
                throw throwable;
            }
            return iRubyObject;
        }
        IRubyObject[] newArgs = new IRubyObject[args.length + 1];
        System.arraycopy(args, 0, newArgs, 1, args.length);
        newArgs[0] = RubySymbol.newSymbol(this.runtime, name);
        return receiver.callMethod("method_missing", newArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IRubyObject call0(IRubyObject recv, String name, IRubyObject[] args, ICallable method, boolean noSuper) {
        IRubyObject iRubyObject;
        this.runtime.getIterStack().push(this.runtime.getCurrentIter().isPre() ? Iter.ITER_CUR : Iter.ITER_NOT);
        this.runtime.getFrameStack().push();
        this.runtime.getCurrentFrame().setLastFunc(name);
        this.runtime.getCurrentFrame().setLastClass(noSuper ? null : this);
        this.runtime.getCurrentFrame().setSelf(recv);
        this.runtime.getCurrentFrame().setArgs(args);
        try {
            iRubyObject = method.call(this.runtime, recv, name, args, noSuper);
            Object var8_7 = null;
            this.runtime.getFrameStack().pop();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.runtime.getFrameStack().pop();
            this.runtime.getIterStack().pop();
            throw throwable;
        }
        this.runtime.getIterStack().pop();
        return iRubyObject;
    }

    public void aliasMethod(String name, String oldName) {
        this.testFrozen();
        if (oldName.equals(name)) {
            return;
        }
        if (this == this.getRuntime().getClasses().getObjectClass()) {
            this.getRuntime().secure(4);
        }
        ICallable method = this.searchMethod(oldName);
        RubyModule origin = null;
        if (method.isUndefined()) {
            if (this.isModule()) {
                method = this.getRuntime().getClasses().getObjectClass().searchMethod(oldName);
            }
            if (method.isUndefined()) {
                throw new NameError(this.runtime, "undefined method '" + name + "' for " + (this.isModule() ? "module" : "class") + " '" + this.toName() + "'");
            }
        }
        origin = method.getImplementationClass();
        if (method instanceof AliasMethod) {
            oldName = ((AliasMethod)method).getOldName();
            origin = ((AliasMethod)method).getOrigin();
            method = ((AliasMethod)method).getOldMethod();
        }
        this.getRuntime().getMethodCache().clearByName(name);
        this.getMethods().put(name, new AliasMethod(method, oldName, origin, method.getVisibility()));
    }

    public void removeMethod(String name) {
        if (this == this.getRuntime().getClasses().getObjectClass()) {
            this.getRuntime().secure(4);
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuntime(), "Insecure: can't remove method");
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuntime(), "class/module");
        }
        if (this.getMethods().remove(name) == null) {
            throw new NameError(this.getRuntime(), "method '" + name + "' not defined in " + this.toName());
        }
        this.getRuntime().getMethodCache().clearByName(name);
    }

    public RubyClass defineClassUnder(String name, RubyClass superClass) {
        if (this.isConstantDefinedAt(name)) {
            IRubyObject type = this.getConstant(name);
            if (!(type instanceof RubyClass)) {
                throw new TypeError(this.runtime, name + " is not a class.");
            }
            if (((RubyClass)type).getSuperClass().getRealClass() != superClass) {
                throw new NameError(this.runtime, name + " is already defined.");
            }
            return (RubyClass)type;
        }
        RubyClass newClass = this.getRuntime().defineClass(name, superClass);
        newClass.setClassPath(this, name);
        newClass.inheritedBy(superClass);
        this.setConstant(name, newClass);
        return newClass;
    }

    public RubyModule defineModuleUnder(String name) {
        if (this.isConstantDefinedAt(name)) {
            IRubyObject module = this.getConstant(name);
            if (!(module instanceof RubyModule)) {
                throw new TypeError(this.runtime, this.toName() + "::" + module.getInternalClass().toName() + " is not a module.");
            }
            return (RubyModule)module;
        }
        RubyModule newModule = this.getRuntime().defineModule(name);
        this.setConstant(name, newModule);
        newModule.setClassPath(this, name);
        return newModule;
    }

    public String toName() {
        if (this == this.getRuntime().getClasses().getNilClass()) {
            return "NilClass";
        }
        if (this == this.getRuntime().getClasses().getTrueClass()) {
            return "TrueClass";
        }
        if (this == this.getRuntime().getClasses().getFalseClass()) {
            return "FalseClass";
        }
        return this.getClassPath();
    }

    public void defineConstant(String name, IRubyObject value) {
        if (this == this.getRuntime().getClasses().getClassClass()) {
            this.getRuntime().secure(4);
        }
        if (!IdUtil.isConstant(name)) {
            throw new NameError(this.getRuntime(), "bad constant name " + name);
        }
        this.setConstant(name, value);
    }

    public IRubyObject removeCvar(IRubyObject name) {
        if (!IdUtil.isClassVariable(name.toId())) {
            throw new NameError(this.getRuntime(), "wrong class variable name " + name.toId());
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw new RubySecurityException(this.getRuntime(), "Insecure: can't remove class variable");
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuntime(), "class/module");
        }
        IRubyObject value = (IRubyObject)this.getInstanceVariables().remove(name.toId());
        if (value != null) {
            return value;
        }
        if (this.isClassVarDefined(name.toId())) {
            throw new NameError(this.getRuntime(), "cannot remove " + name.toId() + " for " + this.toName());
        }
        throw new NameError(this.getRuntime(), "class variable " + name.toId() + " not defined for " + this.toName());
    }

    public void defineClassVariable(String name, IRubyObject value) {
        if (!IdUtil.isClassVariable(name)) {
            throw new NameError(this.getRuntime(), "wrong class variable name " + name);
        }
        this.declareClassVar(name, value);
    }

    public void addAttribute(String name, boolean read, boolean write, boolean ex) {
        Visibility attributeScope = Visibility.PUBLIC;
        if (ex && !(attributeScope = this.getRuntime().getCurrentVisibility()).isPrivate() && attributeScope.isModuleFunction()) {
            attributeScope = Visibility.PRIVATE;
        }
        String attrIV = "@" + name;
        if (read) {
            this.addMethod(name, new EvaluateMethod(new InstVarNode(this.getRuntime().getPosition(), attrIV), attributeScope));
            this.callMethod("method_added", RubySymbol.newSymbol(this.getRuntime(), name));
        }
        if (write) {
            name = name + "=";
            this.addMethod(name, new EvaluateMethod(new AttrSetNode(this.getRuntime().getPosition(), attrIV), attributeScope));
            this.callMethod("method_added", RubySymbol.newSymbol(this.getRuntime(), name));
        }
    }

    private RubyArray methodList(boolean option, RubyMapMethod method) {
        RubyArray ary = RubyArray.newArray(this.getRuntime());
        RubyModule klass = this;
        while (klass != null) {
            klass.getMethods().foreach(method, ary);
            if (!option) break;
            klass = klass.getSuperClass();
        }
        Iterator iter = ary.getList().iterator();
        while (iter.hasNext()) {
            if (this.getRuntime().getNil() != iter.next()) continue;
            iter.remove();
            iter.next();
        }
        return ary;
    }

    public void setMethodVisibility(IRubyObject[] methods, Visibility noex) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuntime(), "Insecure: can't change method visibility");
        }
        int i = 0;
        while (i < methods.length) {
            this.exportMethod(methods[i].toId(), noex);
            ++i;
        }
    }

    public void exportMethod(String name, Visibility visibility) {
        ICallable method;
        if (this == this.getRuntime().getClasses().getObjectClass()) {
            this.getRuntime().secure(4);
        }
        if ((method = this.searchMethod(name)).isUndefined() && this.isModule()) {
            method = this.getRuntime().getClasses().getObjectClass().searchMethod(name);
        }
        if (method.isUndefined()) {
            throw new NameError(this.runtime, "undefined method '" + name + "' for " + (this.isModule() ? "module" : "class") + " '" + this.toName() + "'");
        }
        if (method.getVisibility() != visibility) {
            if (this == method.getImplementationClass()) {
                method.setVisibility(visibility);
            } else {
                EvaluateMethod superCall = new EvaluateMethod(new ZSuperNode(this.getRuntime().getPosition()), visibility);
                this.addMethod(name, superCall);
            }
        }
    }

    public boolean isMethodBound(String name, boolean checkVisibility) {
        CacheEntry entry = this.runtime.getMethodCache().getEntry(this, name);
        if (entry == null) {
            entry = this.getMethodBody(name);
        }
        if (entry != null && !entry.getMethod().isUndefined()) {
            return !checkVisibility || !entry.getVisibility().isPrivate();
        }
        return false;
    }

    public boolean isMethodDefined(String name) {
        return this.isMethodBound(name, true);
    }

    /*
     * Unable to fully structure code
     */
    public IRubyObject newMethod(IRubyObject recv, String name, RubyClass methodClass) {
        originalClass = (RubyClass)this;
        originalName = name;
        ent = this.getMethodBody(name);
        if (ent != null) ** GOTO lbl8
        return this.getRuntime().getNil();
lbl-1000:
        // 1 sources

        {
            if ((ent = ent.getOrigin().getSuperClass().getMethodBody(ent.getOriginalName())) != null) continue;
            return this.getRuntime().getNil();
lbl8:
            // 2 sources

            ** while (ent.getMethod() instanceof EvaluateMethod && ((EvaluateMethod)ent.getMethod()).getNode() instanceof ZSuperNode)
        }
lbl9:
        // 1 sources

        newMethod = new RubyMethod(this.getRuntime(), methodClass);
        newMethod.setReceiverClass((RubyClass)ent.getOrigin());
        newMethod.setReceiver(recv);
        newMethod.setMethodId(ent.getOriginalName());
        newMethod.setMethod(ent.getMethod());
        newMethod.setOriginalClass(originalClass);
        newMethod.setOriginalId(originalName);
        return newMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject executeUnder(Callback method, IRubyObject[] args) {
        IRubyObject iRubyObject;
        this.runtime.pushClass(this);
        Frame frame = this.runtime.getCurrentFrame();
        this.runtime.getFrameStack().push();
        this.runtime.getCurrentFrame().setLastFunc(frame.getLastFunc());
        this.runtime.getCurrentFrame().setLastClass(frame.getLastClass());
        this.runtime.getCurrentFrame().setArgs(frame.getArgs());
        if (this.runtime.getCBase() != this) {
            this.runtime.getCurrentFrame().setNamespace(new Namespace(this, this.runtime.getCurrentFrame().getNamespace()));
        }
        this.runtime.setNamespace(new Namespace(this, this.runtime.getNamespace()));
        try {
            iRubyObject = method.execute(this, args);
            Object var6_5 = null;
            this.runtime.setNamespace(this.runtime.getNamespace().getParent());
            this.runtime.getFrameStack().pop();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.runtime.setNamespace(this.runtime.getNamespace().getParent());
            this.runtime.getFrameStack().pop();
            this.runtime.popClass();
            throw throwable;
        }
        this.runtime.popClass();
        return iRubyObject;
    }

    public static RubyModule newModule(Ruby ruby) {
        RubyModule newModule = new RubyModule(ruby, ruby.getClasses().getModuleClass());
        return newModule;
    }

    public RubyString name() {
        String path = this.getClassname();
        if (path != null) {
            return RubyString.newString(this.runtime, path);
        }
        return RubyString.newString(this.runtime, "");
    }

    public RubyArray class_variables() {
        RubyArray ary = RubyArray.newArray(this.getRuntime());
        RubyModule rbModule = this;
        while (rbModule != null) {
            if (rbModule.getInstanceVariables() != null) {
                Iterator iter = rbModule.getInstanceVariables().keySet().iterator();
                while (iter.hasNext()) {
                    RubyString kval;
                    String id = (String)iter.next();
                    if (!IdUtil.isClassVariable(id) || ary.includes(kval = RubyString.newString(this.getRuntime(), id))) continue;
                    ary.append(kval);
                }
            }
            rbModule = rbModule.getSuperClass();
        }
        return ary;
    }

    public IRubyObject rbClone() {
        RubyModule clone = (RubyModule)super.rbClone();
        if (this.getMethods() != null) {
            this.getMethods().foreach(new RubyMapMethod(){

                public int execute(Object key, Object value, Object arg) {
                    ICallable method = (ICallable)value;
                    ((RubyMap)arg).put(key, method);
                    return 0;
                }
            }, clone.getMethods());
        }
        return clone;
    }

    public IRubyObject dup() {
        RubyModule dup = (RubyModule)this.rbClone();
        dup.setInternalClass(this.getInternalClass());
        return dup;
    }

    public RubyArray included_modules() {
        RubyArray ary = RubyArray.newArray(this.getRuntime());
        RubyClass p = this.getSuperClass();
        while (p != null) {
            if (p.isIncluded()) {
                ary.append(((RubyIncludedClass)p).getDelegate());
            }
            p = p.getSuperClass();
        }
        return ary;
    }

    public RubyArray ancestors() {
        RubyArray ary = RubyArray.newArray(this.getRuntime());
        RubyModule p = this;
        while (p != null) {
            if (!p.isSingleton()) {
                if (p.isIncluded()) {
                    ary.append(((RubyIncludedClass)p).getDelegate());
                } else {
                    ary.append(p);
                }
            }
            p = p.getSuperClass();
        }
        return ary;
    }

    public RubyString to_s() {
        return RubyString.newString(this.runtime, this.getClassPath());
    }

    public RubyBoolean op_eqq(IRubyObject obj) {
        return RubyBoolean.newBoolean(this.runtime, obj.isKindOf(this));
    }

    public RubyBoolean op_le(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw new TypeError(this.getRuntime(), "compared with non class/module");
        }
        RubyModule mod = this;
        while (mod != null) {
            if (mod.getMethods() == ((RubyModule)obj).getMethods()) {
                return this.getRuntime().getTrue();
            }
            mod = mod.getSuperClass();
        }
        return this.getRuntime().getFalse();
    }

    public RubyBoolean op_lt(IRubyObject obj) {
        if (obj == this) {
            return this.getRuntime().getFalse();
        }
        return this.op_le(obj);
    }

    public RubyBoolean op_ge(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw new TypeError(this.getRuntime(), "compared with non class/module");
        }
        return ((RubyModule)obj).op_le(this);
    }

    public RubyBoolean op_gt(IRubyObject obj) {
        if (this == obj) {
            return this.getRuntime().getFalse();
        }
        return this.op_ge(obj);
    }

    public RubyFixnum op_cmp(IRubyObject obj) {
        if (this == obj) {
            return RubyFixnum.newFixnum(this.getRuntime(), 0L);
        }
        if (!(obj instanceof RubyModule)) {
            throw new TypeError(this.getRuntime(), "<=> requires Class or Module (" + this.getInternalClass().toName() + " given)");
        }
        if (this.op_le(obj).isTrue()) {
            return RubyFixnum.newFixnum(this.getRuntime(), -1L);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), 1L);
    }

    public IRubyObject initialize(IRubyObject[] args) {
        return this.getRuntime().getNil();
    }

    public static RubyModule newModule(IRubyObject recv) {
        RubyModule mod = RubyModule.newModule(recv.getRuntime());
        mod.setInternalClass((RubyClass)recv);
        recv.getRuntime().getClasses().getModuleClass().callInit(null);
        return mod;
    }

    public static RubyArray nesting(IRubyObject recv) {
        Namespace ns = recv.getRuntime().getCurrentFrame().getNamespace();
        RubyArray ary = RubyArray.newArray(recv.getRuntime());
        while (ns != null && ns.getParent() != null) {
            if (!ns.getNamespaceModule().isNil()) {
                ary.append(ns.getNamespaceModule());
            }
            ns = ns.getParent();
        }
        return ary;
    }

    public IRubyObject attr(IRubyObject symbol, IRubyObject[] args) {
        boolean writeable = false;
        if (args.length > 0) {
            writeable = args[0].isTrue();
        }
        this.addAttribute(symbol.toId(), true, writeable, true);
        return this.getRuntime().getNil();
    }

    public IRubyObject attr_reader(IRubyObject[] args) {
        int i = 0;
        while (i < args.length) {
            this.addAttribute(((RubySymbol)args[i]).toId(), true, false, true);
            ++i;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject attr_writer(IRubyObject[] args) {
        int i = 0;
        while (i < args.length) {
            this.addAttribute(((RubySymbol)args[i]).toId(), false, true, true);
            ++i;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject attr_accessor(IRubyObject[] args) {
        int i = 0;
        while (i < args.length) {
            this.addAttribute(((RubySymbol)args[i]).toId(), true, true, true);
            ++i;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject const_get(IRubyObject symbol) {
        String name = symbol.toId();
        if (!IdUtil.isConstant(name)) {
            throw new NameError(this.getRuntime(), "wrong constant name " + name);
        }
        return this.getConstant(name);
    }

    public IRubyObject const_set(IRubyObject symbol, IRubyObject value) {
        String name = symbol.toId();
        if (!IdUtil.isConstant(name)) {
            throw new NameError(this.getRuntime(), "wrong constant name " + name);
        }
        this.setConstant(name, value);
        return value;
    }

    public RubyBoolean const_defined(IRubyObject symbol) {
        String name = symbol.toId();
        if (!IdUtil.isConstant(name)) {
            throw new NameError(this.getRuntime(), "wrong constant name " + name);
        }
        return RubyBoolean.newBoolean(this.getRuntime(), this.isConstantDefined(name));
    }

    private RubyArray instance_methods(IRubyObject[] args, final Visibility noex) {
        boolean includeSuper = false;
        if (args.length > 0) {
            includeSuper = args[0].isTrue();
        }
        return this.methodList(includeSuper, new RubyMapMethod(){

            public int execute(Object key, Object value, Object arg) {
                String id = (String)key;
                ICallable method = (ICallable)value;
                RubyArray ary = (RubyArray)arg;
                if (method.getVisibility() == noex) {
                    RubyString name = RubyString.newString(RubyModule.this.getRuntime(), id);
                    if (!ary.includes(name)) {
                        if (method == null) {
                            ary.append(RubyModule.this.getRuntime().getNil());
                        }
                        ary.append(name);
                    }
                } else if (method instanceof EvaluateMethod && ((EvaluateMethod)method).getNode() instanceof ZSuperNode) {
                    ary.append(RubyModule.this.getRuntime().getNil());
                    ary.append(RubyString.newString(RubyModule.this.getRuntime(), id));
                }
                return 0;
            }
        });
    }

    public RubyArray instance_methods(IRubyObject[] args) {
        return this.instance_methods(args, Visibility.PUBLIC);
    }

    public RubyArray protected_instance_methods(IRubyObject[] args) {
        return this.instance_methods(args, Visibility.PROTECTED);
    }

    public RubyArray private_instance_methods(IRubyObject[] args) {
        return this.instance_methods(args, Visibility.PRIVATE);
    }

    public RubyArray constants() {
        ArrayList<RubyString> constantNames = new ArrayList<RubyString>();
        Iterator iter = this.getRuntime().getClasses().nameIterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!IdUtil.isConstant(name)) continue;
            constantNames.add(RubyString.newString(this.getRuntime(), name));
        }
        return RubyArray.newArray(this.getRuntime(), constantNames);
    }

    public IRubyObject remove_class_variable(IRubyObject name) {
        Object value;
        String id = name.toId();
        if (!IdUtil.isClassVariable(id)) {
            throw new NameError(this.getRuntime(), "wrong class variable name " + id);
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw new RubySecurityException(this.getRuntime(), "Insecure: can't remove class variable");
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuntime(), "class/module");
        }
        if (this.getInstanceVariables() != null && (value = this.getInstanceVariables().remove(id)) != null) {
            return (IRubyObject)value;
        }
        if (this.isClassVarDefined(id)) {
            throw new NameError(this.getRuntime(), "cannot remove " + id + " for " + this.toName());
        }
        throw new NameError(this.getRuntime(), "class variable " + id + " not defined for " + this.toName());
    }

    public RubyModule append_features(RubyModule module) {
        module.includeModule(this);
        return this;
    }

    public IRubyObject extend_object(IRubyObject obj) {
        obj.extendObject(this);
        return obj;
    }

    public RubyModule include(IRubyObject[] modules) {
        int i = 0;
        while (i < modules.length) {
            modules[i].callMethod("append_features", this);
            ++i;
        }
        return this;
    }

    public RubyModule rbPublic(IRubyObject[] args) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuntime(), "Insecure: can't change method visibility");
        }
        if (args.length == 0) {
            this.getRuntime().setCurrentVisibility(Visibility.PUBLIC);
        } else {
            this.setMethodVisibility(args, Visibility.PUBLIC);
        }
        return this;
    }

    public RubyModule rbProtected(IRubyObject[] args) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuntime(), "Insecure: can't change method visibility");
        }
        if (args.length == 0) {
            this.getRuntime().setCurrentVisibility(Visibility.PROTECTED);
        } else {
            this.setMethodVisibility(args, Visibility.PROTECTED);
        }
        return this;
    }

    public RubyModule rbPrivate(IRubyObject[] args) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuntime(), "Insecure: can't change method visibility");
        }
        if (args.length == 0) {
            this.getRuntime().setCurrentVisibility(Visibility.PRIVATE);
        } else {
            this.setMethodVisibility(args, Visibility.PRIVATE);
        }
        return this;
    }

    public RubyModule module_function(IRubyObject[] args) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuntime(), "Insecure: can't change method visibility");
        }
        if (args.length == 0) {
            this.getRuntime().setCurrentVisibility(Visibility.MODULE_FUNCTION);
        } else {
            this.setMethodVisibility(args, Visibility.PRIVATE);
            int i = 0;
            while (i < args.length) {
                String name = args[i].toId();
                ICallable method = this.searchMethod(name);
                Asserts.assertTrue(!method.isUndefined(), "undefined method '" + name + "'");
                this.getSingletonClass().addMethod(name, new WrapperCallable(method, Visibility.PUBLIC));
                this.callMethod("singleton_method_added", RubySymbol.newSymbol(this.getRuntime(), name));
                ++i;
            }
        }
        return this;
    }

    public RubyBoolean method_defined(IRubyObject symbol) {
        return this.isMethodBound(symbol.toId(), true) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public RubyModule public_class_method(IRubyObject[] args) {
        this.getInternalClass().setMethodVisibility(args, Visibility.PUBLIC);
        return this;
    }

    public RubyModule private_class_method(IRubyObject[] args) {
        this.getInternalClass().setMethodVisibility(args, Visibility.PRIVATE);
        return this;
    }

    public RubyModule alias_method(IRubyObject newId, IRubyObject oldId) {
        this.aliasMethod(newId.toId(), oldId.toId());
        return this;
    }

    public RubyModule undef_method(IRubyObject name) {
        this.undef(name.toId());
        return this;
    }

    public IRubyObject module_eval(IRubyObject[] args) {
        return this.specificEval(this, args);
    }

    public RubyModule remove_method(IRubyObject name) {
        this.removeMethod(name.toId());
        return this;
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(109);
        output.dumpString(this.name().toString());
    }

    public static RubyModule unmarshalFrom(UnmarshalStream input) throws IOException {
        String name = input.unmarshalString();
        Ruby ruby = input.getRuntime();
        RubyModule result = ruby.getClasses().getClassFromPath(name);
        if (result == null) {
            throw new NameError(ruby, "uninitialized constant " + name);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FindClassPathMapMethod
    implements RubyMapMethod {
        private FindClassPathMapMethod() {
        }

        public int execute(Object _key, Object _value, Object _res) {
            String key = (String)_key;
            if (_value instanceof String || _value == null) {
                return 0;
            }
            IRubyObject value = (IRubyObject)_value;
            FindClassPathResult res = (FindClassPathResult)_res;
            String path = null;
            if (!IdUtil.isConstant(key)) {
                return 0;
            }
            if (res.path != null) {
                path = res.path;
                path = path + "::" + key;
            } else {
                path = key;
            }
            if (value == res.klass) {
                res.name = key;
                res.path = path;
                return 1;
            }
            if (value.isKindOf(RubyModule.this.getRuntime().getClasses().getModuleClass())) {
                if (value.getInstanceVariables() == null) {
                    return 0;
                }
                FindClassPathResult list = res;
                while (list != null) {
                    if (list.track == value) {
                        return 0;
                    }
                    list = list.prev;
                }
                FindClassPathResult arg = new FindClassPathResult();
                arg.name = null;
                arg.path = path;
                arg.klass = res.klass;
                arg.track = value;
                arg.prev = res;
                value.getInstanceVariables().foreach(this, arg);
                if (arg.name != null) {
                    res.name = arg.name;
                    res.path = arg.path;
                    return 1;
                }
            }
            return 0;
        }
    }

    private static class FindClassPathResult {
        public String name;
        public RubyModule klass;
        public String path;
        public IRubyObject track;
        public FindClassPathResult prev;

        private FindClassPathResult() {
        }
    }
}

