/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyMatchData;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.TypeError;
import org.jruby.parser.ReOptions;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.regexp.IRegexpAdapter;
import org.jruby.util.Asserts;
import org.jruby.util.PrintfFormat;

public class RubyRegexp
extends RubyObject
implements ReOptions {
    private IRegexpAdapter matcher;
    private String pattern;
    private int options;
    static /* synthetic */ Class class$org$jruby$RubyRegexp;
    static /* synthetic */ Class class$org$jruby$RubyString;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;

    public RubyRegexp(Ruby ruby) {
        super(ruby, ruby.getRubyClass("Regexp"));
        try {
            this.matcher = (IRegexpAdapter)ruby.getRegexpAdapterClass().newInstance();
        }
        catch (Exception ex) {
            Asserts.assertNotReached("Couldn't create regexp adapter");
        }
    }

    public static RubyClass createRegexpClass(Ruby ruby) {
        RubyClass regexpClass = ruby.defineClass("Regexp", ruby.getClasses().getObjectClass());
        regexpClass.defineConstant("IGNORECASE", RubyFixnum.newFixnum(ruby, 1L));
        regexpClass.defineConstant("EXTENDED", RubyFixnum.newFixnum(ruby, 2L));
        regexpClass.defineConstant("MULTILINE", RubyFixnum.newFixnum(ruby, 4L));
        regexpClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyRegexp == null ? (class$org$jruby$RubyRegexp = RubyRegexp.class$("org.jruby.RubyRegexp")) : class$org$jruby$RubyRegexp, "newInstance"));
        regexpClass.defineSingletonMethod("compile", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyRegexp == null ? (class$org$jruby$RubyRegexp = RubyRegexp.class$("org.jruby.RubyRegexp")) : class$org$jruby$RubyRegexp, "newInstance"));
        regexpClass.defineSingletonMethod("quote", CallbackFactory.getSingletonMethod(class$org$jruby$RubyRegexp == null ? (class$org$jruby$RubyRegexp = RubyRegexp.class$("org.jruby.RubyRegexp")) : class$org$jruby$RubyRegexp, "quote", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyRegexp.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        regexpClass.defineSingletonMethod("escape", CallbackFactory.getSingletonMethod(class$org$jruby$RubyRegexp == null ? (class$org$jruby$RubyRegexp = RubyRegexp.class$("org.jruby.RubyRegexp")) : class$org$jruby$RubyRegexp, "quote", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyRegexp.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        regexpClass.defineSingletonMethod("last_match", CallbackFactory.getSingletonMethod(class$org$jruby$RubyRegexp == null ? (class$org$jruby$RubyRegexp = RubyRegexp.class$("org.jruby.RubyRegexp")) : class$org$jruby$RubyRegexp, "last_match_s"));
        regexpClass.defineMethod("initialize", CallbackFactory.getOptMethod(class$org$jruby$RubyRegexp == null ? (class$org$jruby$RubyRegexp = RubyRegexp.class$("org.jruby.RubyRegexp")) : class$org$jruby$RubyRegexp, "initialize"));
        regexpClass.defineMethod("clone", CallbackFactory.getMethod(class$org$jruby$RubyRegexp == null ? (class$org$jruby$RubyRegexp = RubyRegexp.class$("org.jruby.RubyRegexp")) : class$org$jruby$RubyRegexp, "rbClone"));
        regexpClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubyRegexp == null ? (class$org$jruby$RubyRegexp = RubyRegexp.class$("org.jruby.RubyRegexp")) : class$org$jruby$RubyRegexp, "equal", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyRegexp.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        regexpClass.defineMethod("===", CallbackFactory.getMethod(class$org$jruby$RubyRegexp == null ? (class$org$jruby$RubyRegexp = RubyRegexp.class$("org.jruby.RubyRegexp")) : class$org$jruby$RubyRegexp, "match", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyRegexp.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        regexpClass.defineMethod("=~", CallbackFactory.getMethod(class$org$jruby$RubyRegexp == null ? (class$org$jruby$RubyRegexp = RubyRegexp.class$("org.jruby.RubyRegexp")) : class$org$jruby$RubyRegexp, "match", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyRegexp.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        regexpClass.defineMethod("~", CallbackFactory.getMethod(class$org$jruby$RubyRegexp == null ? (class$org$jruby$RubyRegexp = RubyRegexp.class$("org.jruby.RubyRegexp")) : class$org$jruby$RubyRegexp, "match2"));
        regexpClass.defineMethod("match", CallbackFactory.getMethod(class$org$jruby$RubyRegexp == null ? (class$org$jruby$RubyRegexp = RubyRegexp.class$("org.jruby.RubyRegexp")) : class$org$jruby$RubyRegexp, "match_m", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyRegexp.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        regexpClass.defineMethod("inspect", CallbackFactory.getMethod(class$org$jruby$RubyRegexp == null ? (class$org$jruby$RubyRegexp = RubyRegexp.class$("org.jruby.RubyRegexp")) : class$org$jruby$RubyRegexp, "inspect"));
        regexpClass.defineMethod("source", CallbackFactory.getMethod(class$org$jruby$RubyRegexp == null ? (class$org$jruby$RubyRegexp = RubyRegexp.class$("org.jruby.RubyRegexp")) : class$org$jruby$RubyRegexp, "source"));
        regexpClass.defineMethod("casefold?", CallbackFactory.getMethod(class$org$jruby$RubyRegexp == null ? (class$org$jruby$RubyRegexp = RubyRegexp.class$("org.jruby.RubyRegexp")) : class$org$jruby$RubyRegexp, "casefold"));
        return regexpClass;
    }

    public void initialize(String pat, int opts) {
        this.pattern = pat;
        this.options = opts;
        if ((this.options & 1) > 0 || this.getRuntime().getGlobalVar("$=").isTrue()) {
            this.matcher.setCasefold(true);
        }
        if ((this.options & 2) > 0) {
            this.matcher.setExtended(true);
        }
        if ((this.options & 4) > 0) {
            this.matcher.setMultiline(true);
        }
        this.matcher.compile(this.getRuntime(), this.pattern);
    }

    public static String quote(String orig) {
        StringBuffer sb = new StringBuffer(orig.length() * 2);
        int i = 0;
        while (i < orig.length()) {
            char c = orig.charAt(i);
            if ("[]{}()|-*.\\?+^$".indexOf(c) != -1) {
                sb.append('\\');
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    private void recompileIfNeeded() {
        this.checkInitialized();
        boolean globalCF = this.getRuntime().getGlobalVar("$=").isTrue();
        if (globalCF && !this.matcher.getCasefold() || this.matcher.getCasefold() && !globalCF && (this.options & 1) == 0) {
            this.initialize(this.pattern, this.options);
        }
    }

    private void checkInitialized() {
        if (this.matcher == null) {
            throw new TypeError(this.getRuntime(), "uninitialized Regexp");
        }
    }

    public static RubyRegexp regexpValue(IRubyObject obj) {
        if (obj instanceof RubyRegexp) {
            return (RubyRegexp)obj;
        }
        if (obj instanceof RubyString) {
            return RubyRegexp.newRegexp((RubyString)obj, 0);
        }
        throw new ArgumentError(obj.getRuntime(), "can't convert arg to Regexp");
    }

    public static RubyRegexp newRegexp(RubyString str, int options) {
        return RubyRegexp.newRegexp(str.getRuntime(), str.getValue(), options);
    }

    public static RubyRegexp newRegexp(Ruby ruby, String str, int options) {
        RubyRegexp re = new RubyRegexp(ruby);
        re.initialize(str, options);
        return re;
    }

    public static RubyRegexp newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyRegexp re = new RubyRegexp(recv.getRuntime());
        re.setInternalClass((RubyClass)recv);
        re.initialize(args);
        return re;
    }

    public IRubyObject initialize(IRubyObject[] args) {
        String pat = args[0] instanceof RubyRegexp ? ((RubyRegexp)args[0]).source().getValue() : RubyString.stringValue(args[0]).getValue();
        int opts = 0;
        if (args.length > 1) {
            if (args[1] instanceof RubyFixnum) {
                opts = (int)((RubyFixnum)args[1]).getLongValue();
            } else if (args[1].isTrue()) {
                opts |= 1;
            }
        }
        this.initialize(pat, opts);
        return this.getRuntime().getNil();
    }

    public static RubyString quote(IRubyObject recv, RubyString str) {
        String orig = str.getValue();
        RubyString newStr = RubyString.newString(recv.getRuntime(), RubyRegexp.quote(orig));
        newStr.infectBy(str);
        return newStr;
    }

    public static IRubyObject last_match_s(IRubyObject recv) {
        return recv.getRuntime().getBackref();
    }

    public RubyBoolean equal(IRubyObject other) {
        if (other == this) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyRegexp)) {
            return this.getRuntime().getFalse();
        }
        RubyRegexp re = (RubyRegexp)other;
        this.checkInitialized();
        if (!re.source().getValue().equals(this.pattern)) {
            return this.getRuntime().getFalse();
        }
        if (re.casefold().op_xor(this.casefold()).isTrue()) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    public IRubyObject match2() {
        IRubyObject target = this.getRuntime().getLastline();
        if (!(target instanceof RubyString)) {
            return this.getRuntime().getNil();
        }
        return this.match(target);
    }

    public IRubyObject match(IRubyObject target) {
        if (target.isNil()) {
            return this.getRuntime().getFalse();
        }
        int result = this.search(target, 0);
        if (result < 0) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), result);
    }

    public IRubyObject match_m(IRubyObject target) {
        if (target.isNil()) {
            return target;
        }
        IRubyObject result = this.match(target);
        return result.isNil() ? result : ((RubyMatchData)this.runtime.getBackref()).rbClone();
    }

    public RubyString source() {
        this.checkInitialized();
        return RubyString.newString(this.getRuntime(), this.pattern);
    }

    public RubyBoolean casefold() {
        this.checkInitialized();
        return this.matcher.getCasefold() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public static IRubyObject nth_match(int n, IRubyObject match) {
        return match.isNil() ? match : ((RubyMatchData)match).group(n);
    }

    public static IRubyObject last_match(IRubyObject match) {
        return match.isNil() ? match : ((RubyMatchData)match).group(0L);
    }

    public static IRubyObject match_pre(IRubyObject match) {
        return match.isNil() ? match : ((RubyMatchData)match).pre_match();
    }

    public static IRubyObject match_post(IRubyObject match) {
        return match.isNil() ? match : ((RubyMatchData)match).post_match();
    }

    public static IRubyObject match_last(IRubyObject match) {
        if (match.isNil()) {
            return match;
        }
        RubyMatchData md = (RubyMatchData)match;
        long i = md.getSize() - 1L;
        while (i > 0L) {
            if (!md.group(i).isNil()) {
                return md.group(i);
            }
            --i;
        }
        return md.getRuntime().getNil();
    }

    public int search(IRubyObject target, int pos) {
        String str = RubyString.stringValue(target).getValue();
        if (pos > str.length()) {
            return -1;
        }
        this.recompileIfNeeded();
        IRubyObject result = this.matcher.search(this.getRuntime(), str, pos);
        this.getRuntime().setBackref(result);
        return result instanceof RubyMatchData ? ((RubyMatchData)result).matchStartPosition() : -1;
    }

    public IRubyObject regsub(IRubyObject str, RubyMatchData match) {
        String repl = RubyString.stringValue(str).getValue();
        StringBuffer sb = new StringBuffer("");
        int pos = 0;
        int end = repl.length();
        IRubyObject ins = this.getRuntime().getNil();
        block8: while (pos < end) {
            char c;
            if ((c = repl.charAt(pos++)) == '\\' && pos < end) {
                c = repl.charAt(pos++);
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        ins = match.group(c - 48);
                        break;
                    }
                    case '&': {
                        ins = match.group(0L);
                        break;
                    }
                    case '`': {
                        ins = match.pre_match();
                        break;
                    }
                    case '\'': {
                        ins = match.post_match();
                        break;
                    }
                    case '+': {
                        ins = RubyRegexp.match_last(match);
                        break;
                    }
                    case '\\': {
                        sb.append(c);
                        continue block8;
                    }
                    default: {
                        sb.append('\\').append(c);
                        continue block8;
                    }
                }
                if (ins.isNil()) continue;
                sb.append(((RubyString)ins).getValue());
                ins = this.getRuntime().getNil();
                continue;
            }
            sb.append(c);
        }
        return RubyString.newString(this.getRuntime(), sb.toString());
    }

    public IRubyObject rbClone() {
        return RubyRegexp.newRegexp(this.source(), this.options);
    }

    public RubyString inspect() {
        int length = this.pattern.length();
        StringBuffer sb = new StringBuffer(length + 2);
        sb.append('/');
        int i = 0;
        while (i < length) {
            char c = this.pattern.charAt(i);
            if (RubyString.isAlnum(c)) {
                sb.append(c);
            } else if (c == '/') {
                sb.append('\\').append(c);
            } else if (RubyString.isPrint(c)) {
                sb.append(c);
            } else if (c == '\n') {
                sb.append('\\').append('n');
            } else if (c == '\r') {
                sb.append('\\').append('r');
            } else if (c == '\t') {
                sb.append('\\').append('t');
            } else if (c == '\f') {
                sb.append('\\').append('f');
            } else if (c == '\u000b') {
                sb.append('\\').append('v');
            } else if (c == '\u0007') {
                sb.append('\\').append('a');
            } else if (c == '\u001b') {
                sb.append('\\').append('e');
            } else {
                sb.append(new PrintfFormat("\\%.3o").sprintf(c));
            }
            ++i;
        }
        sb.append('/');
        if ((this.options & 1) > 0) {
            sb.append('i');
        }
        if ((this.options & 4) > 0) {
            sb.append('m');
        }
        if ((this.options & 2) > 0) {
            sb.append('x');
        }
        return RubyString.newString(this.getRuntime(), sb.toString());
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(47);
        output.dumpString(this.pattern);
        output.dumpInt(this.options);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

