/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.IndexedCallback;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Asserts;

public class RubySymbol
extends RubyObject
implements IndexCallable {
    private static int lastId = 0;
    private final String symbol;
    private final int id;
    private static final int M_TO_I = 2;
    private static final int M_TO_S = 3;
    private static final int M_EQUAL = 4;
    private static final int M_HASH = 5;
    private static final int M_INSPECT = 6;
    private static final int M_CLONE = 7;
    static /* synthetic */ Class class$org$jruby$RubySymbol;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubySymbol(Ruby ruby, String symbol) {
        super(ruby, ruby.getClasses().getSymbolClass());
        this.symbol = symbol;
        Class clazz = class$org$jruby$RubySymbol == null ? (class$org$jruby$RubySymbol = RubySymbol.class$("org.jruby.RubySymbol")) : class$org$jruby$RubySymbol;
        synchronized (clazz) {
            this.id = ++lastId;
        }
    }

    public String toId() {
        return this.symbol;
    }

    public static RubySymbol nilSymbol(Ruby ruby) {
        return RubySymbol.newSymbol(ruby, null);
    }

    public static RubyClass createSymbolClass(Ruby ruby) {
        RubyClass symbolClass = ruby.defineClass("Symbol", ruby.getClasses().getObjectClass());
        symbolClass.getInternalClass().undefMethod("new");
        symbolClass.defineMethod("to_i", IndexedCallback.create(2, 0));
        symbolClass.defineMethod("to_int", IndexedCallback.create(2, 0));
        symbolClass.defineMethod("id2name", IndexedCallback.create(3, 0));
        symbolClass.defineMethod("to_s", IndexedCallback.create(3, 0));
        symbolClass.defineMethod("==", IndexedCallback.create(4, 1));
        symbolClass.defineMethod("hash", IndexedCallback.create(5, 0));
        symbolClass.defineMethod("inspect", IndexedCallback.create(6, 0));
        symbolClass.defineMethod("dup", IndexedCallback.create(7, 0));
        symbolClass.defineMethod("clone", IndexedCallback.create(7, 0));
        symbolClass.defineMethod("freeze", CallbackFactory.getSelfMethod(0));
        symbolClass.defineMethod("taint", CallbackFactory.getSelfMethod(0));
        return symbolClass;
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 3: {
                return this.to_s();
            }
            case 2: {
                return this.to_i();
            }
            case 4: {
                return this.equal(args[0]);
            }
            case 5: {
                return this.hash();
            }
            case 6: {
                return this.inspect();
            }
            case 7: {
                return this.rbClone();
            }
        }
        Asserts.assertNotReached();
        return null;
    }

    public static RubySymbol getSymbol(Ruby ruby, long id) {
        RubySymbol result = ruby.symbolTable.lookup(id);
        if (result == null) {
            return RubySymbol.nilSymbol(ruby);
        }
        return result;
    }

    public static RubySymbol newSymbol(Ruby ruby, String name) {
        RubySymbol result = ruby.symbolTable.lookup(name);
        if (result == null) {
            result = name == null ? new RubySymbol(ruby, null){

                public boolean isNil() {
                    return true;
                }
            } : new RubySymbol(ruby, name);
            ruby.symbolTable.store(result);
        }
        return result;
    }

    public RubyFixnum to_i() {
        return RubyFixnum.newFixnum(this.runtime, this.id);
    }

    public RubyString inspect() {
        return RubyString.newString(this.getRuntime(), ":" + this.symbol);
    }

    public RubyString to_s() {
        return RubyString.newString(this.getRuntime(), this.symbol);
    }

    public RubyBoolean equal(IRubyObject other) {
        return RubyBoolean.newBoolean(this.runtime, this == other);
    }

    public RubyFixnum hash() {
        return RubyFixnum.newFixnum(this.runtime, this.symbol.hashCode());
    }

    public IRubyObject rbClone() {
        throw new TypeError(this.getRuntime(), "can't clone Symbol");
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(58);
        output.dumpString(this.symbol);
    }

    public static RubySymbol unmarshalFrom(UnmarshalStream input) throws IOException {
        return RubySymbol.newSymbol(input.getRuntime(), input.unmarshalString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        M_TO_I = 2;
        M_TO_S = 3;
        M_EQUAL = 4;
        M_HASH = 5;
        M_INSPECT = 6;
        M_CLONE = 7;
    }

    public static class SymbolTable {
        private ReferenceQueue unusedSymbols = new ReferenceQueue();
        private Map table = new HashMap();

        public RubySymbol lookup(String name) {
            this.clean();
            WeakSymbolEntry ref = (WeakSymbolEntry)this.table.get(name);
            if (ref == null) {
                return null;
            }
            return (RubySymbol)ref.get();
        }

        public RubySymbol lookup(long symbolId) {
            Iterator iter = this.table.values().iterator();
            while (iter.hasNext()) {
                WeakSymbolEntry entry = (WeakSymbolEntry)iter.next();
                RubySymbol symbol = (RubySymbol)entry.get();
                if (symbol == null || (long)symbol.id != symbolId) continue;
                return symbol;
            }
            return null;
        }

        public void store(RubySymbol symbol) {
            this.clean();
            this.table.put(symbol.toId(), new WeakSymbolEntry(symbol));
        }

        /*
         * WARNING - void declaration
         */
        private void clean() {
            WeakSymbolEntry ref;
            while ((ref = (WeakSymbolEntry)this.unusedSymbols.poll()) != null) {
                void var1_1;
                this.table.remove(((WeakSymbolEntry)var1_1).name());
            }
        }

        private class WeakSymbolEntry
        extends WeakReference {
            private final String name;

            public WeakSymbolEntry(RubySymbol symbol) {
                super(symbol, SymbolTable.this.unusedSymbols);
                this.name = symbol.toId();
            }

            private String name() {
                return this.name;
            }
        }
    }
}

