/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyJavaObject;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.IOError;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Callback;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Asserts;

public class JavaMethod
implements Callback {
    private Method[] methods = null;
    private boolean callSuper = false;
    private boolean singleton = false;

    public JavaMethod(Method[] methods, boolean callSuper) {
        this(methods, callSuper, false);
    }

    public JavaMethod(Method[] methods, boolean callSuper, boolean singleton) {
        this.methods = methods;
        this.callSuper = callSuper;
        this.singleton = singleton;
    }

    public int getArity() {
        return -1;
    }

    public IRubyObject execute(IRubyObject recv, IRubyObject[] args) {
        Method method = this.findMatchingMethod(args);
        if (method == null) {
            if (this.callSuper) {
                return recv.getRuntime().getRuntime().callSuper(args);
            }
            throw new ArgumentError(recv.getRuntime(), "wrong argument count or types.");
        }
        int argsLength = args != null ? args.length : 0;
        Object[] newArgs = new Object[argsLength];
        int i = 0;
        while (i < argsLength) {
            newArgs[i] = JavaUtil.convertRubyToJava(recv.getRuntime(), args[i], method.getParameterTypes()[i]);
            ++i;
        }
        try {
            Object receiver = !this.singleton ? ((RubyJavaObject)recv).getValue() : null;
            return JavaUtil.convertJavaToRuby(recv.getRuntime(), method.invoke(receiver, newArgs));
        }
        catch (InvocationTargetException itExcptn) {
            JavaMethod.convertException(recv.getRuntime(), (Exception)itExcptn.getTargetException());
            return recv.getRuntime().getNil();
        }
        catch (Exception excptn) {
            Asserts.assertNotReached();
            return null;
        }
    }

    private static void convertException(Ruby ruby, Exception e) {
        if (e instanceof RaiseException) {
            throw (RaiseException)e;
        }
        if (e instanceof IOException) {
            throw IOError.fromException(ruby, (IOException)e);
        }
        ruby.getJavaSupport().handleNativeException(e);
    }

    private Method findMatchingMethod(IRubyObject[] args) {
        ArrayList<Method> executeMethods = new ArrayList<Method>(this.methods.length);
        int i = 0;
        while (i < this.methods.length) {
            Method method = this.methods[i];
            if (JavaMethod.hasMatchingArguments(method, args)) {
                executeMethods.add(method);
            }
            ++i;
        }
        if (executeMethods.isEmpty()) {
            return null;
        }
        return (Method)executeMethods.get(0);
    }

    private static boolean hasMatchingArgumentCount(Method method, int expected) {
        return method.getParameterTypes().length == expected;
    }

    private static boolean hasMatchingArguments(Method method, IRubyObject[] args) {
        int expectedLength;
        int n = expectedLength = args != null ? args.length : 0;
        if (!JavaMethod.hasMatchingArgumentCount(method, expectedLength)) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            if (!JavaUtil.isCompatible(args[i], parameterTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

