/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Callback;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.AssertError;
import org.jruby.util.Asserts;

public final class ReflectionCallbackMethod
implements Callback {
    private Class klass = null;
    private String methodName = null;
    private Class[] args = null;
    private boolean isStaticMethod = false;
    private boolean isRestArgs = false;
    private int arity;
    private Method method = null;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;

    public ReflectionCallbackMethod(Class klass, String methodName, Class[] args, boolean isRestArgs, boolean isStaticMethod, int arity) {
        this.klass = klass;
        this.methodName = methodName;
        this.args = args != null ? args : new Class[]{};
        this.isRestArgs = isRestArgs;
        this.isStaticMethod = isStaticMethod;
        this.arity = arity;
    }

    public int getArity() {
        return this.arity;
    }

    protected Method getMethod() {
        if (this.method == null) {
            try {
                Class[] newArgs = this.args;
                if (this.isStaticMethod) {
                    newArgs = new Class[this.args.length + 1];
                    System.arraycopy(this.args, 0, newArgs, 1, this.args.length);
                    newArgs[0] = class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = ReflectionCallbackMethod.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject;
                }
                this.method = this.klass.getMethod(this.methodName, newArgs);
            }
            catch (NoSuchMethodException nsmExcptn) {
                throw new RuntimeException("NoSuchMethodException: Cannot get method \"" + this.methodName + "\" in class \"" + this.klass.getName() + "\" by Reflection.");
            }
            catch (SecurityException sExcptn) {
                throw new RuntimeException("SecurityException: Cannot get method \"" + this.methodName + "\" in class \"" + this.klass.getName() + "\" by Reflection.");
            }
        }
        return this.method;
    }

    protected void testArgsCount(Ruby ruby, IRubyObject[] methodArgs) {
        if (this.isRestArgs ? methodArgs.length < this.args.length - 1 : methodArgs.length != this.args.length) {
            throw new ArgumentError(ruby, this.getExpectedArgsString(methodArgs));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected IRubyObject invokeMethod(IRubyObject recv, Object[] methodArgs) {
        block7: {
            reflectionArguments = this.packageArgumentsForReflection(methodArgs, recv);
            try {
                return (IRubyObject)this.getMethod().invoke((Object)(this.isStaticMethod != false ? null : recv), reflectionArguments);
            }
            catch (InvocationTargetException itExcptn) {
                if (itExcptn.getTargetException() instanceof RaiseException) {
                    throw (RaiseException)itExcptn.getTargetException();
                }
                if (itExcptn.getTargetException() instanceof JumpException) {
                    throw (JumpException)itExcptn.getTargetException();
                }
                recv.getRuntime().getJavaSupport().handleNativeException((Exception)itExcptn.getTargetException());
                return recv.getRuntime().getNil();
            }
            catch (IllegalAccessException iaExcptn) {
                message = new StringBuffer();
                message.append(iaExcptn.getMessage());
                message.append(':');
                message.append(" methodName=").append(this.methodName);
                message.append(" recv=").append(recv.toString());
                message.append(" klass=").append(this.klass.getName());
                message.append(" methodArgs=[");
                i = 0;
                ** while (i < methodArgs.length)
            }
lbl-1000:
            // 1 sources

            {
                message.append(methodArgs[i]);
                message.append(' ');
                ++i;
                continue;
            }
lbl33:
            // 1 sources

            break block7;
            catch (IllegalArgumentException iaExcptn) {
                throw new RaiseException(recv.getRuntime(), "TypeError", iaExcptn.getMessage());
            }
        }
        message.append(']');
        Asserts.assertNotReached(message.toString());
        throw new AssertError("[BUG] Run again with Asserts.ENABLE_ASSERT=true");
    }

    public IRubyObject execute(IRubyObject recv, IRubyObject[] args) {
        args = args != null ? args : new IRubyObject[]{};
        this.testArgsCount(recv.getRuntime(), args);
        return this.invokeMethod(recv, args);
    }

    private Object[] packageArgumentsForReflection(Object[] arguments, IRubyObject rubyClass) {
        Object[] result = arguments;
        if (this.isRestArgs) {
            result = this.packageRestArgumentsForReflection(result);
        }
        if (this.isStaticMethod) {
            result = this.packageStaticArgumentsForReflection(result, rubyClass.getRuntime(), rubyClass);
        }
        return result;
    }

    private Object[] packageStaticArgumentsForReflection(Object[] arguments, Ruby ruby, IRubyObject rubyClass) {
        Object[] result = new Object[arguments.length + 1];
        result[0] = rubyClass;
        System.arraycopy(arguments, 0, result, 1, arguments.length);
        return result;
    }

    private final Object[] packageRestArgumentsForReflection(Object[] originalArgs) {
        IRubyObject[] restArray = new IRubyObject[originalArgs.length - (this.args.length - 1)];
        Object[] result = new Object[this.args.length];
        try {
            System.arraycopy(originalArgs, this.args.length - 1, restArray, 0, originalArgs.length - (this.args.length - 1));
        }
        catch (ArrayIndexOutOfBoundsException aioobExcptn) {
            throw new RuntimeException("Cannot call \"" + this.methodName + "\" in class \"" + this.klass.getName() + "\". " + this.getExpectedArgsString((IRubyObject[])originalArgs));
        }
        System.arraycopy(originalArgs, 0, result, 0, this.args.length - 1);
        result[this.args.length - 1] = restArray;
        return result;
    }

    protected String getExpectedArgsString(IRubyObject[] methodArgs) {
        String className;
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("Wrong arguments:");
        if (methodArgs.length == 0) {
            sb.append(" No args");
        } else {
            sb.append(" (");
            i = 0;
            while (i < methodArgs.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                className = methodArgs[i].getType().toName();
                sb.append("a");
                if (className.charAt(0) == 'A' || className.charAt(0) == 'E' || className.charAt(0) == 'I' || className.charAt(0) == 'O' || className.charAt(0) == 'U') {
                    sb.append("n");
                }
                sb.append(className);
                ++i;
            }
            sb.append(")");
        }
        sb.append(" given, ");
        if (this.args.length == 0) {
            sb.append("no arguments excepted.");
        } else {
            sb.append("(");
            i = 0;
            while (i < this.args.length) {
                if (i > 0) {
                    sb.append(",");
                }
                className = this.args[i].getName();
                sb.append("a").append(className.substring(className.lastIndexOf(".Ruby") + 5));
                ++i;
            }
            if (this.isRestArgs) {
                sb.append(", ...");
            }
            sb.append(") excepted.");
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

