/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.test;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import junit.framework.TestCase;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.RubyString;

public class TestRubyBase
extends TestCase {
    private PipedInputStream pipeIn;
    private PipedOutputStream pos;
    private BufferedReader in;
    protected Ruby ruby;
    private PrintStream out;

    public TestRubyBase(String name) {
        super(name);
    }

    protected String eval(String script) throws Exception {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        this.out = new PrintStream(result);
        RubyIO lStream = new RubyIO(this.ruby);
        lStream.initIO(null, this.out, null);
        this.ruby.setGlobalVar("$stdout", lStream);
        this.ruby.setGlobalVar("$>", lStream);
        lStream = (RubyIO)this.ruby.getGlobalVar("$stderr");
        lStream.initIO(null, this.out, null);
        this.ruby.setGlobalVar("$stderr", lStream);
        this.ruby.getRuntime().loadScript(RubyString.newString(this.ruby, "test"), RubyString.newString(this.ruby, script), false);
        StringBuffer sb = new StringBuffer(new String(result.toByteArray()));
        int idx = sb.indexOf("\n");
        while (idx != -1) {
            sb.deleteCharAt(idx);
            idx = sb.indexOf("\n");
        }
        return sb.toString();
    }

    public void tearDown() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class EvalThread
    extends Thread {
        private RubyString name;
        private RubyString script;

        EvalThread(String name, String script) {
            this.name = RubyString.newString(TestRubyBase.this.ruby, name);
            this.script = RubyString.newString(TestRubyBase.this.ruby, script);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                TestRubyBase.this.ruby.getRuntime().loadScript(this.name, this.script, false);
                Object var2_1 = null;
                TestRubyBase.this.out.close();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                TestRubyBase.this.out.close();
                throw throwable;
            }
        }
    }
}

