/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.test;

import java.util.Date;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyTime;
import org.jruby.runtime.builtin.IRubyObject;

public class TestRubyTime
extends TestCase {
    private Ruby ruby;
    private RubyClass rubyTime;
    private RubyTime nineTeenSeventy;

    public TestRubyTime(String name) {
        super(name);
    }

    public void setUp() {
        if (this.ruby == null) {
            this.ruby = Ruby.getDefaultInstance(null);
        }
        this.rubyTime = this.ruby.getClasses().getTimeClass();
        IRubyObject[] args = new IRubyObject[]{RubyFixnum.newFixnum(this.ruby, 18000000L)};
        this.nineTeenSeventy = RubyTime.s_at(this.rubyTime, args);
    }

    public void testTimeCreated() {
        Assert.assertTrue((this.rubyTime != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.rubyTime.getClassname(), (Object)"Time");
    }

    public void testTimeNow() {
        RubyTime myTime = RubyTime.s_new(this.rubyTime);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Unexpected InterruptedException");
        }
        Date now = new Date();
        Assert.assertTrue((boolean)now.after(myTime.getJavaDate()));
    }

    public void testTimeAt() {
        Date myDate = new Date(18000000L);
        Assert.assertEquals((Object)myDate, (Object)this.nineTeenSeventy.getJavaDate());
    }

    public void testGmtimeAndZone() {
        Date myDate = new Date(18000000L);
        Assert.assertEquals((Object)"GMT", (Object)this.nineTeenSeventy.gmtime().zone().getValue());
    }
}

