/*
 * Decompiled with CFR 0.152.
 */
package org.ablaf.internal.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ablaf.common.IAdaptable;
import org.ablaf.common.IAdapterFactory;
import org.ablaf.common.IAdapterManager;

public class DefaultAdapterManager
implements IAdapterManager {
    private Map factoryMap = new HashMap(5);

    private void addFactoryToMap(IAdapterFactory factory, Class adaptable) {
        int i = 0;
        while (i < factory.getAdapterList().length) {
            Class adapterType = factory.getAdapterList()[i];
            this.factoryMap.put(new FactoryMapKey(adaptable, adapterType), factory);
            ++i;
        }
    }

    private void removeFactoryFromMap(IAdapterFactory factory, Class adaptable) {
        int i = 0;
        while (i < factory.getAdapterList().length) {
            Class adapterType = factory.getAdapterList()[i];
            this.factoryMap.remove(new FactoryMapKey(adaptable, adapterType));
            ++i;
        }
    }

    public Object getAdapter(IAdaptable adaptableObject, Class adapterType) {
        IAdapterFactory factory = (IAdapterFactory)this.factoryMap.get(new FactoryMapKey(adaptableObject.getClass(), adapterType));
        if (factory != null) {
            return factory.getAdapter(adaptableObject, adapterType);
        }
        return null;
    }

    public void registerAdapters(IAdapterFactory factory, Class adaptable) {
        this.addFactoryToMap(factory, adaptable);
    }

    public void unregisterAdapters(IAdapterFactory factory) {
        Iterator iter = this.factoryMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getValue() != factory) continue;
            iter.remove();
        }
    }

    public void unregisterAdapters(IAdapterFactory factory, Class adaptable) {
        this.removeFactoryFromMap(factory, adaptable);
    }

    private static class FactoryMapKey {
        private Class adaptable;
        private Class adapterType;

        public FactoryMapKey(Class adaptable, Class adapterType) {
            this.adaptable = adaptable;
            this.adapterType = adapterType;
        }

        public boolean equals(Object other) {
            if (other instanceof FactoryMapKey) {
                return this.adaptable == ((FactoryMapKey)other).adaptable && this.adapterType == ((FactoryMapKey)other).adapterType;
            }
            return false;
        }

        public int hashCode() {
            return this.adaptable.hashCode() ^ this.adapterType.hashCode();
        }
    }
}

