/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.EOFError;
import org.jruby.exceptions.IOError;
import org.jruby.exceptions.NotImplementedError;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.SystemExit;
import org.jruby.exceptions.ThreadError;
import org.jruby.exceptions.ThrowJump;
import org.jruby.exceptions.TypeError;
import org.jruby.internal.runtime.builtin.definitions.KernelDefinition;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.runtime.load.ILoadService;

public class KernelModule {
    public static RubyModule createKernelModule(Ruby runtime) {
        return new KernelDefinition(runtime).getModule();
    }

    public static IRubyObject autoload(IRubyObject recv, IRubyObject symbol, final IRubyObject file) {
        final ILoadService loadService = recv.getRuntime().getLoadService();
        loadService.addAutoload(symbol.asSymbol(), new IAutoloadMethod(){

            public IRubyObject load(Ruby runtime, String name) {
                loadService.require(file.toString());
                return runtime.getClasses().getObjectClass().getConstant(name);
            }
        });
        return recv;
    }

    public static IRubyObject open(IRubyObject recv, IRubyObject[] args) {
        if (args[0].toString().startsWith("|")) {
            return recv.getRuntime().getNil();
        }
        return RubyFile.open(recv.getRuntime().getClasses().getFileClass(), args);
    }

    public static RubyString gets(IRubyObject recv, IRubyObject[] args) {
        RubyArgsFile argsFile = (RubyArgsFile)recv.getRuntime().getGlobalVariables().get("$<");
        RubyString line = argsFile.internalGets(args);
        recv.getRuntime().setLastline(line);
        return line;
    }

    public static IRubyObject p(IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
        int i = 0;
        while (i < args.length) {
            if (args[i] != null) {
                defout.callMethod("write", args[i].callMethod("inspect"));
                defout.callMethod("write", RubyString.newString(recv.getRuntime(), "\n"));
            }
            ++i;
        }
        return recv.getRuntime().getNil();
    }

    public static IRubyObject puts(IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
        RubyIO.puts(defout, args);
        return recv.getRuntime().getNil();
    }

    public static IRubyObject print(IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
        RubyIO.print(defout, args);
        return recv.getRuntime().getNil();
    }

    public static IRubyObject printf(IRubyObject recv, IRubyObject[] args) {
        if (args.length != 0) {
            IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
            if (!(args[0] instanceof RubyString)) {
                defout = args[0];
                IRubyObject[] newArgs = new IRubyObject[args.length - 1];
                System.arraycopy(args, 1, newArgs, 0, args.length - 1);
                args = newArgs;
            }
            RubyIO.printf(defout, args);
        }
        return recv.getRuntime().getNil();
    }

    public static RubyString readline(IRubyObject recv, IRubyObject[] args) {
        RubyString line = KernelModule.gets(recv, args);
        if (line.isNil()) {
            throw new EOFError(recv.getRuntime());
        }
        return line;
    }

    public static RubyArray readlines(IRubyObject recv, IRubyObject[] args) {
        RubyArgsFile argsFile = (RubyArgsFile)recv.getRuntime().getGlobalVariables().get("$<");
        RubyArray lines = RubyArray.newArray(recv.getRuntime());
        RubyString line = argsFile.internalGets(args);
        while (!line.isNil()) {
            lines.append(line);
            line = argsFile.internalGets(args);
        }
        return lines;
    }

    private static RubyString getLastlineString(Ruby ruby) {
        IRubyObject line = ruby.getLastline();
        if (line.isNil()) {
            throw new TypeError(ruby, "$_ value need to be String (nil given).");
        }
        if (!(line instanceof RubyString)) {
            throw new TypeError(ruby, "$_ value need to be String (" + line.getMetaClass().toName() + " given).");
        }
        return (RubyString)line;
    }

    public static IRubyObject sub_bang(IRubyObject recv, IRubyObject[] args) {
        return KernelModule.getLastlineString(recv.getRuntime()).sub_bang(args);
    }

    public static IRubyObject sub(IRubyObject recv, IRubyObject[] args) {
        RubyString str = (RubyString)KernelModule.getLastlineString(recv.getRuntime()).dup();
        if (!str.sub_bang(args).isNil()) {
            recv.getRuntime().setLastline(str);
        }
        return str;
    }

    public static IRubyObject gsub_bang(IRubyObject recv, IRubyObject[] args) {
        return KernelModule.getLastlineString(recv.getRuntime()).gsub_bang(args);
    }

    public static IRubyObject gsub(IRubyObject recv, IRubyObject[] args) {
        RubyString str = (RubyString)KernelModule.getLastlineString(recv.getRuntime()).dup();
        if (!str.gsub_bang(args).isNil()) {
            recv.getRuntime().setLastline(str);
        }
        return str;
    }

    public static IRubyObject chop_bang(IRubyObject recv) {
        return KernelModule.getLastlineString(recv.getRuntime()).chop_bang();
    }

    public static IRubyObject chop(IRubyObject recv) {
        RubyString str = KernelModule.getLastlineString(recv.getRuntime());
        if (str.getValue().length() > 0) {
            str = (RubyString)str.dup();
            str.chop_bang();
            recv.getRuntime().setLastline(str);
        }
        return str;
    }

    public static IRubyObject chomp_bang(IRubyObject recv, IRubyObject[] args) {
        return KernelModule.getLastlineString(recv.getRuntime()).chomp_bang(args);
    }

    public static IRubyObject chomp(IRubyObject recv, IRubyObject[] args) {
        RubyString str = KernelModule.getLastlineString(recv.getRuntime());
        RubyString dup = (RubyString)str.dup();
        if (dup.chomp_bang(args).isNil()) {
            return str;
        }
        recv.getRuntime().setLastline(dup);
        return str;
    }

    public static IRubyObject split(IRubyObject recv, IRubyObject[] args) {
        return KernelModule.getLastlineString(recv.getRuntime()).split(args);
    }

    public static IRubyObject scan(IRubyObject recv, IRubyObject pattern) {
        return KernelModule.getLastlineString(recv.getRuntime()).scan(pattern);
    }

    public static IRubyObject sleep(IRubyObject recv, IRubyObject seconds) {
        try {
            Thread.sleep((long)(RubyNumeric.numericValue(seconds).getDoubleValue() * 1000.0));
        }
        catch (InterruptedException iExcptn) {}
        return recv;
    }

    public static IRubyObject exit(IRubyObject recv, IRubyObject[] args) {
        recv.getRuntime().secure(4);
        int status = 0;
        if (args.length > 0) {
            status = RubyNumeric.fix2int(args[0]);
        }
        throw new SystemExit(recv.getRuntime(), status);
    }

    public static RubyArray global_variables(IRubyObject recv) {
        RubyArray globalVariables = RubyArray.newArray(recv.getRuntime());
        Iterator iter = recv.getRuntime().getGlobalVariables().getNames();
        while (iter.hasNext()) {
            String globalVariableName = (String)iter.next();
            globalVariables.append(RubyString.newString(recv.getRuntime(), globalVariableName));
        }
        return globalVariables;
    }

    public static RubyArray local_variables(IRubyObject recv) {
        Ruby runtime = recv.getRuntime();
        RubyArray localVariables = RubyArray.newArray(runtime);
        if (runtime.getScope().getLocalNames() != null) {
            int i = 2;
            while (i < runtime.getScope().getLocalNames().size()) {
                if (runtime.getScope().getLocalNames().get(i) != null) {
                    localVariables.append(RubyString.newString(runtime, (String)runtime.getScope().getLocalNames().get(i)));
                }
                ++i;
            }
        }
        Iterator dynamicNames = runtime.getDynamicNames().iterator();
        while (dynamicNames.hasNext()) {
            String name = (String)dynamicNames.next();
            localVariables.append(RubyString.newString(runtime, name));
        }
        return localVariables;
    }

    public static RubyBoolean block_given(IRubyObject recv) {
        return RubyBoolean.newBoolean(recv.getRuntime(), recv.getRuntime().isFBlockGiven());
    }

    public static IRubyObject sprintf(IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0) {
            throw new ArgumentError(recv.getRuntime(), "sprintf must have at least one argument");
        }
        RubyString str = RubyString.stringValue(args[0]);
        RubyArray newArgs = RubyArray.newArray(recv.getRuntime(), args);
        newArgs.shift();
        return str.format(newArgs);
    }

    public static IRubyObject raise(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        switch (args.length) {
            case 0: {
                IRubyObject defaultException = runtime.getGlobalVariables().get("$!");
                if (defaultException.isNil()) {
                    throw new RaiseException(runtime, runtime.getExceptions().getRuntimeError(), "");
                }
                throw new RaiseException((RubyException)defaultException);
            }
            case 1: {
                if (args[0] instanceof RubyException) {
                    throw new RaiseException((RubyException)args[0]);
                }
                throw new RaiseException(RubyException.newInstance(runtime.getExceptions().getRuntimeError(), args));
            }
            case 2: {
                RubyException excptn = (RubyException)args[0].callMethod("exception", args[1]);
                throw new RaiseException(excptn);
            }
        }
        throw new ArgumentError(runtime, "wrong # of arguments");
    }

    public static IRubyObject require(IRubyObject recv, IRubyObject name) {
        if (recv.getRuntime().getLoadService().require(name.toString())) {
            return recv.getRuntime().getTrue();
        }
        return recv.getRuntime().getFalse();
    }

    public static IRubyObject load(IRubyObject recv, IRubyObject[] args) {
        RubyString file = (RubyString)args[0];
        if (recv.getRuntime().getLoadService().load(file.toString())) {
            return recv.getRuntime().getTrue();
        }
        return recv.getRuntime().getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject eval(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        RubyString src = (RubyString)args[0];
        IRubyObject scope = args.length > 1 ? args[1] : runtime.getNil();
        String file = "(eval)";
        if (args.length > 2) {
            file = args[2].toString();
        }
        int line = 1;
        if (args.length > 3) {
            line = RubyFixnum.fix2int(args[3]);
        }
        src.checkSafeString();
        if (scope.isNil() && runtime.getFrameStack().getPrevious() != null) {
            IRubyObject iRubyObject;
            try {
                runtime.getFrameStack().push(runtime.getFrameStack().getPrevious());
                iRubyObject = recv.eval(src, scope, file, line);
                Object var9_8 = null;
                runtime.getFrameStack().pop();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                runtime.getFrameStack().pop();
                throw throwable;
            }
            return iRubyObject;
        }
        return recv.eval(src, scope, file, line);
    }

    public static IRubyObject caller(IRubyObject recv, IRubyObject[] args) {
        int level;
        int n = level = args.length > 0 ? RubyFixnum.fix2int(args[0]) : 1;
        if (level < 0) {
            throw new ArgumentError(recv.getRuntime(), "negative level(" + level + ')');
        }
        return RaiseException.createBacktrace(recv.getRuntime(), level);
    }

    public static IRubyObject rbCatch(IRubyObject recv, IRubyObject tag) {
        try {
            return recv.getRuntime().yield(tag);
        }
        catch (ThrowJump throwJump) {
            if (throwJump.getTag().equals(tag.asSymbol())) {
                return throwJump.getValue();
            }
            throw throwJump;
        }
    }

    public static IRubyObject rbThrow(IRubyObject recv, IRubyObject[] args) {
        throw new ThrowJump(args[0].asSymbol(), args.length > 1 ? args[1] : recv.getRuntime().getNil());
    }

    public static IRubyObject set_trace_func(IRubyObject recv, IRubyObject trace_func) {
        if (trace_func.isNil()) {
            recv.getRuntime().setTraceFunction(null);
        } else {
            if (!(trace_func instanceof RubyProc)) {
                throw new TypeError(recv.getRuntime(), "trace_func needs to be Proc.");
            }
            recv.getRuntime().setTraceFunction((RubyProc)trace_func);
        }
        return trace_func;
    }

    public static IRubyObject singleton_method_added(IRubyObject recv, IRubyObject symbolId) {
        return recv.getRuntime().getNil();
    }

    public static RubyProc proc(IRubyObject recv) {
        return RubyProc.newProc(recv.getRuntime());
    }

    public static IRubyObject loop(IRubyObject recv) {
        while (true) {
            recv.getRuntime().yield(recv.getRuntime().getNil());
            Thread.yield();
        }
    }

    public static IRubyObject backquote(IRubyObject recv, IRubyObject aString) {
        StringBuffer output = new StringBuffer();
        KernelModule.runInShell(recv.getRuntime(), aString.toString(), output);
        return RubyString.newString(recv.getRuntime(), output.toString());
    }

    /*
     * WARNING - void declaration
     */
    private static int runInShell(Ruby runtime, String command, StringBuffer output) {
        try {
            String line;
            Process aProcess;
            String shell = System.getProperty("jruby.shell");
            String shellSwitch = "-c";
            if (shell != null) {
                if (!shell.endsWith("sh")) {
                    shellSwitch = "/c";
                }
                aProcess = Runtime.getRuntime().exec(new String[]{shell, shellSwitch, command});
            } else {
                aProcess = Runtime.getRuntime().exec(command);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(aProcess.getInputStream()));
            while ((line = reader.readLine()) != null) {
                void var7_9;
                output.append((String)var7_9).append('\n');
            }
            return aProcess.waitFor();
        }
        catch (IOException e) {
            throw IOError.fromException(runtime, e);
        }
        catch (InterruptedException e) {
            throw new ThreadError(runtime, "unexpected interrupt");
        }
    }

    public static RubyInteger srand(IRubyObject recv, IRubyObject[] args) {
        long oldRandomSeed = recv.getRuntime().randomSeed;
        if (args.length > 0) {
            RubyInteger integerSeed = (RubyInteger)args[0].convertToType("Integer", "to_int", true);
            recv.getRuntime().randomSeed = integerSeed.getLongValue();
        } else {
            recv.getRuntime().randomSeed = System.currentTimeMillis();
        }
        recv.getRuntime().random.setSeed(recv.getRuntime().randomSeed);
        return RubyFixnum.newFixnum(recv.getRuntime(), oldRandomSeed);
    }

    public static RubyNumeric rand(IRubyObject recv, IRubyObject[] args) {
        long ceil;
        if (args.length == 0) {
            ceil = 0L;
        } else if (args.length == 1) {
            RubyInteger integerCeil = (RubyInteger)args[0].convertToType("Integer", "to_int", true);
            ceil = integerCeil.getLongValue();
            if ((ceil = Math.abs(ceil)) > Integer.MAX_VALUE) {
                throw new NotImplementedError(recv.getRuntime(), "Random values larger than Integer.MAX_VALUE not supported");
            }
        } else {
            throw new ArgumentError(recv.getRuntime(), "wrong # of arguments(" + args.length + " for 1)");
        }
        if (ceil == 0L) {
            double result = recv.getRuntime().random.nextDouble();
            return RubyFloat.newFloat(recv.getRuntime(), result);
        }
        return RubyFixnum.newFixnum(recv.getRuntime(), recv.getRuntime().random.nextInt((int)ceil));
    }

    public static RubyBoolean system(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        if (args.length > 1) {
            throw new ArgumentError(runtime, "more arguments not yet supported");
        }
        StringBuffer output = new StringBuffer();
        int resultCode = KernelModule.runInShell(runtime, args[0].toString(), output);
        recv.getRuntime().getGlobalVariables().set("$?", RubyFixnum.newFixnum(runtime, resultCode));
        return RubyBoolean.newBoolean(runtime, resultCode == 0);
    }
}

