/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.FrozenError;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubyClass
extends RubyModule
implements IndexCallable {
    static /* synthetic */ Class class$org$jruby$RubyClass;

    protected RubyClass(RubyClass superClass) {
        this(superClass.getRuntime(), superClass.getRuntime().getClasses().getClassClass(), superClass);
        this.infectBy(superClass);
    }

    protected RubyClass(Ruby ruby, RubyClass superClass) {
        this(ruby, null, superClass);
    }

    protected RubyClass(Ruby ruby, RubyClass rubyClass, RubyClass superClass) {
        super(ruby, rubyClass, superClass);
    }

    private RubyClass(Ruby ruby, RubyClass rubyClass, RubyClass superClass, String name) {
        super(ruby, rubyClass, superClass, name);
    }

    protected void testFrozen() {
        if (this.isFrozen()) {
            throw new FrozenError(this.getRuntime(), "class");
        }
    }

    public boolean isModule() {
        return false;
    }

    public boolean isClass() {
        return true;
    }

    public static void createClassClass(RubyClass classClass) {
        classClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyClass == null ? (class$org$jruby$RubyClass = RubyClass.class$("org.jruby.RubyClass")) : class$org$jruby$RubyClass, "newClass"));
        classClass.defineMethod("new", CallbackFactory.getOptMethod(class$org$jruby$RubyClass == null ? (class$org$jruby$RubyClass = RubyClass.class$("org.jruby.RubyClass")) : class$org$jruby$RubyClass, "newInstance"));
        classClass.defineMethod("superclass", CallbackFactory.getMethod(class$org$jruby$RubyClass == null ? (class$org$jruby$RubyClass = RubyClass.class$("org.jruby.RubyClass")) : class$org$jruby$RubyClass, "superclass"));
        classClass.defineSingletonMethod("inherited", CallbackFactory.getNilMethod(1));
        classClass.undefineMethod("module_function");
    }

    public void inheritedBy(RubyClass superType) {
        if (superType == null) {
            superType = this.runtime.getClasses().getObjectClass();
        }
        superType.callMethod("inherited", this);
    }

    public RubyClass defineSubclass(String name) {
        RubyClass subclass = this.subclass();
        subclass.setName(name);
        subclass.makeMetaClass(this.getMetaClass());
        return subclass;
    }

    public RubyClass getSingletonClassClone() {
        if (!this.isSingleton()) {
            return this;
        }
        MetaClass clone = new MetaClass(this.getRuntime(), this.getMetaClass(), this.getSuperClass());
        clone.setupClone(this);
        clone.setInstanceVariables(new HashMap(this.getInstanceVariables()));
        Iterator iter = this.getMethods().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ICallable value = (ICallable)entry.getValue();
            clone.getMethods().put(entry.getKey(), value);
        }
        return clone;
    }

    public boolean isSingleton() {
        return false;
    }

    public RubyClass getMetaClass() {
        RubyClass type = super.getMetaClass();
        return type != null ? type : this.getRuntime().getClasses().getClassClass();
    }

    public RubyClass getRealClass() {
        return this;
    }

    public void attachToObject(IRubyObject object) {
    }

    public MetaClass newSingletonClass() {
        MetaClass newClass = new MetaClass(this.getRuntime(), this);
        newClass.infectBy(this);
        return newClass;
    }

    public static RubyClass newClass(Ruby ruby, RubyClass superClass, String name) {
        return new RubyClass(ruby, ruby.getClasses().getClassClass(), superClass, name);
    }

    protected RubyClass subclass() {
        if (this == this.runtime.getClasses().getClassClass()) {
            throw new TypeError(this.runtime, "can't make subclass of Class");
        }
        return new RubyClass(this);
    }

    public IRubyObject newInstance(IRubyObject[] args) {
        if (this.isSingleton()) {
            throw new TypeError(this.getRuntime(), "can't create instance of virtual class");
        }
        IRubyObject obj = this.getRuntime().getFactory().newObject(this);
        obj.callInit(args);
        return obj;
    }

    public static RubyClass newClass(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        RubyClass superClass = runtime.getClasses().getObjectClass();
        if (args.length > 0) {
            if (args[0] instanceof RubyClass) {
                superClass = (RubyClass)args[0];
            } else {
                throw new TypeError(runtime, "wrong argument type " + superClass.getType().toName() + " (expected Class)");
            }
        }
        RubyClass newClass = superClass.subclass();
        newClass.makeMetaClass(superClass.getMetaClass());
        newClass.callInit(args);
        newClass.inheritedBy(superClass);
        return newClass;
    }

    public IRubyObject superclass() {
        RubyClass superClass = this.getSuperClass();
        while (superClass != null && superClass.isIncluded()) {
            superClass = superClass.getSuperClass();
        }
        return superClass != null ? superClass : this.getRuntime().getNil();
    }

    public static IRubyObject inherited(RubyClass recv) {
        throw new TypeError(recv.getRuntime(), "can't make subclass of Class");
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(99);
        output.dumpString(this.getClassname().toString());
    }

    public static RubyModule unmarshalFrom(UnmarshalStream output) throws IOException {
        return (RubyClass)RubyModule.unmarshalFrom(output);
    }

    public IRubyObject allocateObject() {
        IRubyObject newObject = this.callMethod("allocate");
        if (newObject.getType() != this.getRealClass()) {
            throw new TypeError(this.runtime, "wrong instance allocation");
        }
        return newObject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

