/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.IOError;
import org.jruby.exceptions.NotImplementedError;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Glob;

public class RubyDir
extends RubyObject {
    protected String path;
    protected File dir;
    private String[] snapshot;
    private int pos;
    static /* synthetic */ Class class$org$jruby$RubyDir;
    static /* synthetic */ Class class$org$jruby$RubyString;
    static /* synthetic */ Class class$org$jruby$RubyFixnum;

    public RubyDir(Ruby ruby, RubyClass type) {
        super(ruby, type);
    }

    public static RubyClass createDirClass(Ruby ruby) {
        RubyClass dirClass = ruby.defineClass("Dir", ruby.getClasses().getObjectClass());
        dirClass.includeModule(ruby.getRubyModule("Enumerable"));
        dirClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "newInstance"));
        dirClass.defineSingletonMethod("glob", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "glob", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("[]", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "glob", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("chdir", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "chdir", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("chroot", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "chroot", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("delete", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "delete", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("foreach", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "foreach", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("getwd", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "getwd"));
        dirClass.defineSingletonMethod("pwd", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "getwd"));
        dirClass.defineSingletonMethod("mkdir", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "mkdir"));
        dirClass.defineSingletonMethod("open", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "open", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("rmdir", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "rmdir", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("unlink", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "rmdir", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("delete", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "rmdir", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineMethod("close", CallbackFactory.getMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "close"));
        dirClass.defineMethod("each", CallbackFactory.getMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "each"));
        dirClass.defineMethod("tell", CallbackFactory.getMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "tell"));
        dirClass.defineAlias("pos", "tell");
        dirClass.defineMethod("seek", CallbackFactory.getMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "seek", class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyDir.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum));
        dirClass.defineAlias("pos=", "seek");
        dirClass.defineMethod("read", CallbackFactory.getMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "read"));
        dirClass.defineMethod("rewind", CallbackFactory.getMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "rewind"));
        dirClass.defineMethod("initialize", CallbackFactory.getMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "initialize", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        return dirClass;
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyDir result = new RubyDir(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    public IRubyObject initialize(RubyString path) {
        path.checkSafeString();
        this.dir = new File(path.getValue());
        if (!this.dir.isDirectory()) {
            path = null;
            this.dir = null;
            throw new IOError(this.getRuntime(), path.getValue() + " is not a directory");
        }
        ArrayList<String> snapshotList = new ArrayList<String>();
        snapshotList.add(".");
        snapshotList.add("..");
        snapshotList.addAll(RubyDir.getContents(this.dir));
        this.snapshot = snapshotList.toArray(new String[snapshotList.size()]);
        this.pos = 0;
        return this;
    }

    public static RubyArray glob(IRubyObject recv, RubyString pat) {
        String pattern = pat.toString();
        Object[] files = new Glob(pattern).getNames();
        return RubyArray.newArray(recv.getRuntime(), JavaUtil.convertJavaArrayToRuby(recv.getRuntime(), files));
    }

    public static IRubyObject chdir(IRubyObject recv, RubyString path) {
        System.setProperty("user.dir", RubyDir.getDir(recv.getRuntime(), path.toString()).toString());
        return RubyFixnum.newFixnum(recv.getRuntime(), 0L);
    }

    public static IRubyObject chroot(IRubyObject recv, RubyString path) {
        throw new NotImplementedError(recv.getRuntime(), "chroot not implemented: chroot is non-portable and is not supported.");
    }

    public static IRubyObject rmdir(IRubyObject recv, RubyString path) {
        new File(path.toString()).delete();
        return RubyFixnum.newFixnum(recv.getRuntime(), 0L);
    }

    public static IRubyObject foreach(IRubyObject recv, RubyString path) {
        path.checkSafeString();
        RubyDir dir = (RubyDir)RubyDir.newInstance(recv.getRuntime().getClasses().getDirClass(), new IRubyObject[]{path});
        dir.each();
        return recv.getRuntime().getNil();
    }

    public static RubyString getwd(IRubyObject recv) {
        return new RubyString(recv.getRuntime(), System.getProperty("user.dir"));
    }

    public static IRubyObject mkdir(IRubyObject recv, IRubyObject[] args) {
        if (args.length < 1) {
            throw new ArgumentError(recv.getRuntime(), args.length, 1);
        }
        if (args.length > 2) {
            throw new ArgumentError(recv.getRuntime(), args.length, 2);
        }
        args[0].checkSafeString();
        String path = args[0].toString();
        File newDir = new File(path);
        if (newDir.exists()) {
            throw new IOError(recv.getRuntime(), path + " already exists");
        }
        return RubyBoolean.newBoolean(recv.getRuntime(), newDir.mkdir());
    }

    public static IRubyObject open(IRubyObject recv, RubyString path) {
        throw new NotImplementedError(recv.getRuntime());
    }

    public IRubyObject close() {
        return this;
    }

    public IRubyObject each() {
        String[] contents = this.snapshot;
        int i = 0;
        while (i < contents.length) {
            this.getRuntime().yield(RubyString.newString(this.getRuntime(), contents[i]));
            ++i;
        }
        return this;
    }

    public RubyInteger tell() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.pos);
    }

    public IRubyObject seek(RubyFixnum pos) {
        this.pos = (int)pos.getLongValue();
        return pos;
    }

    public RubyString read() {
        if (this.pos >= this.snapshot.length) {
            return RubyString.nilString(this.runtime);
        }
        RubyString result = new RubyString(this.getRuntime(), this.snapshot[this.pos]);
        ++this.pos;
        return result;
    }

    public IRubyObject rewind() {
        this.pos = 0;
        return RubyFixnum.newFixnum(this.getRuntime(), this.pos);
    }

    protected static File getDir(Ruby ruby, String path) {
        File result = new File(path);
        if (!result.isDirectory()) {
            throw new IOError(ruby, path + " is not a directory");
        }
        return result;
    }

    protected static List getContents(File directory) {
        ArrayList<String> result = new ArrayList<String>();
        String[] contents = directory.list();
        int i = 0;
        while (i < contents.length) {
            result.add(contents[i]);
            ++i;
        }
        return result;
    }

    protected static List getContents(File directory, Ruby ruby) {
        ArrayList<RubyString> result = new ArrayList<RubyString>();
        String[] contents = directory.list();
        int i = 0;
        while (i < contents.length) {
            result.add(new RubyString(ruby, contents[i]));
            ++i;
        }
        return result;
    }

    public boolean matches(String str, String pattern) {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

