/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jruby.KernelModule;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.EOFError;
import org.jruby.exceptions.IOError;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RubyInputStream;

public class RubyIO
extends RubyObject {
    protected RubyInputStream inStream = null;
    protected OutputStream outStream = null;
    protected boolean sync = false;
    protected boolean readable = false;
    protected boolean writeable = false;
    protected boolean append = false;
    protected int lineNumber = 0;
    protected String path;
    static /* synthetic */ Class class$org$jruby$RubyIO;
    static /* synthetic */ Class class$org$jruby$RubyString;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;
    static /* synthetic */ Class class$org$jruby$RubyFixnum;
    static /* synthetic */ Class class$org$jruby$RubyBoolean;

    public RubyIO(Ruby ruby) {
        super(ruby, ruby.getClasses().getIoClass());
    }

    public RubyIO(Ruby ruby, RubyClass type) {
        super(ruby, type);
    }

    public static RubyClass createIOClass(Ruby ruby) {
        RubyClass ioClass = ruby.defineClass("IO", ruby.getClasses().getObjectClass());
        ioClass.includeModule(ruby.getClasses().getEnumerableModule());
        ioClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "newInstance"));
        ioClass.defineSingletonMethod("foreach", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "foreach", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyIO.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        ioClass.defineMethod("initialize", CallbackFactory.getOptMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "initialize"));
        ioClass.defineMethod("write", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "write", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyIO.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        ioClass.defineMethod("<<", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "addString", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyIO.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        ioClass.defineMethod("each", CallbackFactory.getOptMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "each_line"));
        ioClass.defineMethod("each_line", CallbackFactory.getOptMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "each_line"));
        ioClass.defineMethod("each_byte", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "each_byte"));
        ioClass.defineMethod("getc", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "getc"));
        ioClass.defineMethod("readchar", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "readchar"));
        ioClass.defineMethod("gets", CallbackFactory.getOptMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "gets"));
        ioClass.defineMethod("readline", CallbackFactory.getOptMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "readline"));
        ioClass.defineMethod("lineno", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "lineno"));
        ioClass.defineMethod("lineno=", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "lineno_set", class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyIO.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum));
        ioClass.defineMethod("sync", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "sync"));
        ioClass.defineMethod("sync=", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "sync_set", class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyIO.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean));
        ioClass.defineMethod("close", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "close"));
        ioClass.defineMethod("eof?", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "eof"));
        ioClass.defineMethod("flush", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "flush"));
        ioClass.defineMethod("print", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "print"));
        ioClass.defineMethod("printf", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "printf"));
        ioClass.defineMethod("puts", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "puts"));
        ioClass.defineMethod("readlines", CallbackFactory.getOptMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "readlines"));
        ioClass.defineSingletonMethod("readlines", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "readlines"));
        return ioClass;
    }

    public static IRubyObject stdin(Ruby ruby, RubyClass rubyClass, InputStream inStream) {
        RubyIO io = new RubyIO(ruby, rubyClass);
        io.inStream = new RubyInputStream(inStream);
        io.readable = true;
        return io;
    }

    public static IRubyObject stdout(Ruby ruby, RubyClass rubyClass, OutputStream outStream) {
        RubyIO io = new RubyIO(ruby, rubyClass);
        io.outStream = outStream;
        io.writeable = true;
        return io;
    }

    public static IRubyObject stderr(Ruby ruby, RubyClass rubyClass, OutputStream errStream) {
        RubyIO io = new RubyIO(ruby, rubyClass);
        io.outStream = errStream;
        io.writeable = true;
        return io;
    }

    protected void checkWriteable() {
        if (!this.writeable || this.outStream == null) {
            throw new IOError(this.getRuntime(), "not opened for writing");
        }
    }

    protected void checkReadable() {
        if (!this.readable || this.inStream == null) {
            throw new IOError(this.getRuntime(), "not opened for reading");
        }
    }

    protected boolean isReadable() {
        return this.readable;
    }

    protected boolean isWriteable() {
        return this.writeable;
    }

    public OutputStream getOutStream() {
        return this.outStream;
    }

    public InputStream getInStream() {
        return this.inStream;
    }

    protected void closeStreams() {
        if (this.inStream != null) {
            try {
                this.inStream.close();
            }
            catch (IOException ioExcptn) {
                // empty catch block
            }
        }
        if (this.outStream != null) {
            try {
                this.outStream.close();
            }
            catch (IOException ioExcptn) {
                // empty catch block
            }
        }
        this.inStream = null;
        this.outStream = null;
    }

    public IRubyObject callWrite(IRubyObject anObject) {
        return this.callMethod("write", anObject);
    }

    protected void setMode(String mode) {
        this.readable = false;
        this.writeable = false;
        this.append = false;
        if (mode.length() == 0) {
            throw new ArgumentError(this.getRuntime(), "illegal access mode");
        }
        switch (mode.charAt(0)) {
            case 'r': {
                this.readable = true;
                break;
            }
            case 'a': {
                this.append = true;
            }
            case 'w': {
                this.writeable = true;
                break;
            }
            default: {
                throw new ArgumentError(this.getRuntime(), "illegal access mode " + mode);
            }
        }
        if (mode.length() > 1) {
            int i;
            int n = i = mode.charAt(1) == 'b' ? 2 : 1;
            if (mode.length() > i) {
                if (mode.charAt(i) == '+') {
                    this.readable = true;
                    this.writeable = true;
                } else {
                    throw new ArgumentError(this.getRuntime(), "illegal access mode " + mode);
                }
            }
        }
    }

    protected void fdOpen(int fd) {
        switch (fd) {
            case 0: {
                this.inStream = new RubyInputStream(this.getRuntime().getInputStream());
                break;
            }
            case 1: {
                this.outStream = this.getRuntime().getOutputStream();
                break;
            }
            case 2: {
                this.outStream = this.getRuntime().getErrorStream();
                break;
            }
            default: {
                throw new IOError(this.getRuntime(), "Bad file descriptor");
            }
        }
    }

    public RubyString internalGets(IRubyObject[] args) {
        String separator;
        this.checkReadable();
        IRubyObject sepVal = this.getRuntime().getGlobalVariables().get("$/");
        if (args.length > 0) {
            sepVal = args[0];
        }
        String string = separator = sepVal.isNil() ? null : ((RubyString)sepVal).getValue();
        if (separator != null && separator.length() == 0) {
            separator = "\n\n";
        }
        try {
            String newLine = this.inStream.gets(separator);
            if (newLine != null) {
                ++this.lineNumber;
                this.runtime.getGlobalVariables().set("$.", RubyFixnum.newFixnum(this.runtime, this.lineNumber));
                RubyString result = RubyString.newString(this.getRuntime(), newLine);
                result.taint();
                return result;
            }
        }
        catch (IOException ioExcptn) {}
        return RubyString.nilString(this.getRuntime());
    }

    public void initIO(RubyInputStream inStream, OutputStream outStream, String path) {
        this.readable = inStream != null;
        this.writeable = outStream != null;
        this.inStream = inStream;
        this.outStream = outStream;
        this.path = path;
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyIO newObject = new RubyIO(recv.getRuntime(), (RubyClass)recv);
        newObject.callInit(args);
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject foreach(IRubyObject recv, RubyString filename, IRubyObject[] args) {
        filename.checkSafeString();
        RubyIO io = (RubyIO)KernelModule.open(recv, new IRubyObject[]{filename});
        if (!io.isNil()) {
            try {
                io.callMethod("each", args);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                io.callMethod("close");
                throw throwable;
            }
            io.callMethod("close");
            {
            }
        }
        return recv.getRuntime().getNil();
    }

    public IRubyObject initialize(IRubyObject[] args) {
        this.closeStreams();
        String mode = "r";
        if (args.length > 1) {
            mode = ((RubyString)args[1]).getValue();
        }
        this.setMode(mode);
        this.fdOpen(RubyFixnum.fix2int(args[0]));
        return this;
    }

    public IRubyObject write(IRubyObject obj) {
        this.getRuntime().secure(4);
        String str = obj.toString();
        if (str.length() == 0) {
            return RubyFixnum.zero(this.getRuntime());
        }
        this.checkWriteable();
        try {
            this.outStream.write(str.getBytes());
            if (this.sync) {
                this.outStream.flush();
            }
        }
        catch (IOException ioExcptn) {
            throw new IOError(this.getRuntime(), ioExcptn.getMessage());
        }
        return RubyFixnum.newFixnum(this.runtime, str.length());
    }

    public IRubyObject addString(IRubyObject anObject) {
        this.callWrite(anObject);
        return this;
    }

    public RubyFixnum lineno() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.lineNumber);
    }

    public IRubyObject lineno_set(RubyFixnum newLineNumber) {
        this.lineNumber = RubyFixnum.fix2int(newLineNumber);
        return this;
    }

    public RubyBoolean sync() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.sync);
    }

    public IRubyObject sync_set(RubyBoolean newSync) {
        this.sync = newSync.isTrue();
        return this;
    }

    public RubyBoolean eof() {
        this.checkReadable();
        try {
            int c = this.inStream.read();
            if (c == -1) {
                return this.runtime.getTrue();
            }
            this.inStream.unread(c);
            return this.runtime.getFalse();
        }
        catch (IOException ioExcptn) {
            throw new IOError(this.runtime, ioExcptn.getMessage());
        }
    }

    public IRubyObject close() {
        this.closeStreams();
        return this;
    }

    public RubyIO flush() {
        this.checkWriteable();
        try {
            this.outStream.flush();
        }
        catch (IOException ioExcptn) {
            throw new IOError(this.runtime, ioExcptn.getMessage());
        }
        return this;
    }

    public RubyString gets(IRubyObject[] args) {
        RubyString result = this.internalGets(args);
        if (!result.isNil()) {
            this.getRuntime().setLastline(result);
        }
        return result;
    }

    public RubyString readline(IRubyObject[] args) {
        RubyString line = this.gets(args);
        if (line.isNil()) {
            throw new EOFError(this.runtime);
        }
        return line;
    }

    public IRubyObject getc() {
        this.checkReadable();
        try {
            int c = this.inStream.read();
            return c != -1 ? RubyFixnum.newFixnum(this.runtime, c & 0xFF) : this.runtime.getNil();
        }
        catch (IOException ioExcptn) {
            throw new IOError(this.runtime, ioExcptn.getMessage());
        }
    }

    public IRubyObject readchar() {
        IRubyObject obj = this.getc();
        if (obj.isNil()) {
            throw new EOFError(this.runtime);
        }
        return obj;
    }

    /*
     * WARNING - void declaration
     */
    public IRubyObject each_byte() {
        this.checkReadable();
        try {
            int c;
            while ((c = this.inStream.read()) != -1) {
                void var1_1;
                this.runtime.yield(RubyFixnum.newFixnum(this.runtime, var1_1 & 0xFF));
            }
        }
        catch (IOException ioExcptn) {
            throw new IOError(this.runtime, ioExcptn.getMessage());
        }
        return this.runtime.getNil();
    }

    public RubyIO each_line(IRubyObject[] args) {
        RubyString nextLine = this.internalGets(args);
        while (!nextLine.isNil()) {
            this.getRuntime().yield(nextLine);
            nextLine = this.internalGets(args);
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public static IRubyObject puts(IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0) {
            recv.callMethod("write", RubyString.newString(recv.getRuntime(), "\n"));
            return recv.getRuntime().getNil();
        }
        i = 0;
        while (i < args.length) {
            block5: {
                line = null;
                if (!args[i].isNil()) break block5;
                line = "nil";
                ** GOTO lbl17
            }
            if (args[i] instanceof RubyArray) {
                RubyIO.puts(recv, ((RubyArray)args[i]).toJavaArray());
            } else {
                line = args[i].toString();
lbl17:
                // 2 sources

                recv.callMethod("write", RubyString.newString(recv.getRuntime(), line));
                if (!line.endsWith("\n")) {
                    recv.callMethod("write", RubyString.newString(recv.getRuntime(), "\n"));
                }
            }
            ++i;
        }
        return recv.getRuntime().getNil();
    }

    public static IRubyObject print(IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0) {
            args = new IRubyObject[]{recv.getRuntime().getLastline()};
        }
        IRubyObject fs = recv.getRuntime().getGlobalVariables().get("$,");
        IRubyObject rs = recv.getRuntime().getGlobalVariables().get("$\\");
        int i = 0;
        while (i < args.length) {
            if (i > 0 && !fs.isNil()) {
                recv.callMethod("write", fs);
            }
            if (args[i].isNil()) {
                recv.callMethod("write", RubyString.newString(recv.getRuntime(), "nil"));
            } else {
                recv.callMethod("write", args[i]);
            }
            ++i;
        }
        if (!rs.isNil()) {
            recv.callMethod("write", rs);
        }
        return recv.getRuntime().getNil();
    }

    public static IRubyObject printf(IRubyObject recv, IRubyObject[] args) {
        recv.callMethod("write", KernelModule.sprintf(recv, args));
        return recv.getRuntime().getNil();
    }

    /*
     * WARNING - void declaration
     */
    public RubyArray readlines(IRubyObject[] args) {
        RubyString line;
        IRubyObject[] separatorArgument;
        if (args.length > 0) {
            if (!args[0].isKindOf(this.runtime.getClasses().getStringClass())) {
                throw new TypeError(this.runtime, args[0], this.runtime.getClasses().getStringClass());
            }
            separatorArgument = new IRubyObject[]{args[0]};
        } else {
            separatorArgument = IRubyObject.NULL_ARRAY;
        }
        RubyArray result = RubyArray.newArray(this.runtime);
        while (!(line = this.internalGets(separatorArgument)).isNil()) {
            void var4_4;
            result.append((IRubyObject)var4_4);
        }
        return result;
    }

    public static RubyArray readlines(IRubyObject recv, IRubyObject[] args) {
        if (args.length < 1) {
            throw new ArgumentError(recv.getRuntime(), args.length, 1);
        }
        if (!args[0].isKindOf(recv.getRuntime().getClasses().getStringClass())) {
            throw new TypeError(recv.getRuntime(), args[0], recv.getRuntime().getClasses().getStringClass());
        }
        RubyString fileName = (RubyString)args[0];
        IRubyObject[] separatorArguments = args.length >= 2 ? new IRubyObject[]{args[1]} : IRubyObject.NULL_ARRAY;
        RubyIO file = (RubyIO)KernelModule.open(recv, new IRubyObject[]{fileName});
        return file.readlines(separatorArguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

