/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Callback;
import org.jruby.runtime.builtin.IRubyObject;

public final class TopSelfFactory {
    private TopSelfFactory() {
    }

    public static IRubyObject createTopSelf(final Ruby runtime) {
        IRubyObject topSelf = runtime.getFactory().newObject(runtime.getClasses().getObjectClass());
        topSelf.defineSingletonMethod("to_s", new Callback(){

            public IRubyObject execute(IRubyObject recv, IRubyObject[] args) {
                return RubyString.newString(runtime, "main");
            }

            public Arity getArity() {
                return Arity.noArguments();
            }
        });
        topSelf.defineSingletonMethod("include", new Callback(){

            public IRubyObject execute(IRubyObject recv, IRubyObject[] args) {
                runtime.secure(4);
                return runtime.getClasses().getObjectClass().include(args);
            }

            public Arity getArity() {
                return Arity.optional();
            }
        });
        topSelf.defineSingletonMethod("public", new Callback(){

            public IRubyObject execute(IRubyObject recv, IRubyObject[] args) {
                return runtime.getClasses().getObjectClass().rbPublic(args);
            }

            public Arity getArity() {
                return Arity.optional();
            }
        });
        topSelf.defineSingletonMethod("private", new Callback(){

            public IRubyObject execute(IRubyObject recv, IRubyObject[] args) {
                return runtime.getClasses().getObjectClass().rbPrivate(args);
            }

            public Arity getArity() {
                return Arity.optional();
            }
        });
        return topSelf;
    }
}

