/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.ablaf.ast.INode;
import org.ablaf.common.ISourcePosition;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.ExpandArrayNode;
import org.jruby.evaluator.EvaluateVisitor;
import org.jruby.runtime.Block;
import org.jruby.runtime.Iter;
import org.jruby.runtime.builtin.IRubyObject;

public final class ArgsUtil {
    public static Block beginCallArgs(Ruby runtime) {
        Block currentBlock = runtime.getBlockStack().getCurrent();
        if (runtime.getCurrentIter().isPre()) {
            runtime.getBlockStack().pop();
        }
        runtime.getIterStack().push(Iter.ITER_NOT);
        return currentBlock;
    }

    public static void endCallArgs(Ruby runtime, Block currentBlock) {
        runtime.getBlockStack().setCurrent(currentBlock);
        runtime.getIterStack().pop();
    }

    public static IRubyObject[] setupArgs(Ruby runtime, EvaluateVisitor visitor, INode node) {
        if (node == null) {
            return IRubyObject.NULL_ARRAY;
        }
        ISourcePosition position = runtime.getPosition();
        if (node instanceof ArrayNode) {
            int size = ((ArrayNode)node).size();
            ArrayList<IRubyObject> list = new ArrayList<IRubyObject>(size);
            Iterator iterator = ((ArrayNode)node).iterator();
            int i = 0;
            while (i < size) {
                INode next = (INode)iterator.next();
                if (next instanceof ExpandArrayNode) {
                    list.addAll(((RubyArray)visitor.eval(next)).getList());
                } else {
                    list.add(visitor.eval(next));
                }
                ++i;
            }
            runtime.setPosition(position);
            return list.toArray(new IRubyObject[list.size()]);
        }
        IRubyObject args = visitor.eval(node);
        runtime.setPosition(position);
        if (args instanceof RubyArray) {
            return ((RubyArray)args).toJavaArray();
        }
        return new IRubyObject[]{args};
    }
}

