/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.builtin.definitions;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.definitions.ClassDefinition;
import org.jruby.runtime.builtin.definitions.MethodContext;
import org.jruby.runtime.builtin.definitions.SingletonMethodContext;
import org.jruby.util.Asserts;

public class ArrayDefinition
extends ClassDefinition {
    private static final int ARRAY = 61440;
    private static final int STATIC = 61696;
    public static final int INITIALIZE = 61441;
    public static final int INSPECT = 61442;
    public static final int TO_S = 61443;
    public static final int FROZEN = 61444;
    public static final int EQUAL = 61445;
    public static final int EQL = 61446;
    public static final int HASH = 61447;
    public static final int AREF = 61448;
    public static final int ASET = 61449;
    public static final int FIRST = 61450;
    public static final int LAST = 61451;
    public static final int CONCAT = 61452;
    public static final int APPEND = 61453;
    public static final int PUSH = 61454;
    public static final int POP = 61455;
    public static final int SHIFT = 61456;
    public static final int UNSHIFT = 61457;
    public static final int EACH = 61458;
    public static final int EACH_INDEX = 61459;
    public static final int REVERSE_EACH = 61460;
    public static final int LENGTH = 61461;
    public static final int EMPTY_P = 61462;
    public static final int INDEX = 61463;
    public static final int RINDEX = 61464;
    public static final int INDICES = 61465;
    public static final int RBCLONE = 61466;
    public static final int JOIN = 61467;
    public static final int REVERSE = 61468;
    public static final int REVERSE_BANG = 61469;
    public static final int SORT = 61470;
    public static final int SORT_BANG = 61471;
    public static final int COLLECT = 61472;
    public static final int COLLECT_BANG = 61473;
    public static final int DELETE = 61474;
    public static final int DELETE_AT = 61475;
    public static final int DELETE_IF = 61476;
    public static final int REJECT_BANG = 61477;
    public static final int REPLACE = 61478;
    public static final int CLEAR = 61479;
    public static final int FILL = 61480;
    public static final int INCLUDE_P = 61481;
    public static final int OP_CMP = 61482;
    public static final int NEWINSTANCE = 61697;
    public static final int CREATE = 61698;

    public ArrayDefinition(Ruby runtime) {
        super(runtime);
    }

    protected RubyClass createType(Ruby runtime) {
        RubyClass result = runtime.defineClass("Array", (RubyClass)runtime.getClasses().getClass("Object"));
        result.includeModule(runtime.getClasses().getClass("Enumerable"));
        return result;
    }

    protected void defineMethods(MethodContext context) {
        context.createOptional("initialize", 61441, 0);
        context.create("inspect", 61442, 0);
        context.create("to_s", 61443, 0);
        context.create("frozen?", 61444, 0);
        context.create("==", 61445, 1);
        context.create("eql?", 61446, 1);
        context.create("===", 61445, 1);
        context.create("hash", 61447, 0);
        context.createOptional("[]", 61448, 0);
        context.createOptional("[]=", 61449, 0);
        context.create("first", 61450, 0);
        context.create("last", 61451, 0);
        context.create("concat", 61452, 1);
        context.create("<<", 61453, 1);
        context.createOptional("push", 61454, 1);
        context.create("pop", 61455, 0);
        context.create("shift", 61456, 0);
        context.createOptional("unshift", 61457, 0);
        context.create("each", 61458, 0);
        context.create("each_index", 61459, 0);
        context.create("reverse_each", 61460, 0);
        context.create("length", 61461, 0);
        context.create("size", 61461, 0);
        context.create("empty?", 61462, 0);
        context.create("index", 61463, 1);
        context.create("rindex", 61464, 1);
        context.createOptional("indices", 61465, 0);
        context.createOptional("indexes", 61465, 0);
        context.create("clone", 61466, 0);
        context.createOptional("join", 61467, 0);
        context.create("reverse", 61468, 0);
        context.create("reverse!", 61469, 0);
        context.create("sort", 61470, 0);
        context.create("sort!", 61471, 0);
        context.create("collect", 61472, 0);
        context.create("collect!", 61473, 0);
        context.create("map!", 61473, 0);
        context.create("filter", 61473, 0);
        context.create("delete", 61474, 1);
        context.create("delete_at", 61475, 1);
        context.create("delete_if", 61476, 0);
        context.create("reject!", 61477, 0);
        context.create("replace", 61478, 1);
        context.create("clear", 61479, 0);
        context.createOptional("fill", 61480, 0);
        context.create("include?", 61481, 1);
        context.create("<=>", 61482, 1);
        context.createOptional("slice", 61448, 0);
    }

    protected void defineSingletonMethods(SingletonMethodContext context) {
        context.createOptional("new", 61697, 0);
        context.createOptional("[]", 61698, 0);
    }

    public IRubyObject callIndexed(int index, IRubyObject receiver, IRubyObject[] args) {
        switch (index) {
            case 61697: {
                return RubyArray.newInstance(receiver, args);
            }
            case 61698: {
                return RubyArray.create(receiver, args);
            }
        }
        Asserts.notReached();
        return null;
    }
}

