/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.builtin.definitions;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.ThreadClass;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.definitions.ClassDefinition;
import org.jruby.runtime.builtin.definitions.MethodContext;
import org.jruby.runtime.builtin.definitions.SingletonMethodContext;
import org.jruby.util.Asserts;

public class ThreadDefinition
extends ClassDefinition {
    private static final int THREAD = 61440;
    private static final int STATIC = 61696;
    public static final int AREF = 61441;
    public static final int ASET = 61442;
    public static final int ABORT_ON_EXCEPTION = 61443;
    public static final int ABORT_ON_EXCEPTION_SET = 61444;
    public static final int IS_ALIVE = 61445;
    public static final int EXIT = 61446;
    public static final int JOIN = 61447;
    public static final int IS_KEY = 61448;
    public static final int PRIORITY = 61449;
    public static final int PRIORITY_SET = 61450;
    public static final int RAISE = 61451;
    public static final int STATUS = 61452;
    public static final int CURRENT = 61697;
    public static final int NEWINSTANCE = 61698;
    public static final int LIST = 61699;
    public static final int PASS = 61700;
    public static final int START = 61701;

    public ThreadDefinition(Ruby runtime) {
        super(runtime);
    }

    protected RubyClass createType(Ruby runtime) {
        RubyClass result = runtime.defineClass("Thread", (RubyClass)runtime.getClasses().getClass("Object"));
        return result;
    }

    protected void defineMethods(MethodContext context) {
        context.create("[]", 61441, 1);
        context.create("[]=", 61442, 2);
        context.create("abort_on_exception", 61443, 0);
        context.create("abort_on_exception=", 61444, 1);
        context.create("alive?", 61445, 0);
        context.create("exit", 61446, 0);
        context.create("join", 61447, 0);
        context.create("key?", 61448, 1);
        context.create("priority", 61449, 0);
        context.create("priority=", 61450, 1);
        context.createOptional("raise", 61451, 1);
        context.create("status", 61452, 0);
    }

    protected void defineSingletonMethods(SingletonMethodContext context) {
        context.create("current", 61697, 0);
        context.createOptional("fork", 61698, 0);
        context.create("list", 61699, 0);
        context.createOptional("new", 61698, 0);
        context.create("pass", 61700, 0);
        context.createOptional("start", 61701, 0);
    }

    public IRubyObject callIndexed(int index, IRubyObject receiver, IRubyObject[] args) {
        switch (index) {
            case 61697: {
                return ThreadClass.current(receiver);
            }
            case 61698: {
                return ThreadClass.newInstance(receiver, args);
            }
            case 61699: {
                return ThreadClass.list(receiver);
            }
            case 61700: {
                return ThreadClass.pass(receiver);
            }
            case 61701: {
                return ThreadClass.start(receiver, args);
            }
        }
        Asserts.notReached();
        return null;
    }
}

