/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.Iterator;
import org.ablaf.ast.INode;
import org.ablaf.common.ISourcePosition;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyProc;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ScopeNode;
import org.jruby.ast.types.IListNode;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.evaluator.EvaluateVisitor;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.ReturnJump;
import org.jruby.internal.runtime.methods.AbstractMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Namespace;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class DefaultMethod
extends AbstractMethod {
    private ScopeNode body;
    private ArgsNode argsNode;
    private Namespace namespace;

    public DefaultMethod(ScopeNode body, ArgsNode argsNode, Namespace namespace, Visibility visibility) {
        super(visibility);
        this.body = body;
        this.argsNode = argsNode;
        this.namespace = namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(Ruby ruby, IRubyObject receiver, String name, IRubyObject[] args, boolean noSuper) {
        RubyProc optionalBlockArg = null;
        if (this.argsNode.getBlockArgNode() != null && ruby.isBlockGiven()) {
            optionalBlockArg = RubyProc.newProc(ruby);
        }
        ruby.getScope().push();
        Namespace savedNamespace = null;
        savedNamespace = ruby.getNamespace();
        ruby.setNamespace(this.namespace);
        ruby.getCurrentFrame().setNamespace(this.namespace);
        if (this.body.getLocalNames() != null) {
            ruby.getScope().resetLocalVariables(this.body.getLocalNames());
        }
        ruby.pushDynamicVars();
        try {
            if (this.argsNode != null) {
                this.prepareArguments(ruby, receiver, args);
            }
            if (optionalBlockArg != null) {
                ruby.getScope().setValue(this.argsNode.getBlockArgNode().getCount(), optionalBlockArg);
            }
            this.traceCall(ruby, receiver, name);
            IRubyObject iRubyObject = receiver.eval(this.body.getBodyNode());
            return iRubyObject;
        }
        catch (ReturnJump re) {
            IRubyObject iRubyObject = re.getReturnValue();
            return iRubyObject;
        }
        finally {
            ruby.popDynamicVars();
            ruby.getScope().pop();
            ruby.setNamespace(savedNamespace);
            this.traceReturn(ruby, receiver, name);
        }
    }

    private void prepareArguments(Ruby ruby, IRubyObject receiver, IRubyObject[] args) {
        int expectedArgsCount;
        if (args == null) {
            args = IRubyObject.NULL_ARRAY;
        }
        if ((expectedArgsCount = this.argsNode.getArgsCount()) > args.length) {
            throw new ArgumentError(ruby, "Wrong # of arguments(" + args.length + " for " + expectedArgsCount + ")");
        }
        if (this.argsNode.getRestArg() == -1 && this.argsNode.getOptArgs() != null) {
            int opt = expectedArgsCount + this.argsNode.getOptArgs().size();
            if (opt < args.length) {
                throw new ArgumentError(ruby, "wrong # of arguments(" + args.length + " for " + opt + ")");
            }
            ruby.getCurrentFrame().setArgs(args);
        }
        if (ruby.getScope().hasLocalVariables()) {
            if (expectedArgsCount > 0) {
                int i = 0;
                while (i < expectedArgsCount) {
                    ruby.getScope().setValue(i + 2, args[i]);
                    ++i;
                }
            }
            if (this.argsNode.getOptArgs() != null) {
                IListNode optArgs = this.argsNode.getOptArgs();
                Iterator iter = optArgs.iterator();
                int i = expectedArgsCount;
                while (i < args.length && iter.hasNext()) {
                    new AssignmentVisitor(ruby, receiver).assign((INode)iter.next(), args[i], true);
                    ++expectedArgsCount;
                    ++i;
                }
                while (iter.hasNext()) {
                    EvaluateVisitor.createVisitor(receiver).eval((INode)iter.next());
                }
            }
            if (this.argsNode.getRestArg() >= 0) {
                RubyArray array = RubyArray.newArray(ruby, args.length - expectedArgsCount);
                int i = expectedArgsCount;
                while (i < args.length) {
                    array.append(args[i]);
                    ++i;
                }
                ruby.getScope().setValue(this.argsNode.getRestArg(), array);
            }
        }
    }

    private void traceReturn(Ruby ruby, IRubyObject receiver, String name) {
        if (ruby.getTraceFunction() == null) {
            return;
        }
        ISourcePosition position = ruby.getFrameStack().getPrevious().getPosition();
        if (position == null) {
            position = ruby.getPosition();
        }
        ruby.callTraceFunction("return", position, receiver, name, this.getImplementationClass());
    }

    private void traceCall(Ruby ruby, IRubyObject receiver, String name) {
        if (ruby.getTraceFunction() == null) {
            return;
        }
        ISourcePosition lPosition = null;
        if (this.body != null) {
            if (this.body.getBodyNode() != null) {
                if (this.body.getBodyNode().getPosition() != null) {
                    lPosition = this.body.getBodyNode().getPosition();
                }
            } else if (this.body.getPosition() != null) {
                lPosition = this.body.getPosition();
            }
        } else if (this.argsNode != null) {
            lPosition = this.argsNode.getPosition();
        }
        if (lPosition == null) {
            lPosition = ruby.getPosition();
        }
        ruby.callTraceFunction("call", lPosition, receiver, name, this.getImplementationClass());
    }

    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    public Arity getArity() {
        if (this.getArgsNode() == null) {
            return Arity.noArguments();
        }
        ArgsNode args = this.getArgsNode();
        int argsCount = args.getArgsCount();
        if (args.getOptArgs() != null || args.getRestArg() >= 0) {
            return Arity.required(argsCount);
        }
        return Arity.createArity(argsCount);
    }
}

