/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.TypeError;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Asserts;

public class JavaArray
extends JavaObject
implements IndexCallable {
    public JavaArray(Ruby runtime, Object array) {
        super(runtime, runtime.getClasses().getJavaArrayClass(), array);
        Asserts.isTrue(array.getClass().isArray());
    }

    public static RubyClass createJavaArrayClass(Ruby runtime) {
        RubyClass javaArrayClass = runtime.defineClass("JavaArray", runtime.getClasses().getJavaObjectClass());
        return javaArrayClass;
    }

    public RubyFixnum length() {
        int length = ((Object[])this.getValue()).length;
        return RubyFixnum.newFixnum(this.getRuntime(), length);
    }

    public IRubyObject aref(IRubyObject index) {
        if (!(index instanceof RubyInteger)) {
            throw new TypeError(this.getRuntime(), index, this.getRuntime().getClasses().getIntegerClass());
        }
        int intIndex = (int)((RubyInteger)index).getLongValue();
        Object[] array = (Object[])this.getValue();
        if (intIndex < 0 || intIndex >= array.length) {
            throw new ArgumentError(this.getRuntime(), "index out of bounds for java array (" + intIndex + " for length " + array.length + ")");
        }
        Object result = array[intIndex];
        if (result == null) {
            return this.getRuntime().getNil();
        }
        return JavaObject.wrap(this.getRuntime(), result);
    }

    public IRubyObject aset(IRubyObject index, IRubyObject value) {
        if (!(index instanceof RubyInteger)) {
            throw new TypeError(this.getRuntime(), index, this.getRuntime().getClasses().getIntegerClass());
        }
        int intIndex = (int)((RubyInteger)index).getLongValue();
        if (!(value instanceof JavaObject)) {
            throw new TypeError(this.getRuntime(), "not a java object:" + value);
        }
        Object[] array = (Object[])this.getValue();
        try {
            array[intIndex] = ((JavaObject)value).getValue();
        }
        catch (IndexOutOfBoundsException e) {
            throw new ArgumentError(this.getRuntime(), "index out of bounds for java array (" + intIndex + " for length " + array.length + ")");
        }
        return value;
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            default: 
        }
        return super.callIndexed(index, args);
    }
}

