/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.TypeError;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.IndexedCallback;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaField
extends RubyObject
implements IndexCallable {
    private final Field field;
    private static final int VALUE_TYPE = 1;
    private static final int PUBLIC_P = 2;
    private static final int STATIC_P = 3;
    private static final int VALUE = 4;
    private static final int SET_VALUE = 5;
    private static final int FINAL_P = 6;
    private static final int STATIC_VALUE = 7;
    private static final int NAME = 8;

    public static RubyClass createJavaFieldClass(Ruby runtime, RubyModule javaModule) {
        RubyClass javaFieldClass = javaModule.defineClassUnder("JavaField", runtime.getClasses().getObjectClass());
        javaFieldClass.defineMethod("value_type", IndexedCallback.create(1, 0));
        javaFieldClass.defineMethod("public?", IndexedCallback.create(2, 0));
        javaFieldClass.defineMethod("static?", IndexedCallback.create(3, 0));
        javaFieldClass.defineMethod("value", IndexedCallback.create(4, 1));
        javaFieldClass.defineMethod("set_value", IndexedCallback.create(5, 2));
        javaFieldClass.defineMethod("final?", IndexedCallback.create(6, 0));
        javaFieldClass.defineMethod("static_value", IndexedCallback.create(7, 0));
        javaFieldClass.defineMethod("name", IndexedCallback.create(8, 0));
        return javaFieldClass;
    }

    public JavaField(Ruby runtime, Field field) {
        super(runtime, (RubyClass)runtime.getClasses().getClassFromPath("Java::JavaField"));
        this.field = field;
    }

    public RubyString value_type() {
        return RubyString.newString(this.getRuntime(), this.field.getType().getName());
    }

    public RubyBoolean public_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), Modifier.isPublic(this.field.getModifiers()));
    }

    public RubyBoolean static_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), Modifier.isStatic(this.field.getModifiers()));
    }

    public JavaObject value(IRubyObject object) {
        if (!(object instanceof JavaObject)) {
            throw new TypeError(this.getRuntime(), "not a java object");
        }
        Object javaObject = ((JavaObject)object).getValue();
        try {
            return JavaObject.wrap(this.getRuntime(), this.field.get(javaObject));
        }
        catch (IllegalAccessException iae) {
            throw new TypeError(this.getRuntime(), "illegal access");
        }
    }

    public JavaObject set_value(IRubyObject object, IRubyObject value) {
        if (!(object instanceof JavaObject)) {
            throw new TypeError(this.getRuntime(), "not a java object: " + object);
        }
        if (!(value instanceof JavaObject)) {
            throw new TypeError(this.getRuntime(), "not a java object:" + value);
        }
        Object javaObject = ((JavaObject)object).getValue();
        try {
            Object convertedValue = JavaUtil.convertArgument(((JavaObject)value).getValue(), this.field.getType());
            this.field.set(javaObject, convertedValue);
        }
        catch (IllegalAccessException iae) {
            throw new TypeError(this.getRuntime(), "illegal access on setting variable: " + iae.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new TypeError(this.getRuntime(), "wrong type for " + this.field.getType().getName() + ": " + ((JavaObject)value).getValue().getClass().getName());
        }
        return (JavaObject)value;
    }

    public RubyBoolean final_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), Modifier.isFinal(this.field.getModifiers()));
    }

    public JavaObject static_value() {
        try {
            return JavaObject.wrap(this.getRuntime(), this.field.get(null));
        }
        catch (IllegalAccessException iae) {
            throw new TypeError(this.getRuntime(), "illegal static value access: " + iae.getMessage());
        }
    }

    public RubyString name() {
        return RubyString.newString(this.getRuntime(), this.field.getName());
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 1: {
                return this.value_type();
            }
            case 2: {
                return this.public_p();
            }
            case 3: {
                return this.static_p();
            }
            case 4: {
                return this.value(args[0]);
            }
            case 5: {
                return this.set_value(args[0], args[1]);
            }
            case 6: {
                return this.final_p();
            }
            case 7: {
                return this.static_value();
            }
            case 8: {
                return this.name();
            }
        }
        return super.callIndexed(index, args);
    }
}

