/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.TypeError;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.IndexedCallback;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaObject
extends RubyObject
implements IndexCallable {
    private final Object value;
    private static final int TO_S = 1;
    private static final int EQUAL = 2;
    private static final int HASH = 3;
    private static final int JAVA_TYPE = 4;
    private static final int JAVA_CLASS = 5;
    private static final int LENGTH = 6;
    private static final int AREF = 7;
    private static final int ASET = 8;

    protected JavaObject(Ruby ruby, RubyClass rubyClass, Object value) {
        super(ruby, rubyClass);
        this.value = value;
    }

    protected JavaObject(Ruby ruby, Object value) {
        this(ruby, ruby.getClasses().getJavaObjectClass(), value);
    }

    public static synchronized JavaObject wrap(Ruby runtime, Object value) {
        JavaObject wrapper = runtime.getJavaSupport().getJavaObjectFromCache(value);
        if (wrapper == null) {
            wrapper = value != null && value.getClass().isArray() ? new JavaArray(runtime, value) : new JavaObject(runtime, value);
            runtime.getJavaSupport().putJavaObjectIntoCache(wrapper);
        }
        return wrapper;
    }

    public Class getJavaClass() {
        return this.value != null ? this.value.getClass() : Void.TYPE;
    }

    public Object getValue() {
        return this.value;
    }

    public static RubyClass createJavaObjectClass(Ruby ruby) {
        RubyClass javaObjectClass = ruby.defineClass("JavaObject", ruby.getClasses().getObjectClass());
        javaObjectClass.defineMethod("to_s", IndexedCallback.create(1, 0));
        javaObjectClass.defineMethod("eql?", IndexedCallback.create(2, 1));
        javaObjectClass.defineMethod("==", IndexedCallback.create(2, 1));
        javaObjectClass.defineMethod("hash", IndexedCallback.create(3, 0));
        javaObjectClass.defineMethod("java_type", IndexedCallback.create(4, 0));
        javaObjectClass.defineMethod("java_class", IndexedCallback.create(5, 0));
        javaObjectClass.defineMethod("length", IndexedCallback.create(6, 0));
        javaObjectClass.defineMethod("[]", IndexedCallback.create(7, 1));
        javaObjectClass.defineMethod("[]=", IndexedCallback.create(8, 2));
        javaObjectClass.getMetaClass().undefineMethod("new");
        return javaObjectClass;
    }

    public RubyFixnum hash() {
        int result = this.value == null ? 0 : this.value.hashCode();
        return RubyFixnum.newFixnum(this.runtime, result);
    }

    public RubyString to_s() {
        String result = this.getValue() == null ? "null" : this.getValue().toString();
        return RubyString.newString(this.getRuntime(), result);
    }

    public RubyBoolean equal(IRubyObject other) {
        if (other instanceof JavaObject) {
            if (this.getValue() == null && ((JavaObject)other).getValue() == null) {
                return this.getRuntime().getTrue();
            }
            return this.getValue().equals(((JavaObject)other).getValue()) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        return this.getRuntime().getFalse();
    }

    public RubyString java_type() {
        return RubyString.newString(this.getRuntime(), this.getJavaClass().getName());
    }

    public IRubyObject java_class() {
        return new JavaClass(this.getRuntime(), this.getJavaClass());
    }

    public RubyFixnum length() {
        throw new TypeError(this.getRuntime(), "not a java array");
    }

    public IRubyObject aref(IRubyObject index) {
        throw new TypeError(this.getRuntime(), "not a java array");
    }

    public IRubyObject aset(IRubyObject index, IRubyObject value) {
        throw new TypeError(this.getRuntime(), "not a java array");
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 1: {
                return this.to_s();
            }
            case 2: {
                return this.equal(args[0]);
            }
            case 3: {
                return this.hash();
            }
            case 4: {
                return this.java_type();
            }
            case 5: {
                return this.java_class();
            }
            case 6: {
                return this.length();
            }
            case 7: {
                return this.aref(args[0]);
            }
            case 8: {
                return this.aset(args[0], args[1]);
            }
        }
        return super.callIndexed(index, args);
    }
}

