/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.RubyProxy;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaUtil {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Void;

    public static Object convertRubyToJava(IRubyObject rubyObject) {
        return JavaUtil.convertRubyToJava(rubyObject, null);
    }

    public static Object convertRubyToJava(IRubyObject rubyObject, Class javaClass) {
        if (rubyObject == null || rubyObject.isNil()) {
            return null;
        }
        if (rubyObject instanceof JavaObject) {
            return ((JavaObject)rubyObject).getValue();
        }
        if ((javaClass == (class$java$lang$Object == null ? (class$java$lang$Object = JavaUtil.class$("java.lang.Object")) : class$java$lang$Object) || javaClass == null) && (javaClass = rubyObject.getJavaClass()) == (class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = JavaUtil.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject)) {
            Class clazz = javaClass = class$java$lang$String == null ? (class$java$lang$String = JavaUtil.class$("java.lang.String")) : class$java$lang$String;
        }
        if (javaClass.isInstance(rubyObject)) {
            return rubyObject;
        }
        if (javaClass.isPrimitive()) {
            String cName = javaClass.getName();
            if (cName == "boolean") {
                return new Boolean(rubyObject.isTrue());
            }
            if (cName == "float") {
                if (rubyObject.respondsTo("to_f")) {
                    return new Float(((RubyNumeric)rubyObject.callMethod("to_f")).getDoubleValue());
                }
                return new Float(0.0);
            }
            if (cName == "double") {
                if (rubyObject.respondsTo("to_f")) {
                    return new Double(((RubyNumeric)rubyObject.callMethod("to_f")).getDoubleValue());
                }
                return new Double(0.0);
            }
            if (cName == "long") {
                if (rubyObject.respondsTo("to_i")) {
                    return new Long(((RubyNumeric)rubyObject.callMethod("to_i")).getLongValue());
                }
                return new Long(0L);
            }
            if (cName == "int") {
                if (rubyObject.respondsTo("to_i")) {
                    return new Integer((int)((RubyNumeric)rubyObject.callMethod("to_i")).getLongValue());
                }
                return new Integer(0);
            }
            if (cName == "short") {
                if (rubyObject.respondsTo("to_i")) {
                    return new Short((short)((RubyNumeric)rubyObject.callMethod("to_i")).getLongValue());
                }
                return new Short(0);
            }
            if (cName == "byte") {
                if (rubyObject.respondsTo("to_i")) {
                    return new Byte((byte)((RubyNumeric)rubyObject.callMethod("to_i")).getLongValue());
                }
                return new Byte(0);
            }
            String s = ((RubyString)rubyObject.callMethod("to_s")).getValue();
            if (s.length() > 0) {
                return new Character(s.charAt(0));
            }
            return new Character('\u0000');
        }
        if (javaClass == (class$java$lang$String == null ? (class$java$lang$String = JavaUtil.class$("java.lang.String")) : class$java$lang$String)) {
            return ((RubyString)rubyObject.callMethod("to_s")).getValue();
        }
        return ((JavaObject)rubyObject).getValue();
    }

    public static IRubyObject[] convertJavaArrayToRuby(Ruby ruby, Object[] objects) {
        IRubyObject[] rubyObjects = new IRubyObject[objects.length];
        int i = 0;
        while (i < objects.length) {
            rubyObjects[i] = JavaUtil.convertJavaToRuby(ruby, objects[i]);
            ++i;
        }
        return rubyObjects;
    }

    public static IRubyObject convertJavaToRuby(Ruby ruby, Object object) {
        if (object == null) {
            return ruby.getNil();
        }
        return JavaUtil.convertJavaToRuby(ruby, object, object.getClass());
    }

    public static IRubyObject convertJavaToRuby(Ruby ruby, Object object, Class javaClass) {
        if (object == null) {
            return ruby.getNil();
        }
        if (javaClass.isPrimitive()) {
            String cName = javaClass.getName();
            if (cName == "boolean") {
                return RubyBoolean.newBoolean(ruby, (Boolean)object);
            }
            if (cName == "float" || cName == "double") {
                return RubyFloat.newFloat(ruby, ((Number)object).doubleValue());
            }
            if (cName == "char") {
                return RubyFixnum.newFixnum(ruby, ((Character)object).charValue());
            }
            return RubyFixnum.newFixnum(ruby, ((Number)object).longValue());
        }
        if (javaClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JavaUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return RubyBoolean.newBoolean(ruby, (Boolean)object);
        }
        if (javaClass == (class$java$lang$Float == null ? (class$java$lang$Float = JavaUtil.class$("java.lang.Float")) : class$java$lang$Float) || javaClass == (class$java$lang$Double == null ? (class$java$lang$Double = JavaUtil.class$("java.lang.Double")) : class$java$lang$Double)) {
            return RubyFloat.newFloat(ruby, ((Number)object).doubleValue());
        }
        if (javaClass == (class$java$lang$Character == null ? (class$java$lang$Character = JavaUtil.class$("java.lang.Character")) : class$java$lang$Character)) {
            return RubyFixnum.newFixnum(ruby, ((Character)object).charValue());
        }
        if ((class$java$lang$Number == null ? (class$java$lang$Number = JavaUtil.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(javaClass)) {
            return RubyFixnum.newFixnum(ruby, ((Number)object).longValue());
        }
        if (javaClass == (class$java$lang$String == null ? (class$java$lang$String = JavaUtil.class$("java.lang.String")) : class$java$lang$String)) {
            return RubyString.newString(ruby, object.toString());
        }
        if ((class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = JavaUtil.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject).isAssignableFrom(javaClass)) {
            return (IRubyObject)object;
        }
        if (object instanceof RubyProxy) {
            return ((RubyProxy)object).getRubyObject();
        }
        return JavaObject.wrap(ruby, object);
    }

    public static Class primitiveToWrapper(Class type) {
        if (type == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = JavaUtil.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (type == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = JavaUtil.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (type == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = JavaUtil.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (type == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = JavaUtil.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (type == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = JavaUtil.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (type == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = JavaUtil.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (type == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = JavaUtil.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (type == Void.TYPE) {
            return class$java$lang$Void == null ? (class$java$lang$Void = JavaUtil.class$("java.lang.Void")) : class$java$lang$Void;
        }
        if (type == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = JavaUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        return type;
    }

    public static Object convertArgument(Object argument, Class parameterType) {
        if (argument instanceof JavaObject && (argument = ((JavaObject)argument).getValue()) == null) {
            return null;
        }
        Class type = JavaUtil.primitiveToWrapper(parameterType);
        if (type == (class$java$lang$Void == null ? (class$java$lang$Void = JavaUtil.class$("java.lang.Void")) : class$java$lang$Void)) {
            return null;
        }
        if (argument instanceof Number) {
            Number number = (Number)argument;
            if (type == (class$java$lang$Long == null ? (class$java$lang$Long = JavaUtil.class$("java.lang.Long")) : class$java$lang$Long)) {
                return new Long(number.longValue());
            }
            if (type == (class$java$lang$Integer == null ? (class$java$lang$Integer = JavaUtil.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return new Integer(number.intValue());
            }
            if (type == (class$java$lang$Short == null ? (class$java$lang$Short = JavaUtil.class$("java.lang.Short")) : class$java$lang$Short)) {
                return new Short(number.shortValue());
            }
            if (type == (class$java$lang$Byte == null ? (class$java$lang$Byte = JavaUtil.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return new Byte(number.byteValue());
            }
            if (type == (class$java$lang$Character == null ? (class$java$lang$Character = JavaUtil.class$("java.lang.Character")) : class$java$lang$Character)) {
                return new Character((char)number.intValue());
            }
            if (type == (class$java$lang$Double == null ? (class$java$lang$Double = JavaUtil.class$("java.lang.Double")) : class$java$lang$Double)) {
                return new Double(number.doubleValue());
            }
            if (type == (class$java$lang$Float == null ? (class$java$lang$Float = JavaUtil.class$("java.lang.Float")) : class$java$lang$Float)) {
                return new Float(number.floatValue());
            }
        }
        return argument;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

