/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import org.ablaf.common.IErrorHandler;
import org.ablaf.common.ISourcePosition;
import org.ablaf.lexer.ILexerSource;
import org.ablaf.lexer.ILexerState;
import org.ablaf.lexer.IYaccLexer;
import org.jruby.ast.AbstractNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.types.IListNode;
import org.jruby.ast.util.ListNodeUtil;
import org.jruby.lexer.yacc.IRubyLexerSupport;
import org.jruby.lexer.yacc.Keyword;
import org.jruby.lexer.yacc.LexState;
import org.jruby.lexer.yacc.LexerException;
import org.jruby.lexer.yacc.Messages;
import org.jruby.lexer.yacc.RubyLexerSupport;
import org.jruby.lexer.yacc.StackState;
import org.jruby.lexer.yacc.StringToken;

public class RubyYaccLexer
implements IYaccLexer {
    private int token = 0;
    private Object yaccValue;
    private IRubyLexerSupport support;
    private IErrorHandler errorHandler;
    private LexState lexState;
    private StringBuffer tokenBuffer = new StringBuffer(60);
    private StackState conditionState = new StackState();
    private StackState cmdArgumentState = new StackState();
    ISourcePosition currentPos;
    private static final int EOF = 0;

    public boolean advance() throws IOException {
        this.token = this.yylex();
        return this.token != 0;
    }

    public int token() {
        return this.token;
    }

    public Object value() {
        return this.yaccValue;
    }

    public void resetStacks() {
        this.conditionState.reset();
        this.cmdArgumentState.reset();
    }

    private String tok() {
        return this.tokenBuffer.toString();
    }

    private int toklen() {
        return this.tokenBuffer.length();
    }

    private char toklast() {
        return this.tokenBuffer.charAt(this.toklen() - 1);
    }

    private void newToken() {
        this.tokenBuffer.setLength(0);
    }

    private int parseRegexp(char closeQuote, char openQuote) {
        ISourcePosition position = this.support.getPosition();
        DRegexpNode list = new DRegexpNode(position);
        StringToken token = new StringToken(this.support, this.errorHandler, position);
        int nest = 0;
        boolean lDyn = false;
        char c = this.support.read();
        while (c != '\u0000' && (c != closeQuote || nest != 0)) {
            switch (c) {
                case '#': {
                    try {
                        lDyn = this.parseExpressionString(list, closeQuote, token) || lDyn;
                        break;
                    }
                    catch (EOFException e) {
                        this.errorHandler.handleError(11, position, Messages.getString("unterminated_regexp"));
                        return 0;
                    }
                }
                case '\\': {
                    try {
                        token.appendEscape(closeQuote);
                        break;
                    }
                    catch (EOFException e) {
                        return 0;
                    }
                }
                case '\u0000': {
                    this.errorHandler.handleError(11, position, Messages.getString("unterminated_regexp"));
                    return 0;
                }
                default: {
                    if (openQuote != '\u0000') {
                        if (c == openQuote) {
                            ++nest;
                        } else if (c == closeQuote) {
                            --nest;
                        }
                    }
                    token.append(c);
                }
            }
            c = this.support.read();
        }
        int options = 0;
        boolean once = false;
        int kcode = 0;
        char c2 = this.support.read();
        block21: while (true) {
            switch (c2) {
                case 'i': {
                    options |= 1;
                    break;
                }
                case 'x': {
                    options |= 2;
                    break;
                }
                case 'p': {
                    this.errorHandler.handleError(1, position, Messages.getString("opsolete_slash_p_option"));
                    options |= 0xC;
                    break;
                }
                case 'm': {
                    options |= 4;
                    break;
                }
                case 'o': {
                    once = true;
                    break block21;
                }
                case 'n': {
                    kcode = 16;
                    break;
                }
                case 'e': {
                    kcode = 32;
                    break;
                }
                case 's': {
                    kcode = 48;
                    break;
                }
                case 'u': {
                    kcode = 64;
                    break;
                }
                default: {
                    this.support.unread();
                    break block21;
                }
            }
            c2 = this.support.read();
        }
        this.lexState = LexState.EXPR_END;
        if (lDyn) {
            if (token.getLength() > 0) {
                list.add(new StrNode(token.getPosition(), token.getToken()));
            }
            list.setOptions(options | kcode);
            list.setOnce(once);
            this.yaccValue = list;
            return 316;
        }
        this.yaccValue = new RegexpNode(position, token.getToken(), options | kcode);
        return 314;
    }

    private int parseString(char func, char closeQuote, char openQuote) {
        if (func == '\'') {
            return this.parseSingleQuotedString(closeQuote, openQuote);
        }
        if (func == '\u0000') {
            this.yaccValue = this.support.readLine();
            return 312;
        }
        ISourcePosition position = this.support.getPosition();
        StringToken token = new StringToken(this.support, this.errorHandler, position);
        AbstractNode list = func == '`' ? new DXStrNode(position) : new DStrNode(position);
        int nest = 0;
        boolean lDyn = false;
        char c = this.support.read();
        while (c != closeQuote || nest > 0) {
            switch (c) {
                case '\u0000': {
                    this.errorHandler.handleError(11, position, Messages.getString("unterminated_string"));
                    return 0;
                }
                case '#': {
                    try {
                        lDyn = this.parseExpressionString((IListNode)((Object)list), closeQuote, token) || lDyn;
                        break;
                    }
                    catch (EOFException e) {
                        this.errorHandler.handleError(11, position, Messages.getString("unterminated_string"));
                        return 0;
                    }
                }
                case '\\': {
                    c = this.support.read();
                    if (c == '\n') break;
                    if (c == closeQuote) {
                        token.append(c);
                        break;
                    }
                    this.support.unread();
                    if (func != '\"') {
                        token.append('\\');
                    }
                    try {
                        token.append(this.support.readEscape());
                    }
                    catch (LexerException lExcptn) {
                        token.append('\u0000');
                        this.errorHandler.handleError(10, this.support.getPosition(), lExcptn.getMessage());
                    }
                    break;
                }
                default: {
                    if (openQuote != '\u0000') {
                        if (c == openQuote) {
                            ++nest;
                        }
                        if (c == closeQuote && nest-- == 0) break;
                    }
                    token.append(c);
                }
            }
            c = this.support.read();
        }
        this.lexState = LexState.EXPR_END;
        if (lDyn) {
            if (token.getLength() > 0) {
                list.add(new StrNode(token.getPosition(), token.getToken()));
            }
            this.yaccValue = list;
            return func == '`' ? 315 : 319;
        }
        this.yaccValue = token.getToken();
        return func == '`' ? 313 : 312;
    }

    private int parseSingleQuotedString(char closeQuote, char openQuote) {
        ISourcePosition position = this.support.getPosition();
        int nest = 0;
        StringBuffer stringToken = new StringBuffer();
        char c = this.support.read();
        while (c != closeQuote || nest > 0) {
            block0 : switch (c) {
                case '\u0000': {
                    this.errorHandler.handleError(11, position, Messages.getString("unterminated_string"));
                    return 0;
                }
                case '\\': {
                    c = this.support.read();
                    switch (c) {
                        case '\n': {
                            break block0;
                        }
                        case '\\': {
                            c = '\\';
                            break;
                        }
                        default: {
                            if (c == closeQuote || openQuote != '\u0000' && c == openQuote) {
                                stringToken.append(c);
                                break block0;
                            }
                            stringToken.append('\\');
                        }
                    }
                }
                default: {
                    if (openQuote != '\u0000') {
                        if (c == openQuote) {
                            ++nest;
                        }
                        if (c == closeQuote && nest-- == 0) break;
                    }
                    stringToken.append(c);
                }
            }
            c = this.support.read();
        }
        this.lexState = LexState.EXPR_END;
        this.yaccValue = stringToken.toString();
        return 312;
    }

    private int parseQuotedWords(char closeQuote, char openQuote) {
        char c = this.support.read();
        ISourcePosition position = this.support.getPosition();
        while (Character.isWhitespace(c)) {
            c = this.support.read();
        }
        this.support.unread();
        ArrayNode qwords = new ArrayNode(position);
        int nest = 0;
        StringBuffer stringToken = new StringBuffer();
        block5: while ((c = this.support.read()) != closeQuote || nest > 0) {
            if (c == '\u0000') {
                this.errorHandler.handleError(11, position, Messages.getString("unterminated_string"));
                return 0;
            }
            if (c == '\\') {
                c = this.support.read();
                switch (c) {
                    case '\n': {
                        continue block5;
                    }
                    case '\\': {
                        c = '\\';
                        break;
                    }
                    default: {
                        if (c == closeQuote || openQuote != '\u0000' && c == openQuote) {
                            stringToken.append(c);
                            continue block5;
                        }
                        if (!Character.isWhitespace(c)) {
                            stringToken.append('\\');
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (Character.isWhitespace(c)) {
                qwords.add(new StrNode(this.support.getPosition(), stringToken.toString()));
                stringToken.setLength(0);
                c = this.support.read();
                while (Character.isWhitespace(c)) {
                    c = this.support.read();
                }
                this.support.unread();
                continue;
            }
            if (openQuote != '\u0000') {
                if (c == openQuote) {
                    ++nest;
                }
                if (c == closeQuote && nest-- == 0) break;
            }
            stringToken.append(c);
        }
        if (stringToken.length() > 0) {
            qwords.add(new StrNode(this.support.getPosition(), stringToken.toString()));
        }
        this.lexState = LexState.EXPR_END;
        this.yaccValue = qwords;
        return 320;
    }

    /*
     * Unable to fully structure code
     */
    private int parseHereDocument(char closeQuote, boolean indent) {
        position = this.support.getPosition();
        this.newToken();
        switch (closeQuote) {
            case '\"': 
            case '\'': 
            case '`': {
                while ((c = this.support.read()) != closeQuote) {
                    this.tokenBuffer.append((char)var3_4);
                }
                if (closeQuote != '\'') break;
                closeQuote = '\u0000';
                break;
            }
            default: {
                c = closeQuote;
                closeQuote = (char)34;
                if (RubyYaccLexer.isIdentifierChar(c)) ** GOTO lbl21
                this.errorHandler.handleError(1, this.support.getPosition(), Messages.getString("deprecated_bare_<<"));
                break;
lbl-1000:
                // 1 sources

                {
                    this.tokenBuffer.append(c);
                    c = this.support.read();
lbl21:
                    // 2 sources

                    ** while (RubyYaccLexer.isIdentifierChar((char)c))
                }
lbl22:
                // 1 sources

                this.support.unread();
            }
        }
        startPosition = this.support.getPosition();
        buffer = this.support.readLine() + '\n';
        eos = this.tok();
        sb = new StringBuffer();
        list = null;
        while (true) {
            if ((line = this.support.readLine()) == null) {
                this.errorHandler.handleError(11, position, Messages.getString("cannot_found_string_before_eof", eos));
                return 0;
            }
            if ((indent && line.trim().startsWith(eos) || line.startsWith(eos)) && line.trim().length() == eos.length()) break;
            this.support.unreadMany(line.length() + 1);
            do {
                switch (this.parseString(closeQuote, '\n', '\n')) {
                    case 312: 
                    case 313: {
                        this.yaccValue = (String)this.yaccValue + '\n';
                        if (list == null) {
                            sb.append(this.yaccValue);
                            break;
                        }
                        list.add(new StrNode(this.support.getPosition(), (String)this.yaccValue));
                        break;
                    }
                    case 319: {
                        if (list == null) {
                            list = new DStrNode(this.support.getPosition());
                            list.add(new StrNode(this.support.getPosition(), sb.toString()));
                        }
                    }
                    case 315: {
                        if (list == null) {
                            list = new DXStrNode(this.support.getPosition());
                            list.add(new StrNode(this.support.getPosition(), sb.toString()));
                        }
                        ListNodeUtil.addAll(list, (IListNode)this.yaccValue);
                        list.add(new StrNode(this.support.getPosition(), "\n"));
                        break;
                    }
                    case 0: {
                        this.errorHandler.handleError(11, position, Messages.getString("cannot_found_string_before_eof", eos));
                        return 0;
                    }
                }
            } while (this.support.getLastRead() != '\n');
        }
        this.lexState = LexState.EXPR_END;
        this.support.setBuffer(buffer, startPosition);
        switch (closeQuote) {
            case '\u0000': 
            case '\"': 
            case '\'': {
                if (list != null) {
                    this.yaccValue = list;
                    return 319;
                }
                this.yaccValue = sb.toString();
                return 312;
            }
            case '`': {
                if (list != null) {
                    this.yaccValue = list;
                    return 315;
                }
                this.yaccValue = sb.toString();
                return 313;
            }
        }
        return 0;
    }

    private void arg_ambiguous() {
        this.errorHandler.handleError(2, this.support.getPosition(), Messages.getString("ambiguous_first_argument"));
    }

    public ISourcePosition getPosition() {
        return this.currentPos;
    }

    private boolean readSpace() {
        boolean spaceSeen = false;
        char c = this.support.read();
        block7: while (true) {
            switch (c) {
                case '\u0000': 
                case '\u0004': 
                case '\u001a': {
                    this.token = 0;
                    return spaceSeen;
                }
                case '\t': 
                case '\f': 
                case '\r': 
                case '\u0013': 
                case ' ': {
                    spaceSeen = true;
                    break;
                }
                case '#': {
                    this.support.readLine();
                    if (this.support.isEOF()) {
                        this.token = 0;
                        return spaceSeen;
                    }
                }
                case '\n': {
                    if (this.lexState.isExprBeg() || this.lexState.isExprFName() || this.lexState.isExprDot() || this.lexState.isExprClass()) break;
                    this.lexState = LexState.EXPR_BEG;
                    this.token = 10;
                    return spaceSeen;
                }
                case '=': {
                    if (this.support.getColumn() == 1 && this.support.isNext("begin") && Character.isWhitespace(this.support.getCharAt(6))) {
                        this.support.readLine();
                        c = this.support.read();
                        while (true) {
                            if (c == '\u0000') {
                                this.errorHandler.handleError(11, "embedded document meets end of file");
                                this.token = 0;
                                return spaceSeen;
                            }
                            if (c == '=' && this.support.getColumn() == 1 && this.support.isNext("end") && Character.isWhitespace(this.support.getCharAt(4))) break;
                            c = this.support.read();
                        }
                        this.support.readLine();
                        break;
                    }
                }
                default: {
                    break block7;
                }
            }
            c = this.support.read();
        }
        this.support.unread();
        return spaceSeen;
    }

    private int yylex() {
        char c;
        this.token = -1;
        boolean spaceSeen = this.readSpace();
        if (this.token != -1) {
            return this.token;
        }
        this.currentPos = this.support.getPosition();
        block44: while (true) {
            c = this.support.read();
            switch (c) {
                case '*': {
                    c = this.support.read();
                    if (c == '*') {
                        if (this.support.read() == '=') {
                            this.lexState = LexState.EXPR_BEG;
                            this.yaccValue = "**";
                            return 342;
                        }
                        this.support.unread();
                        c = '\u0143';
                    } else {
                        if (c == '=') {
                            this.yaccValue = "*";
                            this.lexState = LexState.EXPR_BEG;
                            return 342;
                        }
                        this.support.unread();
                        if (this.lexState.isArgument() && spaceSeen && !Character.isWhitespace(c)) {
                            this.errorHandler.handleError(2, this.support.getPosition(), "`*' interpreted as argument prefix");
                            c = '\u015b';
                        } else {
                            c = this.lexState.isExprBeg() || this.lexState.isExprMid() ? (char)'\u015b' : '*';
                        }
                    }
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    return c;
                }
                case '!': {
                    this.lexState = LexState.EXPR_BEG;
                    char c2 = this.support.read();
                    c = c2;
                    if (c2 == '=') {
                        return 327;
                    }
                    if (c == '~') {
                        return 333;
                    }
                    this.support.unread();
                    return 33;
                }
                case '=': {
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    c = this.support.read();
                    if (c == '=') {
                        c = this.support.read();
                        if (c == '=') {
                            return 326;
                        }
                        this.support.unread();
                        return 325;
                    }
                    if (c == '~') {
                        return 332;
                    }
                    if (c == '>') {
                        return 343;
                    }
                    this.support.unread();
                    return 61;
                }
                case '<': {
                    c = this.support.read();
                    if (!(c != '<' || this.lexState.isExprEnd() || this.lexState.isExprDot() || this.lexState.isExprEndArg() || this.lexState.isExprClass() || this.lexState.isArgument() && !spaceSeen)) {
                        char c2 = this.support.read();
                        boolean indent = false;
                        if (c2 == '-') {
                            indent = true;
                            c2 = this.support.read();
                        }
                        if ("\"'`".indexOf(c2) != -1 || RubyYaccLexer.isIdentifierChar(c2)) {
                            return this.parseHereDocument(c2, indent);
                        }
                        this.support.unread();
                    }
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    if (c == '=') {
                        char c3 = this.support.read();
                        c = c3;
                        if (c3 == '>') {
                            return 324;
                        }
                        this.support.unread();
                        return 329;
                    }
                    if (c == '<') {
                        if (this.support.read() == '=') {
                            this.lexState = LexState.EXPR_BEG;
                            this.yaccValue = "<<";
                            return 342;
                        }
                        this.support.unread();
                        return 338;
                    }
                    this.support.unread();
                    return 60;
                }
                case '>': {
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    c = this.support.read();
                    if (c == '=') {
                        return 328;
                    }
                    if (c == '>') {
                        char c4 = this.support.read();
                        c = c4;
                        if (c4 == '=') {
                            this.lexState = LexState.EXPR_BEG;
                            this.yaccValue = ">>";
                            return 342;
                        }
                        this.support.unread();
                        return 339;
                    }
                    this.support.unread();
                    return 62;
                }
                case '\"': {
                    return this.parseString(c, c, '\u0000');
                }
                case '`': {
                    if (this.lexState.isExprFName()) {
                        return c;
                    }
                    if (this.lexState.isExprDot()) {
                        return c;
                    }
                    return this.parseString(c, c, '\u0000');
                }
                case '\'': {
                    return this.parseSingleQuotedString(c, '\u0000');
                }
                case '?': {
                    if (this.lexState.isExprEnd()) {
                        this.lexState = LexState.EXPR_BEG;
                        return 63;
                    }
                    c = this.support.read();
                    if (c == '\u0000') {
                        this.errorHandler.handleError(11, this.support.getPosition(), Messages.getString("incomplete_character_syntax"));
                        return 0;
                    }
                    if (this.isArgState() && Character.isWhitespace(c)) {
                        this.support.unread();
                        this.lexState = LexState.EXPR_BEG;
                        return 63;
                    }
                    if (c == '\\') {
                        try {
                            c = this.support.readEscape();
                        }
                        catch (LexerException lExcptn) {
                            c = '\u0000';
                            this.errorHandler.handleError(10, this.support.getPosition(), lExcptn.getMessage());
                        }
                    }
                    c = (char)(c & 0xFF);
                    this.lexState = LexState.EXPR_END;
                    this.yaccValue = new Long(c);
                    return 310;
                }
                case '&': {
                    c = this.support.read();
                    if (c == '&') {
                        this.lexState = LexState.EXPR_BEG;
                        c = this.support.read();
                        if (c == '=') {
                            this.yaccValue = "&&";
                            return 342;
                        }
                        this.support.unread();
                        return 330;
                    }
                    if (c == '=') {
                        this.yaccValue = "&";
                        this.lexState = LexState.EXPR_BEG;
                        return 342;
                    }
                    this.support.unread();
                    if (this.isArgState() && spaceSeen && !Character.isWhitespace(c)) {
                        this.errorHandler.handleError(2, this.support.getPosition(), Messages.getString("amp_interpreted_as_argument_prefix"));
                        c = '\u015c';
                    } else {
                        c = this.lexState.isExprBeg() || this.lexState.isExprMid() ? (char)'\u015c' : '&';
                    }
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    return c;
                }
                case '|': {
                    c = this.support.read();
                    if (c == '|') {
                        this.lexState = LexState.EXPR_BEG;
                        c = this.support.read();
                        if (c == '=') {
                            this.yaccValue = "||";
                            return 342;
                        }
                        this.support.unread();
                        return 331;
                    }
                    if (c == '=') {
                        this.lexState = LexState.EXPR_BEG;
                        this.yaccValue = "|";
                        return 342;
                    }
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    this.support.unread();
                    return 124;
                }
                case '+': {
                    c = this.support.read();
                    if (this.lexState.isExprFName() || this.lexState.isExprDot()) {
                        this.lexState = LexState.EXPR_ARG;
                        if (c == '@') {
                            return 321;
                        }
                        this.support.unread();
                        return 43;
                    }
                    if (c == '=') {
                        this.lexState = LexState.EXPR_BEG;
                        this.yaccValue = "+";
                        return 342;
                    }
                    if (this.lexState.isExprBeg() || this.lexState.isExprMid() || this.isArgState() && spaceSeen && !Character.isWhitespace(c)) {
                        if (this.isArgState()) {
                            this.arg_ambiguous();
                        }
                        this.lexState = LexState.EXPR_BEG;
                        this.support.unread();
                        if (Character.isDigit(c)) {
                            c = '+';
                            return this.parseNumber(c);
                        }
                        return 321;
                    }
                    this.lexState = LexState.EXPR_BEG;
                    this.support.unread();
                    return 43;
                }
                case '-': {
                    c = this.support.read();
                    if (this.lexState.isExprFName() || this.lexState.isExprDot()) {
                        this.lexState = LexState.EXPR_ARG;
                        if (c == '@') {
                            return 322;
                        }
                        this.support.unread();
                        return 45;
                    }
                    if (c == '=') {
                        this.lexState = LexState.EXPR_BEG;
                        this.yaccValue = "-";
                        return 342;
                    }
                    if (this.lexState.isExprBeg() || this.lexState.isExprMid() || this.isArgState() && spaceSeen && !Character.isWhitespace(c)) {
                        if (this.isArgState()) {
                            this.arg_ambiguous();
                        }
                        this.lexState = LexState.EXPR_BEG;
                        this.support.unread();
                        if (Character.isDigit(c)) {
                            c = '-';
                            return this.parseNumber(c);
                        }
                        return 322;
                    }
                    this.lexState = LexState.EXPR_BEG;
                    this.support.unread();
                    return 45;
                }
                case '.': {
                    this.lexState = LexState.EXPR_BEG;
                    char c5 = this.support.read();
                    c = c5;
                    if (c5 == '.') {
                        c = this.support.read();
                        if (c == '.') {
                            return 335;
                        }
                        this.support.unread();
                        return 334;
                    }
                    this.support.unread();
                    if (!Character.isDigit(c)) {
                        this.lexState = LexState.EXPR_DOT;
                        return 46;
                    }
                    c = '.';
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.parseNumber(c);
                }
                case ')': 
                case ']': 
                case '}': {
                    this.conditionState.restart();
                    this.cmdArgumentState.restart();
                    this.lexState = LexState.EXPR_END;
                    return c;
                }
                case ':': {
                    c = this.support.read();
                    if (c == ':') {
                        if (this.lexState.isExprBeg() || this.lexState.isExprMid() || this.isArgState() && spaceSeen) {
                            this.lexState = LexState.EXPR_BEG;
                            return 341;
                        }
                        this.lexState = LexState.EXPR_DOT;
                        return 340;
                    }
                    this.support.unread();
                    if (this.lexState.isExprEnd() || Character.isWhitespace(c)) {
                        this.lexState = LexState.EXPR_BEG;
                        return 58;
                    }
                    this.lexState = LexState.EXPR_FNAME;
                    return 349;
                }
                case '/': {
                    if (this.lexState.isExprBeg() || this.lexState.isExprMid()) {
                        return this.parseRegexp('/', '/');
                    }
                    c = this.support.read();
                    if (c == '=') {
                        this.lexState = LexState.EXPR_BEG;
                        this.yaccValue = "/";
                        return 342;
                    }
                    this.support.unread();
                    if (this.isArgState() && spaceSeen && !Character.isWhitespace(c)) {
                        this.arg_ambiguous();
                        return this.parseRegexp('/', '/');
                    }
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    return 47;
                }
                case '^': {
                    c = this.support.read();
                    if (c == '=') {
                        this.lexState = LexState.EXPR_BEG;
                        this.yaccValue = "^";
                        return 342;
                    }
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    this.support.unread();
                    return 94;
                }
                case ',': 
                case ';': {
                    this.lexState = LexState.EXPR_BEG;
                    return c;
                }
                case '~': {
                    if (this.lexState.isExprFName() || this.lexState.isExprDot()) {
                        char c6 = this.support.read();
                        c = c6;
                        if (c6 != '@') {
                            this.support.unread();
                        }
                    }
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    return 126;
                }
                case '(': {
                    if (this.lexState.isExprBeg() || this.lexState.isExprMid()) {
                        c = '\u0158';
                    } else if (this.lexState.isExprArg() && spaceSeen) {
                        this.errorHandler.handleError(2, this.support.getPosition(), this.tok() + Messages.getString("interpreted_as_method_call"));
                    }
                    this.conditionState.stop();
                    this.cmdArgumentState.stop();
                    this.lexState = LexState.EXPR_BEG;
                    return c;
                }
                case '[': {
                    if (this.lexState.isExprFName() || this.lexState.isExprDot()) {
                        this.lexState = LexState.EXPR_ARG;
                        c = this.support.read();
                        if (c == ']') {
                            char c7 = this.support.read();
                            c = c7;
                            if (c7 == '=') {
                                return 337;
                            }
                            this.support.unread();
                            return 336;
                        }
                        this.support.unread();
                        return 91;
                    }
                    if (this.lexState.isExprBeg() || this.lexState.isExprMid()) {
                        c = '\u0159';
                    } else if (this.isArgState() && spaceSeen) {
                        c = '\u0159';
                    }
                    this.conditionState.stop();
                    this.cmdArgumentState.stop();
                    this.lexState = LexState.EXPR_BEG;
                    return c;
                }
                case '{': {
                    if (!this.lexState.isExprEnd() && !this.lexState.isExprArg()) {
                        c = '\u015a';
                    }
                    this.conditionState.stop();
                    this.cmdArgumentState.stop();
                    this.lexState = LexState.EXPR_BEG;
                    return c;
                }
                case '\\': {
                    c = this.support.read();
                    if (c == '\n') {
                        spaceSeen = true;
                        continue block44;
                    }
                    this.support.unread();
                    return 92;
                }
                case '%': {
                    if (this.lexState.isExprBeg() || this.lexState.isExprMid()) {
                        return this.parseQuotation();
                    }
                    c = this.support.read();
                    if (c == '=') {
                        this.yaccValue = "%";
                        return 342;
                    }
                    if (this.isArgState() && spaceSeen && !Character.isWhitespace(c)) {
                        this.support.unread();
                        return this.parseQuotation();
                    }
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    this.support.unread();
                    return 37;
                }
                case '$': {
                    this.lexState = LexState.EXPR_END;
                    this.newToken();
                    c = this.support.read();
                    switch (c) {
                        case '_': {
                            c = this.support.read();
                            if (RubyYaccLexer.isIdentifierChar(c)) {
                                this.tokenBuffer.append('$');
                                this.tokenBuffer.append('_');
                                break;
                            }
                            this.support.unread();
                            c = '_';
                        }
                        case '!': 
                        case '\"': 
                        case '$': 
                        case '*': 
                        case ',': 
                        case '.': 
                        case '/': 
                        case ':': 
                        case ';': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '?': 
                        case '@': 
                        case '\\': 
                        case '~': {
                            this.tokenBuffer.append('$');
                            this.tokenBuffer.append(c);
                            this.yaccValue = this.tok();
                            return 306;
                        }
                        case '-': {
                            this.tokenBuffer.append('$');
                            this.tokenBuffer.append(c);
                            c = this.support.read();
                            this.tokenBuffer.append(c);
                            this.yaccValue = this.tok();
                            return 306;
                        }
                        case '&': 
                        case '\'': 
                        case '+': 
                        case '`': {
                            this.yaccValue = new BackRefNode(this.support.getPosition(), c);
                            return 317;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.tokenBuffer.append('$');
                            while (Character.isDigit(c)) {
                                this.tokenBuffer.append(c);
                                c = this.support.read();
                            }
                            if (RubyYaccLexer.isIdentifierChar(c)) break block44;
                            this.support.unread();
                            this.yaccValue = new NthRefNode(this.support.getPosition(), Integer.parseInt(this.tok().substring(1)));
                            return 318;
                        }
                        default: {
                            if (!RubyYaccLexer.isIdentifierChar(c)) {
                                this.support.unread();
                                return 36;
                            }
                        }
                        case '0': {
                            this.tokenBuffer.append('$');
                            break;
                        }
                    }
                    break block44;
                }
                case '@': {
                    c = this.support.read();
                    this.newToken();
                    this.tokenBuffer.append('@');
                    if (c == '@') {
                        this.tokenBuffer.append('@');
                        c = this.support.read();
                    }
                    if (Character.isDigit(c)) {
                        this.errorHandler.handleError(11, this.support.getPosition(), Messages.getString("invalid_instance_variable_name", String.valueOf(c)));
                    }
                    if (RubyYaccLexer.isIdentifierChar(c)) break block44;
                    this.support.unread();
                    return 64;
                }
                default: {
                    if (!RubyYaccLexer.isIdentifierChar(c) || Character.isDigit(c)) {
                        this.errorHandler.handleError(11, this.support.getPosition(), Messages.getString("invalid_char_in_expression", String.valueOf(c)));
                        continue block44;
                    }
                    this.newToken();
                    break block44;
                }
            }
            break;
        }
        while (RubyYaccLexer.isIdentifierChar(c)) {
            this.tokenBuffer.append(c);
            c = this.support.read();
        }
        if ((c == '!' || c == '?') && RubyYaccLexer.isIdentifierChar(this.tok().charAt(0)) && !this.support.isNext('=')) {
            this.tokenBuffer.append(c);
        } else {
            this.support.unread();
        }
        int result = 0;
        switch (this.tok().charAt(0)) {
            case '$': {
                this.lexState = LexState.EXPR_END;
                result = 306;
                break;
            }
            case '@': {
                this.lexState = LexState.EXPR_END;
                if (this.tok().charAt(1) == '@') {
                    result = 309;
                    break;
                }
                result = 307;
                break;
            }
            default: {
                Keyword keyword;
                if (!this.lexState.isExprDot() && (keyword = RubyYaccLexer.getKeyword(this.tok(), this.toklen())) != null) {
                    LexState state = this.lexState;
                    this.lexState = keyword.state;
                    if (state.isExprFName()) {
                        this.yaccValue = keyword.name;
                    }
                    if (keyword.id0 == 280) {
                        if (this.conditionState.isInState()) {
                            return 281;
                        }
                        if (this.cmdArgumentState.isInState()) {
                            return 282;
                        }
                        return 280;
                    }
                    if (state.isExprBeg()) {
                        return keyword.id0;
                    }
                    if (keyword.id0 != keyword.id1) {
                        this.lexState = LexState.EXPR_BEG;
                    }
                    return keyword.id1;
                }
                if (this.toklast() == '!' || this.toklast() == '?') {
                    result = 305;
                } else {
                    if (this.lexState.isExprFName()) {
                        c = this.support.read();
                        if (!(c != '=' || this.support.isNext('~') || this.support.isNext('>') || this.support.isNext('=') && this.support.getCharAt(1) != '>')) {
                            result = 304;
                            this.tokenBuffer.append(c);
                        } else {
                            this.support.unread();
                        }
                    }
                    result = result == 0 && Character.isUpperCase(this.tok().charAt(0)) ? 308 : 304;
                }
                this.lexState = this.lexState.isExprBeg() || this.lexState.isExprDot() || this.lexState.isExprArg() ? LexState.EXPR_ARG : LexState.EXPR_END;
            }
        }
        this.yaccValue = this.tok();
        return result;
    }

    private int parseQuotation() {
        char type = this.support.read();
        int openQuote = type;
        if (Character.isLetterOrDigit(type)) {
            openQuote = this.support.read();
        } else {
            type = 'Q';
        }
        if (type == '\u0000' || openQuote == 0) {
            this.errorHandler.handleError(11, this.support.getPosition(), Messages.getString("unterminated_quoted_string"));
            return 0;
        }
        int closeQuote = openQuote;
        if (openQuote == 40) {
            closeQuote = 41;
        } else if (openQuote == 91) {
            closeQuote = 93;
        } else if (openQuote == 123) {
            closeQuote = 125;
        } else if (openQuote == 60) {
            closeQuote = 62;
        } else {
            openQuote = 0;
        }
        switch (type) {
            case 'Q': {
                return this.parseString('\"', (char)closeQuote, (char)openQuote);
            }
            case 'q': {
                return this.parseSingleQuotedString((char)closeQuote, (char)openQuote);
            }
            case 'w': {
                return this.parseQuotedWords((char)closeQuote, (char)openQuote);
            }
            case 'x': {
                return this.parseString('`', (char)closeQuote, (char)openQuote);
            }
            case 'r': {
                return this.parseRegexp((char)closeQuote, (char)openQuote);
            }
        }
        this.errorHandler.handleError(10, this.support.getPosition(), Messages.getString("unknown_quotation_type", String.valueOf(type)));
        return 0;
    }

    private int parseNumber(char c) {
        this.lexState = LexState.EXPR_END;
        StringBuffer number = new StringBuffer();
        if (c == '-') {
            number.append(c);
            c = this.support.read();
        } else if (c == '+') {
            c = this.support.read();
        }
        char nondigit = '\u0000';
        if (c == '0') {
            int startLen = number.length();
            c = this.support.read();
            switch (c) {
                case 'X': 
                case 'x': {
                    c = this.support.read();
                    if (RubyYaccLexer.isHexDigit(c)) {
                        while (true) {
                            if (c == '_') {
                                if (nondigit != '\u0000') break;
                                nondigit = c;
                            } else {
                                if (!RubyYaccLexer.isHexDigit(c)) break;
                                nondigit = '\u0000';
                                number.append(c);
                            }
                            c = this.support.read();
                        }
                    }
                    this.support.unread();
                    if (number.length() == startLen) {
                        this.errorHandler.handleError(10, Messages.getString("number_without_hex_digits"));
                    } else if (nondigit != '\u0000') {
                        this.errorHandler.handleError(10, Messages.getString("trailing_uc"));
                    }
                    this.yaccValue = RubyYaccLexer.getInteger(number.toString(), 16);
                    return 310;
                }
                case 'B': 
                case 'b': {
                    c = this.support.read();
                    if (c == '0' || c == '1') {
                        while (true) {
                            if (c == '_') {
                                if (nondigit != '\u0000') break;
                                nondigit = c;
                            } else {
                                if (c != '0' && c != '1') break;
                                nondigit = '\u0000';
                                number.append(c);
                            }
                            c = this.support.read();
                        }
                    }
                    this.support.unread();
                    if (number.length() == startLen) {
                        this.errorHandler.handleError(10, Messages.getString("number_without_bin_digits"));
                    } else if (nondigit != '\u0000') {
                        this.errorHandler.handleError(10, Messages.getString("trailing_uc"));
                    }
                    this.yaccValue = RubyYaccLexer.getInteger(number.toString(), 2);
                    return 310;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '_': {
                    while (true) {
                        if (c == '_') {
                            if (nondigit != '\u0000') break;
                            nondigit = c;
                        } else {
                            if (c < '0' || c > '7') break;
                            nondigit = '\u0000';
                            number.append(c);
                        }
                        c = this.support.read();
                    }
                    if (number.length() > startLen) {
                        this.support.unread();
                        if (nondigit != '\u0000') {
                            this.errorHandler.handleError(10, Messages.getString("trailing_uc"));
                        }
                        this.yaccValue = RubyYaccLexer.getInteger(number.toString(), 8);
                        return 310;
                    }
                }
                case '8': 
                case '9': {
                    this.errorHandler.handleError(10, Messages.getString("illegal_octal_digit"));
                    break;
                }
                case '.': 
                case 'E': 
                case 'e': {
                    number.append('0');
                    break;
                }
                default: {
                    this.support.unread();
                    this.yaccValue = new Long(0L);
                    return 310;
                }
            }
        }
        boolean seen_point = false;
        boolean seen_e = false;
        while (true) {
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    nondigit = '\u0000';
                    number.append(c);
                    break;
                }
                case '.': {
                    if (nondigit != '\u0000') {
                        this.support.unread();
                        this.errorHandler.handleError(10, this.support.getPosition(), Messages.getString("trailing_uc"));
                        break;
                    }
                    if (seen_point || seen_e) {
                        this.support.unread();
                        return this.getNumberToken(number.toString(), true, nondigit);
                    }
                    char oldC = c;
                    c = this.support.read();
                    if (!Character.isDigit(c)) {
                        this.support.unread();
                        this.support.unread();
                        if (this.support.getLastRead() == '_') break;
                        this.yaccValue = RubyYaccLexer.getInteger(number.toString(), 10);
                        return 310;
                    }
                    number.append('.');
                    number.append(c);
                    seen_point = true;
                    nondigit = '\u0000';
                    break;
                }
                case 'E': 
                case 'e': {
                    if (nondigit != '\u0000') {
                        this.support.unread();
                        this.errorHandler.handleError(10, this.support.getPosition(), Messages.getString("trailing_uc"));
                        return 0;
                    }
                    if (seen_e) {
                        this.support.unread();
                        return this.getNumberToken(number.toString(), true, nondigit);
                    }
                    number.append(c);
                    seen_e = true;
                    nondigit = c;
                    c = this.support.read();
                    if (c == '-' || c == '+') {
                        number.append(c);
                        nondigit = c;
                        break;
                    }
                    this.support.unread();
                    break;
                }
                case '_': {
                    if (nondigit != '\u0000') {
                        this.errorHandler.handleError(10, this.support.getPosition(), Messages.getString("trailing_uc"));
                        return 0;
                    }
                    nondigit = c;
                    break;
                }
                default: {
                    this.support.unread();
                    return this.getNumberToken(number.toString(), seen_e || seen_point, nondigit);
                }
            }
            c = this.support.read();
        }
    }

    private int getNumberToken(String number, boolean isFloat, char nondigit) {
        if (nondigit != '\u0000') {
            this.errorHandler.handleError(10, Messages.getString("trailing_uc", String.valueOf(nondigit)));
            return 0;
        }
        if (isFloat) {
            Double d = new Double(0.0);
            try {
                d = Double.valueOf(number);
            }
            catch (NumberFormatException e) {
                this.errorHandler.handleError(1, this.support.getPosition(), Messages.getString("float_out_of_range", number));
            }
            this.yaccValue = d;
            return 311;
        }
        this.yaccValue = RubyYaccLexer.getInteger(number, 10);
        return 310;
    }

    /*
     * Unable to fully structure code
     */
    private boolean parseExpressionString(IListNode list, char closeQuote, StringToken token) throws EOFException {
        c = this.support.read();
        switch (c) {
            case '$': 
            case '@': 
            case '{': {
                break;
            }
            default: {
                token.append('#');
                this.support.unread();
                return false;
            }
        }
        if (token.getLength() > 0) {
            list.add(new StrNode(token.getPosition(), token.getToken()));
        }
        token.newToken(this.support.getPosition());
        brace = '\u0000';
        block3 : switch (c) {
            case '$': {
                token.append('$');
                c = this.support.read();
                if (c == '\u0000') {
                    throw new EOFException();
                }
                switch (c) {
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        while (Character.isDigit(c)) {
                            token.append(c);
                            c = this.support.read();
                        }
                        this.support.unread();
                        list.add(new NthRefNode(token.getPosition(), Integer.parseInt(token.getToken().substring(1))));
                        token.newToken(this.support.getPosition());
                        return true;
                    }
                    case '&': 
                    case '+': {
                        list.add(new BackRefNode(token.getPosition(), c));
                        token.newToken(this.support.getPosition());
                        return true;
                    }
                    case '!': 
                    case '$': 
                    case '*': 
                    case ',': 
                    case '.': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '?': 
                    case '@': 
                    case '\\': 
                    case '_': 
                    case '~': {
                        token.append(c);
                        list.add(new GlobalVarNode(token.getPosition(), token.getToken()));
                        token.newToken(this.support.getPosition());
                        return true;
                    }
                }
                if (c == closeQuote) {
                    list.add(new StrNode(token.getPosition(), "#$"));
                    this.support.unread();
                    token.newToken(this.support.getPosition());
                    return true;
                }
                switch (c) {
                    case '\"': 
                    case '/': {
                        token.append(c);
                        list.add(new GlobalVarNode(token.getPosition(), token.getToken()));
                        token.newToken(this.support.getPosition());
                        return true;
                    }
                    case '\'': 
                    case '`': {
                        list.add(new BackRefNode(token.getPosition(), c));
                        token.newToken(this.support.getPosition());
                        return true;
                    }
                }
                if (RubyYaccLexer.isIdentifierChar(c)) ** GOTO lbl66
                this.errorHandler.handleError(10, token.getPosition(), Messages.getString("bad_global_variable"));
                token.newToken(this.support.getPosition());
                return true;
lbl-1000:
                // 1 sources

                {
                    token.append(c);
                    c = this.support.read();
lbl66:
                    // 2 sources

                    ** while (RubyYaccLexer.isIdentifierChar((char)c))
                }
lbl67:
                // 1 sources

                this.support.unread();
                list.add(new GlobalVarNode(token.getPosition(), token.getToken()));
                token.newToken(this.support.getPosition());
                return true;
            }
            case '@': {
                token.append(c);
                c = this.support.read();
                if (c == '@') {
                    token.append(c);
                    c = this.support.read();
                }
                while (RubyYaccLexer.isIdentifierChar(c)) {
                    token.append(c);
                    c = this.support.read();
                }
                this.support.unread();
                if (token.getToken().startsWith("@@")) {
                    list.add(new ClassVarNode(token.getPosition(), token.getToken()));
                } else {
                    list.add(new InstVarNode(token.getPosition(), token.getToken()));
                }
                token.newToken(this.support.getPosition());
                return true;
            }
            case '{': {
                if (c == '{') {
                    brace = '}';
                }
                nest = 0;
                block27: while (true) {
                    c = this.support.read();
                    switch (c) {
                        case '\u0000': {
                            if (nest > 0) {
                                this.errorHandler.handleError(10, token.getPosition(), Messages.getString("bad_substitution"));
                                token.newToken(this.support.getPosition());
                                return true;
                            }
                            throw new EOFException();
                        }
                        case '}': {
                            if (c == brace) {
                                if (nest == 0) break;
                                --nest;
                            }
                            token.append(c);
                            continue block27;
                        }
                        case '\\': {
                            c = this.support.read();
                            if (c == '\u0000') {
                                throw new EOFException();
                            }
                            if (c == closeQuote) {
                                token.append(c);
                                continue block27;
                            }
                            token.append('\\');
                            token.append(c);
                            continue block27;
                        }
                        case '{': {
                            if (brace != '\u0000') {
                                ++nest;
                            }
                        }
                        case '\"': 
                        case '/': 
                        case '`': {
                            if (c == closeQuote) {
                                this.support.unread();
                                list.add(new StrNode(token.getPosition(), "#"));
                                this.errorHandler.handleError(2, this.support.getPosition(), Messages.getString("bad_substitution"));
                                list.add(new StrNode(token.getPosition(), token.getToken()));
                                token.newToken(this.support.getPosition());
                                return true;
                            }
                        }
                        default: {
                            token.append(c);
                            break;
                        }
                    }
                    if (c == brace) break block3;
                }
            }
        }
        list.add(new EvStrNode(token.getPosition(), token.getToken()));
        token.newToken(this.support.getPosition());
        return true;
    }

    private final boolean isArgState() {
        return this.lexState.isExprArg();
    }

    private static final Keyword getKeyword(String w, int len) {
        return Keyword.getKeyword(w, len);
    }

    private static final Object getInteger(String value, int radix) {
        try {
            return Long.valueOf(value, radix);
        }
        catch (NumberFormatException e) {
            return new BigInteger(value, radix);
        }
    }

    private static final boolean isIdentifierChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    private static final boolean isHexDigit(char c) {
        return Character.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public void setErrorHandler(IErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setSource(ILexerSource source) {
        this.support = new RubyLexerSupport(source);
    }

    public void setState(ILexerState state) {
        this.lexState = (LexState)state;
    }

    public StackState getCmdArgumentState() {
        return this.cmdArgumentState;
    }

    public StackState getConditionState() {
        return this.conditionState;
    }
}

