/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import java.io.File;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.runtime.load.Library;

public class RbConfig
implements Library {
    private RubyHash configHash;

    public void load(Ruby runtime) {
        RubyModule configModule = runtime.defineModule("Config");
        this.configHash = RubyHash.newHash(runtime);
        configModule.defineConstant("CONFIG", this.configHash);
        String[] versionParts = "1.6.7".split("\\.");
        this.setConfig("MAJOR", versionParts[0]);
        this.setConfig("MINOR", versionParts[1]);
        this.setConfig("TEENY", versionParts[2]);
        this.setConfig("bindir", new File(System.getProperty("jruby.home") + File.separator + "bin").getAbsolutePath());
        this.setConfig("RUBY_INSTALL_NAME", System.getProperty("jruby.script"));
    }

    private void setConfig(String key, String value) {
        Ruby runtime = this.configHash.getRuntime();
        this.configHash.aset(RubyString.newString(runtime, key), RubyString.newString(runtime, value));
    }
}

