/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.ablaf.ast.INode;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.runtime.DynamicVariableSet;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.Iter;
import org.jruby.runtime.Scope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Asserts;
import org.jruby.util.collections.StackElement;

public class Block
implements StackElement {
    private INode var;
    private ICallable method;
    private IRubyObject self;
    private Frame frame;
    private Scope scope;
    private RubyModule klass;
    private Iter iter;
    private DynamicVariableSet dynamicVariables;
    private Block next;

    public static Block createBlock(INode var, ICallable method, IRubyObject self) {
        Ruby ruby = self.getRuntime();
        return new Block(var, method, self, ruby.getCurrentFrame(), ruby.currentScope(), ruby.getRubyClass(), ruby.getCurrentIter(), ruby.getDynamicVars());
    }

    private Block(INode var, ICallable method, IRubyObject self, Frame frame, Scope scope, RubyModule klass, Iter iter, DynamicVariableSet dynamicVars) {
        this.var = var;
        this.method = method;
        this.self = self;
        this.frame = frame;
        this.scope = scope;
        this.klass = klass;
        this.iter = iter;
        this.dynamicVariables = dynamicVars;
    }

    public IRubyObject call(IRubyObject[] args) {
        return this.call(args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(IRubyObject[] args, IRubyObject replacementSelf) {
        IRubyObject iRubyObject;
        Ruby ruby = this.self.getRuntime();
        Block oldBlock = ruby.getBlockStack().getCurrent();
        Block newBlock = this.cloneBlock();
        if (replacementSelf != null) {
            newBlock.self = replacementSelf;
        }
        ruby.getBlockStack().setCurrent(newBlock);
        ruby.getIterStack().push(Iter.ITER_CUR);
        ruby.getCurrentFrame().setIter(Iter.ITER_CUR);
        try {
            iRubyObject = ruby.yield(args != null ? RubyArray.newArray(ruby, args) : null, null, null, true);
            Object var8_7 = null;
            ruby.getIterStack().pop();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ruby.getIterStack().pop();
            ruby.getBlockStack().setCurrent(oldBlock);
            throw throwable;
        }
        ruby.getBlockStack().setCurrent(oldBlock);
        return iRubyObject;
    }

    public Block cloneBlock() {
        Block newBlock = new Block(this.var, this.method, this.self, this.frame, this.scope, this.klass, this.iter, new DynamicVariableSet(this.dynamicVariables));
        if (this.getNext() != null) {
            newBlock.setNext((Block)this.getNext());
        }
        return newBlock;
    }

    public StackElement getNext() {
        return this.next;
    }

    public void setNext(StackElement newNext) {
        Asserts.isTrue(this != newNext);
        this.next = (Block)newNext;
    }

    public DynamicVariableSet getDynamicVariables() {
        return this.dynamicVariables;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Iter getIter() {
        return this.iter;
    }

    public void setIter(Iter iter) {
        this.iter = iter;
    }

    public RubyModule getKlass() {
        return this.klass;
    }

    public ICallable getMethod() {
        return this.method;
    }

    public Scope getScope() {
        return this.scope;
    }

    public IRubyObject getSelf() {
        return this.self;
    }

    public INode getVar() {
        return this.var;
    }
}

