/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.ArrayList;
import java.util.List;
import org.jruby.runtime.builtin.IRubyObject;

public final class DynamicVariableSet {
    private static final int INITIAL_SIZE = 8;
    private String[] names;
    private IRubyObject[] values;
    private int size = 0;

    public DynamicVariableSet() {
        this.names = new String[8];
        this.values = new IRubyObject[8];
    }

    public DynamicVariableSet(DynamicVariableSet original) {
        this.names = new String[original.names.length];
        System.arraycopy(original.names, 0, this.names, 0, original.names.length);
        this.values = new IRubyObject[original.values.length];
        System.arraycopy(original.values, 0, this.values, 0, original.values.length);
        this.size = original.size;
    }

    public void set(String name, IRubyObject value) {
        int index = this.indexOf(name);
        if (index == -1) {
            this.expandSize();
            this.names[this.size - 1] = name;
            this.values[this.size - 1] = value;
        } else {
            this.values[index] = value;
        }
    }

    public IRubyObject get(String name) {
        int index = this.indexOf(name);
        if (index == -1) {
            return null;
        }
        return this.values[index];
    }

    public List names() {
        ArrayList<String> result = new ArrayList<String>(this.size);
        int i = 0;
        while (i < this.size) {
            result.add(this.names[i]);
            ++i;
        }
        return result;
    }

    private int indexOf(String name) {
        int i = 0;
        while (i < this.size) {
            if (name.equals(this.names[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void expandSize() {
        ++this.size;
        if (this.size == this.names.length) {
            String[] oldNames = this.names;
            this.names = new String[oldNames.length * 2];
            System.arraycopy(oldNames, 0, this.names, 0, oldNames.length);
            IRubyObject[] oldValues = this.values;
            this.values = new IRubyObject[oldValues.length * 2];
            System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
        }
    }
}

