/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jruby.RubyModule;
import org.jruby.runtime.builtin.IRubyObject;

public class ObjectSpace {
    private HashMap references = new HashMap();
    private ReferenceQueue deadReferences = new ReferenceQueue();

    public void add(IRubyObject object) {
        this.cleanup();
        this.references.put(new WeakReference<IRubyObject>(object, this.deadReferences), null);
    }

    public Iterator iterator(RubyModule rubyClass) {
        return new ObjectSpaceIterator(rubyClass);
    }

    /*
     * WARNING - void declaration
     */
    private void cleanup() {
        Reference reference;
        while ((reference = this.deadReferences.poll()) != null) {
            void var1_1;
            this.references.remove(var1_1);
        }
    }

    private class ObjectSpaceIterator
    implements Iterator {
        private final RubyModule rubyClass;
        private final Iterator iterator;
        private IRubyObject next;

        public ObjectSpaceIterator(RubyModule rubyClass) {
            this.rubyClass = rubyClass;
            this.iterator = new ArrayList(ObjectSpace.this.references.keySet()).iterator();
            this.prefetch();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IRubyObject result = this.next;
            this.prefetch();
            return result;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void prefetch() {
            do {
                if (!this.iterator.hasNext()) {
                    this.next = null;
                    return;
                }
                WeakReference ref = (WeakReference)this.iterator.next();
                this.next = (IRubyObject)ref.get();
            } while (this.next == null || !this.next.isKindOf(this.rubyClass));
        }
    }
}

