/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.List;
import org.ablaf.ast.INode;
import org.ablaf.common.ISourcePosition;
import org.ablaf.internal.lexer.DefaultLexerPosition;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.ThreadClass;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.ZeroArgNode;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.evaluator.EvaluateVisitor;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.NextJump;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.RedoJump;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockStack;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicVariableSet;
import org.jruby.runtime.Frame;
import org.jruby.runtime.FrameStack;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.Iter;
import org.jruby.runtime.Namespace;
import org.jruby.runtime.Scope;
import org.jruby.runtime.ScopeStack;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RubyStack;
import org.jruby.util.collections.CollectionFactory;
import org.jruby.util.collections.IStack;

public class ThreadContext {
    private final Ruby ruby;
    private BlockStack blockStack;
    private RubyStack dynamicVarsStack;
    private ThreadClass currentThread;
    private ScopeStack scopeStack;
    private FrameStack frameStack;
    private IStack iterStack;
    private ISourcePosition sourcePosition = DefaultLexerPosition.getInstance("", 0);

    public ThreadContext(Ruby ruby) {
        this.ruby = ruby;
        this.blockStack = new BlockStack();
        this.dynamicVarsStack = new RubyStack();
        this.scopeStack = new ScopeStack(ruby);
        this.frameStack = new FrameStack(ruby);
        this.iterStack = CollectionFactory.getInstance().newStack();
        this.pushDynamicVars();
    }

    public BlockStack getBlockStack() {
        return this.blockStack;
    }

    public DynamicVariableSet getCurrentDynamicVars() {
        return (DynamicVariableSet)this.dynamicVarsStack.peek();
    }

    public void pushDynamicVars() {
        this.dynamicVarsStack.push(new DynamicVariableSet());
    }

    public void popDynamicVars() {
        this.dynamicVarsStack.pop();
    }

    public List getDynamicNames() {
        return this.getCurrentDynamicVars().names();
    }

    public ThreadClass getCurrentThread() {
        return this.currentThread;
    }

    public void setCurrentThread(ThreadClass thread) {
        this.currentThread = thread;
    }

    public IRubyObject eval(INode node) {
        return EvaluateVisitor.createVisitor(this.ruby.getTopSelf()).eval(node);
    }

    public ScopeStack getScopeStack() {
        return this.scopeStack;
    }

    public FrameStack getFrameStack() {
        return this.frameStack;
    }

    public IStack getIterStack() {
        return this.iterStack;
    }

    public Frame getCurrentFrame() {
        return (Frame)this.getFrameStack().peek();
    }

    public Iter getCurrentIter() {
        return (Iter)this.getIterStack().peek();
    }

    public String getSourceFile() {
        return this.getPosition().getFile();
    }

    public int getSourceLine() {
        return this.getPosition().getLine();
    }

    public ISourcePosition getPosition() {
        return this.sourcePosition;
    }

    public void setPosition(String file, int line) {
        this.setPosition(DefaultLexerPosition.getInstance(file, line));
    }

    public void setPosition(ISourcePosition position) {
        this.sourcePosition = position;
    }

    public IRubyObject getBackref() {
        if (this.getScopeStack().hasLocalVariables()) {
            return this.getScopeStack().getValue(1);
        }
        return this.ruby.getNil();
    }

    public RubyModule getCBase() {
        return this.getCurrentFrame().getNamespace().getNamespaceModule();
    }

    public Visibility getCurrentVisibility() {
        return this.getScopeStack().current().getVisibility();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject callSuper(IRubyObject[] args) {
        IRubyObject iRubyObject;
        if (this.getCurrentFrame().getLastClass() == null) {
            throw new NameError(this.ruby, "superclass method '" + this.getCurrentFrame().getLastFunc() + "' must be enabled by enableSuper().");
        }
        this.getIterStack().push(this.getCurrentIter().isNot() ? Iter.ITER_NOT : Iter.ITER_PRE);
        try {
            RubyClass superClass = this.getCurrentFrame().getLastClass().getSuperClass();
            iRubyObject = superClass.call(this.getCurrentFrame().getSelf(), this.getCurrentFrame().getLastFunc(), args, CallType.SUPER);
            Object var5_4 = null;
            this.getIterStack().pop();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.getIterStack().pop();
            throw throwable;
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(IRubyObject value, IRubyObject self, RubyModule klass, boolean checkArguments) {
        ICallable method;
        if (!this.ruby.isBlockGiven()) {
            throw new RaiseException(this.ruby, this.ruby.getExceptions().getLocalJumpError(), "yield called out of block");
        }
        this.pushDynamicVars();
        Block currentBlock = this.getBlockStack().getCurrent();
        this.getFrameStack().push(currentBlock.getFrame());
        Namespace oldNamespace = this.ruby.getNamespace();
        this.ruby.setNamespace(this.getCurrentFrame().getNamespace());
        Scope oldScope = (Scope)this.getScopeStack().getTop();
        this.getScopeStack().setTop(currentBlock.getScope());
        this.getBlockStack().pop();
        this.dynamicVarsStack.push(currentBlock.getDynamicVariables());
        this.ruby.pushClass(klass != null ? klass : currentBlock.getKlass());
        if (klass == null) {
            self = currentBlock.getSelf();
        }
        if (value == null) {
            value = RubyArray.newArray(this.ruby, 0L);
        }
        if ((method = currentBlock.getMethod()) == null) {
            return this.ruby.getNil();
        }
        this.getIterStack().push(currentBlock.getIter());
        IRubyObject[] args = this.prepareArguments(value, self, currentBlock.getVar(), checkArguments);
        try {
            while (true) {
                try {
                    IRubyObject iRubyObject = method.call(this.ruby, self, null, args, false);
                    return iRubyObject;
                }
                catch (RedoJump rExcptn) {
                    try {
                        continue;
                    }
                    catch (NextJump nExcptn) {
                        IRubyObject iRubyObject = this.ruby.getNil();
                        return iRubyObject;
                    }
                }
                break;
            }
        }
        finally {
            this.getIterStack().pop();
            this.ruby.popClass();
            this.dynamicVarsStack.pop();
            this.getBlockStack().setCurrent(currentBlock);
            this.getFrameStack().pop();
            this.ruby.setNamespace(oldNamespace);
            this.getScopeStack().setTop(oldScope);
            this.dynamicVarsStack.pop();
        }
    }

    private IRubyObject[] prepareArguments(IRubyObject value, IRubyObject self, INode blockVariableNode, boolean checkArguments) {
        value = this.prepareBlockVariable(value, self, blockVariableNode, checkArguments);
        if (blockVariableNode == null && checkArguments && value instanceof RubyArray && ((RubyArray)value).getLength() == 1) {
            value = ((RubyArray)value).first();
        }
        return this.arrayify(value);
    }

    private IRubyObject[] arrayify(IRubyObject value) {
        if (value instanceof RubyArray) {
            return ((RubyArray)value).toJavaArray();
        }
        return new IRubyObject[]{value};
    }

    private IRubyObject prepareBlockVariable(IRubyObject value, IRubyObject self, INode blockVariableNode, boolean checkArguments) {
        if (blockVariableNode == null) {
            return value;
        }
        if (checkArguments && value instanceof RubyArray) {
            RubyArray arrayValue = (RubyArray)value;
            if (blockVariableNode instanceof ZeroArgNode && arrayValue.getLength() != 0) {
                throw new ArgumentError(this.ruby, arrayValue.getLength(), 0);
            }
            if (!(blockVariableNode instanceof MultipleAsgnNode) && arrayValue.getLength() == 1) {
                value = arrayValue.first();
            }
        }
        new AssignmentVisitor(this.ruby, self).assign(blockVariableNode, value, checkArguments);
        return value;
    }

    public void pollThreadEvents() {
        this.getCurrentThread().pollThreadEvents();
    }
}

