/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.definitions;

import org.jruby.RubyObject;
import org.jruby.runtime.IStaticCallable;
import org.jruby.runtime.StaticCallback;

public class SingletonMethodContext {
    private final IStaticCallable callable;
    private final RubyObject singleton;

    public SingletonMethodContext(RubyObject singleton, IStaticCallable callable) {
        this.callable = callable;
        this.singleton = singleton;
    }

    public void create(String name, int index, int arity) {
        this.singleton.defineSingletonMethod(name, StaticCallback.create(this.callable, index, arity));
    }

    public void createOptional(String name, int index) {
        this.singleton.defineSingletonMethod(name, StaticCallback.createOptional(this.callable, index));
    }

    public void createOptional(String name, int index, int required) {
        this.singleton.defineSingletonMethod(name, StaticCallback.createOptional(this.callable, index, required));
    }

    public void undefineMethod(String name) {
        this.singleton.getSingletonClass().undefineMethod(name);
    }
}

