/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.regexp;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jruby.Ruby;
import org.jruby.RubyMatchData;
import org.jruby.exceptions.RegexpError;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.regexp.IRegexpAdapter;

public class ORORegexpAdapter
extends IRegexpAdapter {
    private Pattern pattern;
    private int cflags = 0;
    private int eflags = 0;
    private boolean extended;

    public void compile(Ruby ruby, String pattern) throws RegexpError {
        if (this.extended) {
            pattern = this.unextend(pattern);
        }
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            this.pattern = compiler.compile(pattern, this.cflags);
        }
        catch (MalformedPatternException e) {
            throw new RegexpError(ruby, e.getMessage());
        }
    }

    public void setCasefold(boolean set) {
        this.cflags = set ? (this.cflags |= 1) : (this.cflags &= 0xFFFFFFFE);
    }

    public boolean getCasefold() {
        return (this.cflags & 1) > 0;
    }

    public void setExtended(boolean set) {
        this.extended = set;
    }

    public void setMultiline(boolean set) {
        this.cflags = set ? (this.cflags |= 8) : (this.cflags &= 0xFFFFFFF7);
    }

    public IRubyObject search(Ruby ruby, String target, int startPos) {
        PatternMatcherInput pmi = new PatternMatcherInput(target);
        pmi.setCurrentOffset(startPos);
        Perl5Matcher matcher = new Perl5Matcher();
        boolean result = matcher.contains(pmi, this.pattern);
        if (result) {
            MatchResult match = matcher.getMatch();
            int count = match.groups();
            int[] begin = new int[count];
            int[] end = new int[count];
            int i = 0;
            while (i < count) {
                begin[i] = match.beginOffset(i);
                end[i] = match.endOffset(i);
                ++i;
            }
            return new RubyMatchData(ruby, target, begin, end);
        }
        return ruby.getNil();
    }
}

