/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Asserts;

public class Pack {
    private static final String sSp10 = "          ";
    private static final String sNil10 = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
    private static final String sNatStr = "sSiIlL";
    private static final String sTooFew = "too few arguments";
    private static final char[] hex_table = "0123456789ABCDEF".toCharArray();
    private static final char[] uu_table = "`!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_".toCharArray();
    private static final char[] b64_table = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final char[] sHexDigits = "0123456789abcdef0123456789ABCDEFx".toCharArray();

    private static StringBuffer encodes(Ruby ruby, StringBuffer io2Append, String i2Encode, int iLength, char iType) {
        char lNextChar;
        char lCurChar;
        char lPadding;
        iLength = iLength < i2Encode.length() ? iLength : i2Encode.length();
        io2Append.ensureCapacity(iLength * 4 / 3 + 6);
        int i = 0;
        char[] lTranslationTable = iType == 'u' ? uu_table : b64_table;
        char[] l2Encode = i2Encode.toCharArray();
        if (iType == 'u') {
            if (iLength >= lTranslationTable.length) {
                throw new ArgumentError(ruby, "" + iLength + " is not a correct value for the number of bytes per line in a u directive.  Correct values range from 0 to " + lTranslationTable.length);
            }
            io2Append.append(lTranslationTable[iLength]);
            lPadding = '`';
        } else {
            lPadding = '=';
        }
        while (iLength >= 3) {
            lCurChar = l2Encode[i++];
            lNextChar = l2Encode[i++];
            char lNextNextChar = l2Encode[i++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | lNextChar >>> 4 & 0xF)]);
            io2Append.append(lTranslationTable[0x3F & (lNextChar << 2 & 0x3C | lNextNextChar >>> 6 & 3)]);
            io2Append.append(lTranslationTable[0x3F & lNextNextChar]);
            iLength -= 3;
        }
        if (iLength == 2) {
            lCurChar = l2Encode[i++];
            lNextChar = l2Encode[i++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | lNextChar >> 4 & 0xF)]);
            io2Append.append(lTranslationTable[0x3F & (lNextChar << 2 & 0x3C | 0)]);
            io2Append.append(lPadding);
        } else if (iLength == 1) {
            lCurChar = l2Encode[i++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | 0)]);
            io2Append.append(lPadding);
            io2Append.append(lPadding);
        }
        io2Append.append('\n');
        return io2Append;
    }

    private static StringBuffer qpencode(StringBuffer io2Append, String i2Encode, int iLength) {
        io2Append.ensureCapacity(1024);
        int lCurLineLength = 0;
        int lPrevChar = -1;
        char[] l2Encode = i2Encode.toCharArray();
        try {
            int i = 0;
            while (true) {
                int lCurChar;
                if ((lCurChar = l2Encode[i]) > 126 || lCurChar < 32 && lCurChar != 10 && lCurChar != 9 || lCurChar == 61) {
                    io2Append.append('=');
                    io2Append.append(hex_table[lCurChar >> 4]);
                    io2Append.append(hex_table[lCurChar & 0xF]);
                    lCurLineLength += 3;
                    lPrevChar = -1;
                } else if (lCurChar == 10) {
                    if (lPrevChar == 32 || lPrevChar == 9) {
                        io2Append.append('=');
                        io2Append.append((char)lCurChar);
                    }
                    io2Append.append((char)lCurChar);
                    lCurLineLength = 0;
                    lPrevChar = lCurChar;
                } else {
                    io2Append.append((char)lCurChar);
                    ++lCurLineLength;
                    lPrevChar = lCurChar;
                }
                if (lCurLineLength > iLength) {
                    io2Append.append('=');
                    io2Append.append('\n');
                    lCurLineLength = 0;
                    lPrevChar = 10;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (lCurLineLength > 0) {
                io2Append.append('=');
                io2Append.append('\n');
            }
            return io2Append;
        }
    }

    private static String convert2String(IRubyObject l2Conv) {
        Ruby ruby = l2Conv.getRuntime();
        if (l2Conv.getMetaClass() != ruby.getClasses().getStringClass()) {
            l2Conv = l2Conv.convertToType("String", "to_s", true);
        }
        return ((RubyString)l2Conv).getValue();
    }

    public static RubyArray unpack(String value, RubyString iFmt) {
        Ruby ruby = iFmt.getRuntime();
        char[] lFmt = iFmt.getValue().toCharArray();
        int lFmtLength = lFmt.length;
        RubyArray lResult = RubyArray.newArray(ruby);
        int lValueLength = value.length();
        int lCurValueIdx = 0;
        int i = 0;
        block21: while (i < lFmtLength) {
            char lNext;
            int lLength = 0;
            char lType = lFmt[i++];
            char c = lNext = i < lFmtLength ? lFmt[i] : (char)'\u0000';
            if (lNext == '_' || lNext == '!') {
                if (sNatStr.indexOf(lType) != -1) {
                    lNext = ++i < lFmtLength ? lFmt[i] : (char)'\u0000';
                } else {
                    throw new ArgumentError(ruby, "'" + lNext + "' allowed only after types " + sNatStr);
                }
            }
            if (i > lFmtLength) {
                lLength = 1;
            } else if (lNext == '*') {
                lLength = lValueLength - lCurValueIdx;
                lNext = ++i < lFmtLength ? lFmt[i] : (char)'\u0000';
            } else if (Character.isDigit(lNext)) {
                int lEndIndex = i;
                while (lEndIndex < lFmtLength) {
                    if (!Character.isDigit(lFmt[lEndIndex])) break;
                    ++lEndIndex;
                }
                lLength = Integer.parseInt(new String(lFmt, i, lEndIndex - i));
                i = lEndIndex;
                lNext = i < lFmtLength ? lFmt[i] : (char)'\u0000';
            } else {
                lLength = lType == '@' ? 0 : 1;
            }
            switch (lType) {
                case '%': {
                    throw new ArgumentError(ruby, "% is not supported");
                }
                case 'A': {
                    if (lLength > lValueLength - lCurValueIdx) {
                        lLength = lValueLength - lCurValueIdx;
                    }
                    int end = lLength;
                    int t = lCurValueIdx + lLength - 1;
                    while (lLength > 0) {
                        if (value.charAt(t) != ' ' && value.charAt(t) != '\u0000') break;
                        --lLength;
                        --t;
                    }
                    lResult.append(RubyString.newString(ruby, value.substring(lCurValueIdx, lCurValueIdx + lLength)));
                    lCurValueIdx += end;
                    break;
                }
                case 'Z': {
                    if (lLength > lValueLength - lCurValueIdx) {
                        lLength = lValueLength - lCurValueIdx;
                    }
                    int end = lLength;
                    int t = lCurValueIdx + lLength - 1;
                    while (lLength > 0) {
                        if (value.charAt(t) != '\u0000') break;
                        --lLength;
                        --t;
                    }
                    lResult.append(RubyString.newString(ruby, value.substring(lCurValueIdx, lCurValueIdx + lLength)));
                    lCurValueIdx += end;
                    break;
                }
                case 'a': {
                    if (lLength > lValueLength - lCurValueIdx) {
                        lLength = lValueLength - lCurValueIdx;
                    }
                    lResult.append(RubyString.newString(ruby, value.substring(lCurValueIdx, lCurValueIdx + lLength)));
                    lCurValueIdx += lLength;
                    break;
                }
                case 'b': {
                    if (lFmt[i - 1] == '*' || lLength > (lValueLength - lCurValueIdx) * 8) {
                        lLength = (lValueLength - lCurValueIdx) * 8;
                    }
                    int bits = 0;
                    StringBuffer lElem = new StringBuffer(lLength);
                    int lCurByte = 0;
                    while (lCurByte < lLength) {
                        bits = (lCurByte & 7) != 0 ? (bits >>>= 1) : (int)value.charAt(lCurValueIdx++);
                        lElem.append((bits & 1) != 0 ? (char)'1' : '0');
                        ++lCurByte;
                    }
                    lResult.append(RubyString.newString(ruby, lElem.toString()));
                    break;
                }
                case 'B': {
                    if (lFmt[i - 1] == '*' || lLength > (lValueLength - lCurValueIdx) * 8) {
                        lLength = (lValueLength - lCurValueIdx) * 8;
                    }
                    int bits = 0;
                    StringBuffer lElem = new StringBuffer(lLength);
                    int lCurByte = 0;
                    while (lCurByte < lLength) {
                        bits = (lCurByte & 7) != 0 ? (bits <<= 1) : (int)value.charAt(lCurValueIdx++);
                        lElem.append((bits & 0x80) != 0 ? (char)'1' : '0');
                        ++lCurByte;
                    }
                    lResult.append(RubyString.newString(ruby, lElem.toString()));
                    break;
                }
                case 'h': {
                    if (lFmt[i - 1] == '*' || lLength > (lValueLength - lCurValueIdx) * 2) {
                        lLength = (lValueLength - lCurValueIdx) * 2;
                    }
                    int bits = 0;
                    StringBuffer lElem = new StringBuffer(lLength);
                    int lCurByte = 0;
                    while (lCurByte < lLength) {
                        bits = (lCurByte & 1) != 0 ? (bits >>>= 4) : (int)value.charAt(lCurValueIdx++);
                        lElem.append(sHexDigits[bits & 0xF]);
                        ++lCurByte;
                    }
                    lResult.append(RubyString.newString(ruby, lElem.toString()));
                    break;
                }
                case 'H': {
                    if (lFmt[i - 1] == '*' || lLength > (lValueLength - lCurValueIdx) * 2) {
                        lLength = (lValueLength - lCurValueIdx) * 2;
                    }
                    int bits = 0;
                    StringBuffer lElem = new StringBuffer(lLength);
                    int lCurByte = 0;
                    while (lCurByte < lLength) {
                        bits = (lCurByte & 1) != 0 ? (bits <<= 4) : (int)value.charAt(lCurValueIdx++);
                        lElem.append(sHexDigits[bits >>> 4 & 0xF]);
                        ++lCurByte;
                    }
                    lResult.append(RubyString.newString(ruby, lElem.toString()));
                    break;
                }
                case 'c': {
                    int lPadLength = 0;
                    if (lLength > lValueLength - lCurValueIdx) {
                        if (lFmt[i - 1] != '*') {
                            lPadLength = lLength - (lValueLength - lCurValueIdx);
                        }
                        lLength = lValueLength - lCurValueIdx;
                    }
                    while (lLength-- > 0) {
                        int c2;
                        if ((c2 = value.charAt(lCurValueIdx++)) > 127) {
                            c2 -= 256;
                        }
                        lResult.append(RubyFixnum.newFixnum(ruby, c2));
                    }
                    while (lPadLength-- > 0) {
                        lResult.append(ruby.getNil());
                    }
                    continue block21;
                }
                case 'C': {
                    int lPadLength = 0;
                    if (lLength > lValueLength - lCurValueIdx) {
                        if (lFmt[i - 1] != '*') {
                            lPadLength = lLength - (lValueLength - lCurValueIdx);
                        }
                        lLength = lValueLength - lCurValueIdx;
                    }
                    while (lLength-- > 0) {
                        char c3 = value.charAt(lCurValueIdx++);
                        lResult.append(RubyFixnum.newFixnum(ruby, c3));
                    }
                    while (lPadLength-- > 0) {
                        lResult.append(ruby.getNil());
                    }
                    continue block21;
                }
                case 's': {
                    int lPadLength = 0;
                    if (lLength > (lValueLength - lCurValueIdx) / 2) {
                        if (lFmt[i - 1] != '*') {
                            lPadLength = lLength - (lValueLength - lCurValueIdx) / 2;
                        }
                        lLength = (lValueLength - lCurValueIdx) / 2;
                    }
                    while (lLength-- > 0) {
                        short tmp = (short)(value.charAt(lCurValueIdx++) & 0xFF);
                        short s = (short)(value.charAt(lCurValueIdx++) & 0xFF);
                        s = (short)(s << 8);
                        s = (short)(s | tmp);
                        lResult.append(RubyFixnum.newFixnum(ruby, s));
                    }
                    while (lPadLength-- > 0) {
                        lResult.append(ruby.getNil());
                    }
                    continue block21;
                }
                case 'S': 
                case 'v': {
                    int lPadLength = 0;
                    if (lLength > (lValueLength - lCurValueIdx) / 2) {
                        if (lFmt[i - 1] != '*') {
                            lPadLength = lLength - (lValueLength - lCurValueIdx) / 2;
                        }
                        lLength = (lValueLength - lCurValueIdx) / 2;
                    }
                    while (lLength-- > 0) {
                        short tmp = (short)(value.charAt(lCurValueIdx++) & 0xFF);
                        int s = value.charAt(lCurValueIdx++) & 0xFF;
                        s <<= 8;
                        lResult.append(RubyFixnum.newFixnum(ruby, s |= tmp));
                    }
                    while (lPadLength-- > 0) {
                        lResult.append(ruby.getNil());
                    }
                    continue block21;
                }
                case 'i': 
                case 'l': {
                    int i3;
                    int lPadLength = 0;
                    if (lLength > (lValueLength - lCurValueIdx) / 4) {
                        if (lFmt[i - 1] != '*') {
                            lPadLength = lLength - (lValueLength - lCurValueIdx) / 4;
                        }
                        lLength = (lValueLength - lCurValueIdx) / 4;
                    }
                    while (lLength-- > 0) {
                        int i1 = value.charAt(lCurValueIdx++) & 0xFF;
                        int i2 = value.charAt(lCurValueIdx++) & 0xFF;
                        i3 = value.charAt(lCurValueIdx++) & 0xFF;
                        int i4 = value.charAt(lCurValueIdx++) & 0xFF;
                        i4 <<= 24;
                        i4 |= i3 << 16;
                        i4 |= i2 << 8;
                        lResult.append(RubyFixnum.newFixnum(ruby, i4 |= i1));
                    }
                    while (lPadLength-- > 0) {
                        lResult.append(ruby.getNil());
                    }
                    continue block21;
                }
                case 'I': 
                case 'L': 
                case 'V': {
                    int i3;
                    int lPadLength = 0;
                    if (lLength > (lValueLength - lCurValueIdx) / 4) {
                        if (lFmt[i - 1] != '*') {
                            lPadLength = lLength - (lValueLength - lCurValueIdx) / 4;
                        }
                        lLength = (lValueLength - lCurValueIdx) / 4;
                    }
                    while (lLength-- > 0) {
                        int i1 = value.charAt(lCurValueIdx++) & 0xFF;
                        int i2 = value.charAt(lCurValueIdx++) & 0xFF;
                        i3 = value.charAt(lCurValueIdx++) & 0xFF;
                        long i4 = value.charAt(lCurValueIdx++) & 0xFF;
                        i4 <<= 24;
                        i4 |= (long)(i3 << 16);
                        i4 |= (long)(i2 << 8);
                        lResult.append(RubyFixnum.newFixnum(ruby, i4 |= (long)i1));
                    }
                    while (lPadLength-- > 0) {
                        lResult.append(ruby.getNil());
                    }
                    continue block21;
                }
                case 'N': {
                    int lPadLength = 0;
                    if (lLength > (lValueLength - lCurValueIdx) / 4) {
                        if (lFmt[i - 1] != '*') {
                            lPadLength = lLength - (lValueLength - lCurValueIdx) / 4;
                        }
                        lLength = (lValueLength - lCurValueIdx) / 4;
                    }
                    while (lLength-- > 0) {
                        long i1 = value.charAt(lCurValueIdx++) & 0xFF;
                        i1 <<= 8;
                        i1 |= (long)(value.charAt(lCurValueIdx++) & 0xFF);
                        i1 <<= 8;
                        i1 |= (long)(value.charAt(lCurValueIdx++) & 0xFF);
                        i1 <<= 8;
                        lResult.append(RubyFixnum.newFixnum(ruby, i1 |= (long)(value.charAt(lCurValueIdx++) & 0xFF)));
                    }
                    while (lPadLength-- > 0) {
                        lResult.append(ruby.getNil());
                    }
                    continue block21;
                }
                case 'n': {
                    int lPadLength = 0;
                    if (lLength > (lValueLength - lCurValueIdx) / 2) {
                        if (lFmt[i - 1] != '*') {
                            lPadLength = lLength - (lValueLength - lCurValueIdx) / 2;
                        }
                        lLength = (lValueLength - lCurValueIdx) / 2;
                    }
                    while (lLength-- > 0) {
                        int i1 = value.charAt(lCurValueIdx++) & 0xFF;
                        i1 <<= 8;
                        lResult.append(RubyFixnum.newFixnum(ruby, i1 |= value.charAt(lCurValueIdx++) & 0xFF));
                    }
                    while (lPadLength-- > 0) {
                        lResult.append(ruby.getNil());
                    }
                    continue block21;
                }
                case 'U': {
                    if (lLength > lValueLength - lCurValueIdx) {
                        lLength = lValueLength - lCurValueIdx;
                    }
                    String toUnpack = value.substring(lCurValueIdx);
                    String lUtf8 = null;
                    try {
                        lUtf8 = new String(toUnpack.getBytes("iso8859-1"), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        Asserts.notReached("can't convert from UTF8");
                    }
                    char[] c4 = lUtf8.toCharArray();
                    int lNbChar = c4.length;
                    int lCurCharIdx = 0;
                    while (lLength-- > 0 && lCurCharIdx < lNbChar) {
                        lResult.append(RubyFixnum.newFixnum(ruby, c4[lCurCharIdx]));
                        ++lCurCharIdx;
                    }
                    continue block21;
                }
            }
        }
        return lResult;
    }

    private static final StringBuffer shrink(StringBuffer i2Shrink, int iLength) {
        iLength = i2Shrink.length() - iLength;
        i2Shrink.setLength(iLength);
        return i2Shrink;
    }

    private static final StringBuffer grow(StringBuffer i2Grow, String iPads, int iLength) {
        int lPadLength = iPads.length();
        while (iLength >= lPadLength) {
            i2Grow.append(iPads);
            iLength -= lPadLength;
        }
        i2Grow.append(iPads.substring(0, iLength));
        return i2Grow;
    }

    public static RubyString pack(ArrayList list, RubyString iFmt) {
        Ruby ruby = iFmt.getRuntime();
        char[] lFmt = iFmt.getValue().toCharArray();
        int lFmtLength = lFmt.length;
        int idx = 0;
        int lLeftInArray = list.size();
        StringBuffer lResult = new StringBuffer();
        int i = 0;
        block24: while (i < lFmtLength) {
            char lNext;
            char lType;
            int lLength = 1;
            if (Character.isWhitespace(lType = lFmt[i++])) continue;
            char c = lNext = i < lFmtLength ? lFmt[i] : (char)'\u0000';
            if (lNext == '!' || lNext == '_') {
                if (sNatStr.indexOf(lType) != -1) {
                    lNext = ++i < lFmtLength ? lFmt[i] : (char)'\u0000';
                } else {
                    throw new ArgumentError(ruby, "'" + lNext + "' allowed only after types " + sNatStr);
                }
            }
            if (lNext == '*') {
                lLength = "@Xxu".indexOf(lType) == -1 ? lLeftInArray : 0;
                lNext = ++i < lFmtLength ? lFmt[i] : (char)'\u0000';
            } else if (Character.isDigit(lNext)) {
                int lEndIndex = i;
                while (lEndIndex < lFmtLength) {
                    if (!Character.isDigit(lFmt[lEndIndex])) break;
                    ++lEndIndex;
                }
                lLength = Integer.parseInt(new String(lFmt, i, lEndIndex - i));
                i = lEndIndex;
                lNext = i < lFmtLength ? lFmt[i] : (char)'\u0000';
            }
            block1 : switch (lType) {
                case '%': {
                    throw new ArgumentError(ruby, "% is not supported");
                }
                case 'A': 
                case 'B': 
                case 'H': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'h': {
                    if (lLeftInArray-- <= 0) {
                        throw new ArgumentError(ruby, sTooFew);
                    }
                    IRubyObject lFrom = (IRubyObject)list.get(idx++);
                    String lCurElemString = lFrom == ruby.getNil() ? "" : Pack.convert2String(lFrom);
                    if (lFmt[i - 1] == '*') {
                        lLength = lCurElemString.length();
                    }
                    switch (lType) {
                        case 'A': 
                        case 'Z': 
                        case 'a': {
                            if (lCurElemString.length() >= lLength) {
                                lResult.append(lCurElemString.toCharArray(), 0, lLength);
                                break;
                            }
                            lResult.append(lCurElemString);
                            Pack.grow(lResult, lType == 'a' ? sNil10 : sSp10, lLength -= lCurElemString.length());
                            break;
                        }
                        case 'b': {
                            char lCurChar;
                            int lByte = 0;
                            int lIndex = 0;
                            int lPadLength = 0;
                            if (lLength > lCurElemString.length()) {
                                lPadLength = (lLength - lCurElemString.length() + 1) / 2;
                                lLength = lCurElemString.length();
                            }
                            lIndex = 0;
                            while (lIndex < lLength) {
                                if (((lCurChar = lCurElemString.charAt(lIndex++)) & '\u0001') != 0) {
                                    lByte |= 0x80;
                                }
                                if ((lIndex & 7) != 0) {
                                    lByte >>= 1;
                                    continue;
                                }
                                lResult.append((char)(lByte & 0xFF));
                                lByte = 0;
                            }
                            if ((lLength & 7) != 0) {
                                lResult.append((char)((lByte >>= 7 - (lLength & 7)) & 0xFF));
                            }
                            lLength = lResult.length();
                            lResult.setLength(lLength + lPadLength);
                            break;
                        }
                        case 'B': {
                            char lCurChar;
                            int lByte = 0;
                            int lIndex = 0;
                            int lPadLength = 0;
                            if (lLength > lCurElemString.length()) {
                                lPadLength = (lLength - lCurElemString.length() + 1) / 2;
                                lLength = lCurElemString.length();
                            }
                            lIndex = 0;
                            while (lIndex < lLength) {
                                lCurChar = lCurElemString.charAt(lIndex++);
                                lByte |= lCurChar & '\u0001';
                                if ((lIndex & 7) != 0) {
                                    lByte <<= 1;
                                    continue;
                                }
                                lResult.append((char)(lByte & 0xFF));
                                lByte = 0;
                            }
                            if ((lLength & 7) != 0) {
                                lResult.append((char)((lByte <<= 7 - (lLength & 7)) & 0xFF));
                            }
                            lLength = lResult.length();
                            lResult.setLength(lLength + lPadLength);
                            break;
                        }
                        case 'h': {
                            char lCurChar;
                            int lByte = 0;
                            int lIndex = 0;
                            int lPadLength = 0;
                            if (lLength > lCurElemString.length()) {
                                lPadLength = (lLength - lCurElemString.length() + 1) / 2;
                                lLength = lCurElemString.length();
                            }
                            lIndex = 0;
                            while (lIndex < lLength) {
                                lByte = Character.isJavaIdentifierStart(lCurChar = lCurElemString.charAt(lIndex++)) ? (lByte |= ((lCurChar & 0xF) + 9 & 0xF) << 4) : (lByte |= (lCurChar & 0xF) << 4);
                                if ((lIndex & 1) != 0) {
                                    lByte >>= 4;
                                    continue;
                                }
                                lResult.append((char)(lByte & 0xFF));
                                lByte = 0;
                            }
                            if ((lLength & 1) != 0) {
                                lResult.append((char)(lByte & 0xFF));
                            }
                            lLength = lResult.length();
                            lResult.setLength(lLength + lPadLength);
                            break;
                        }
                        case 'H': {
                            char lCurChar;
                            int lByte = 0;
                            int lIndex = 0;
                            int lPadLength = 0;
                            if (lLength > lCurElemString.length()) {
                                lPadLength = (lLength - lCurElemString.length() + 1) / 2;
                                lLength = lCurElemString.length();
                            }
                            lIndex = 0;
                            while (lIndex < lLength) {
                                lByte = Character.isJavaIdentifierStart(lCurChar = lCurElemString.charAt(lIndex++)) ? (lByte |= (lCurChar & 0xF) + 9 & 0xF) : (lByte |= lCurChar & 0xF);
                                if ((lIndex & 1) != 0) {
                                    lByte <<= 4;
                                    continue;
                                }
                                lResult.append((char)(lByte & 0xFF));
                                lByte = 0;
                            }
                            if ((lLength & 1) != 0) {
                                lResult.append((char)(lByte & 0xFF));
                            }
                            lLength = lResult.length();
                            lResult.setLength(lLength + lPadLength);
                        }
                    }
                    continue block24;
                }
                case 'x': {
                    Pack.grow(lResult, sNil10, lLength);
                    break;
                }
                case 'X': {
                    Pack.shrink(lResult, lLength);
                    break;
                }
                case '@': {
                    if ((lLength -= lResult.length()) > 0) {
                        Pack.grow(lResult, sNil10, lLength);
                    }
                    if ((lLength = -lLength) <= 0) break;
                    Pack.shrink(lResult, lLength);
                    break;
                }
                case 'C': 
                case 'c': {
                    IRubyObject lFrom;
                    while (lLength-- > 0) {
                        if (lLeftInArray-- <= 0) {
                            throw new ArgumentError(ruby, sTooFew);
                        }
                        lFrom = (IRubyObject)list.get(idx++);
                        char c2 = lFrom == ruby.getNil() ? (char)'\u0000' : (char)(RubyNumeric.num2long(lFrom) & 0xFFL);
                        lResult.append(c2);
                    }
                    continue block24;
                }
                case 'S': 
                case 's': 
                case 'v': {
                    int s;
                    IRubyObject lFrom;
                    while (lLength-- > 0) {
                        if (lLeftInArray-- <= 0) {
                            throw new ArgumentError(ruby, sTooFew);
                        }
                        lFrom = (IRubyObject)list.get(idx++);
                        s = lFrom == ruby.getNil() ? 0 : (int)(RubyNumeric.num2long(lFrom) & 0xFFFFL);
                        lResult.append((char)(s & 0xFF));
                        lResult.append((char)((s & 0xFF00) >> 8));
                    }
                    continue block24;
                }
                case 'n': {
                    int s;
                    IRubyObject lFrom;
                    while (lLength-- > 0) {
                        if (lLeftInArray-- <= 0) {
                            throw new ArgumentError(ruby, sTooFew);
                        }
                        lFrom = (IRubyObject)list.get(idx++);
                        s = lFrom == ruby.getNil() ? 0 : (int)(RubyNumeric.num2long(lFrom) & 0xFFFFL);
                        lResult.append((char)((s & 0xFF00) >> 8));
                        lResult.append((char)(s & 0xFF));
                    }
                    continue block24;
                }
                case 'I': 
                case 'L': 
                case 'V': 
                case 'i': 
                case 'l': {
                    int s;
                    IRubyObject lFrom;
                    while (lLength-- > 0) {
                        if (lLeftInArray-- <= 0) {
                            throw new ArgumentError(ruby, sTooFew);
                        }
                        lFrom = (IRubyObject)list.get(idx++);
                        s = lFrom == ruby.getNil() ? 0 : (int)RubyNumeric.num2long(lFrom);
                        lResult.append((char)(s & 0xFF));
                        lResult.append((char)(s >> 8 & 0xFF));
                        lResult.append((char)(s >> 16 & 0xFF));
                        lResult.append((char)(s >> 24 & 0xFF));
                    }
                    continue block24;
                }
                case 'N': {
                    int s;
                    IRubyObject lFrom;
                    while (lLength-- > 0) {
                        if (lLeftInArray-- <= 0) {
                            throw new ArgumentError(ruby, sTooFew);
                        }
                        lFrom = (IRubyObject)list.get(idx++);
                        s = lFrom == ruby.getNil() ? 0 : (int)RubyNumeric.num2long(lFrom);
                        lResult.append((char)(s >> 24 & 0xFF));
                        lResult.append((char)(s >> 16 & 0xFF));
                        lResult.append((char)(s >> 8 & 0xFF));
                        lResult.append((char)(s & 0xFF));
                    }
                    continue block24;
                }
                case 'm': 
                case 'u': {
                    if (lLeftInArray-- <= 0) {
                        throw new ArgumentError(ruby, sTooFew);
                    }
                    IRubyObject lFrom = (IRubyObject)list.get(idx++);
                    String lCurElemString = lFrom == ruby.getNil() ? "" : Pack.convert2String(lFrom);
                    lLength = lLength <= 2 ? 45 : lLength / 3 * 3;
                    while (true) {
                        Pack.encodes(ruby, lResult, lCurElemString, lLength, lType);
                        if (lLength >= lCurElemString.length()) break block1;
                        lCurElemString = lCurElemString.substring(lLength);
                    }
                }
                case 'M': {
                    if (lLeftInArray-- <= 0) {
                        throw new ArgumentError(ruby, sTooFew);
                    }
                    IRubyObject lFrom = (IRubyObject)list.get(idx++);
                    String lCurElemString = lFrom == ruby.getNil() ? "" : Pack.convert2String(lFrom);
                    if (lLength <= 1) {
                        lLength = 72;
                    }
                    Pack.qpencode(lResult, lCurElemString, lLength);
                    break;
                }
                case 'U': {
                    IRubyObject lFrom;
                    char[] c3 = new char[lLength];
                    int lCurCharIdx = 0;
                    while (lLength-- > 0) {
                        if (lLeftInArray-- <= 0) {
                            throw new ArgumentError(ruby, sTooFew);
                        }
                        lFrom = (IRubyObject)list.get(idx++);
                        long l = lFrom == ruby.getNil() ? 0L : RubyNumeric.num2long(lFrom);
                        c3[lCurCharIdx] = (char)l;
                        ++lCurCharIdx;
                    }
                    String s = new String(c3);
                    try {
                        lResult.append(RubyString.bytesToString(s.getBytes("UTF-8")));
                    }
                    catch (UnsupportedEncodingException e) {
                        Asserts.notReached("can't convert to UTF8");
                    }
                    continue block24;
                }
            }
        }
        return RubyString.newString(ruby, lResult.toString());
    }
}

