/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyMatchData;
import org.jruby.RubyNumeric;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.runtime.builtin.IRubyObject;

public class Split {
    private Ruby runtime;
    private int limit = 0;
    private RubyRegexp pattern;
    private String splitee;
    private List result = new ArrayList();

    public Split(Ruby runtime, String splitee, IRubyObject[] args) {
        if (args.length > 2) {
            throw new ArgumentError(runtime, args.length, 2);
        }
        this.splitee = splitee;
        this.runtime = runtime;
        this.pattern = this.getPattern(args);
        this.limit = this.getLimit(args);
    }

    public RubyArray results() {
        this.process();
        RubyArray resultArray = RubyArray.newArray(this.runtime, this.result.size());
        Iterator iter = this.result.iterator();
        while (iter.hasNext()) {
            resultArray.append(RubyString.newString(this.runtime, (String)iter.next()));
        }
        return resultArray;
    }

    private void process() {
        if (this.limit == 1) {
            this.result.add(this.splitee);
            return;
        }
        int pos = 0;
        int beg = 0;
        int hits = 0;
        int len = this.splitee.length();
        RubyString rubySplitee = RubyString.newString(this.runtime, this.splitee);
        while ((beg = this.pattern.search(rubySplitee, pos)) > -1) {
            ++hits;
            RubyMatchData matchData = (RubyMatchData)this.runtime.getBackref();
            int end = matchData.matchEndPosition();
            this.addResult(this.substring(this.splitee, pos, beg == pos && end == beg ? 1 : beg - pos));
            long extraPatterns = matchData.getSize();
            int i = 1;
            while ((long)i < extraPatterns) {
                this.addResult(((RubyString)matchData.group(i)).getValue());
                ++i;
            }
            int n = pos = end == beg ? beg + 1 : end;
            if (hits + 1 == this.limit) break;
        }
        if (hits == 0) {
            this.addResult(this.splitee);
        } else if (pos <= len) {
            this.addResult(this.substring(this.splitee, pos, len - pos));
        }
        if (this.limit == 0) {
            while (((String)this.result.get(this.result.size() - 1)).length() == 0) {
                this.result.remove(this.result.size() - 1);
            }
        }
    }

    private int getLimit(IRubyObject[] args) {
        if (args.length == 2) {
            return RubyNumeric.fix2int(args[1]);
        }
        return 0;
    }

    private RubyRegexp getPattern(IRubyObject[] args) {
        if (args.length == 0) {
            return RubyRegexp.newRegexp(this.runtime, "\\s+", 0);
        }
        if (args[0] instanceof RubyRegexp) {
            return RubyRegexp.regexpValue(args[0]);
        }
        RubyString stringPattern = RubyString.stringValue(args[0]);
        if (stringPattern.getValue().equals(" ")) {
            return RubyRegexp.newRegexp(this.runtime, "\\s+", 0);
        }
        return RubyRegexp.newRegexp(stringPattern, 0);
    }

    private void addResult(String string) {
        if (string == null) {
            return;
        }
        this.result.add(string);
    }

    private String substring(String string, int start, int length) {
        int stringLength = string.length();
        if (length < 0 || start > stringLength) {
            return null;
        }
        if (start < 0 && (start += stringLength) < 0) {
            return null;
        }
        int end = Math.min(stringLength, start + length);
        return string.substring(start, end);
    }
}

