/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.jruby.main.ASTSerializer;

public class JRubySerialize
extends Task {
    private File destdir = null;
    private List fileSets = new ArrayList();
    private Mapper mapperElement = null;

    public void execute() throws BuildException {
        HashMap<File, File> fileMap = new HashMap<File, File>();
        FileNameMapper mapper = null;
        if (this.mapperElement != null) {
            mapper = this.mapperElement.getImplementation();
        } else {
            mapper = new GlobPatternMapper();
            mapper.setFrom("*.rb");
            mapper.setTo("*.rb.ast.ser");
        }
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        int i = 0;
        int size = this.fileSets.size();
        while (i < size) {
            FileSet fs = (FileSet)this.fileSets.get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            File dir = fs.getDir(this.project);
            String[] files = ds.getIncludedFiles();
            files = sfs.restrict(files, dir, this.destdir, mapper);
            int j = 0;
            while (j < files.length) {
                File src = new File(dir, files[j]);
                File dest = new File(this.destdir, mapper.mapFileName(files[j])[0]);
                fileMap.put(src, dest);
                ++j;
            }
            ++i;
        }
        if (fileMap.size() > 0) {
            this.log("Serializing " + fileMap.size() + " file" + (fileMap.size() == 1 ? "" : "s") + " to " + this.destdir.getAbsolutePath());
            Iterator iter = fileMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                try {
                    ((File)entry.getValue()).getParentFile().mkdirs();
                    ASTSerializer.serialize((File)entry.getKey(), (File)entry.getValue());
                }
                catch (IOException ioExcpn) {
                    // empty catch block
                }
            }
        }
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void addFileset(FileSet set) {
        this.fileSets.add(set);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.location);
        }
        this.mapperElement = new Mapper(this.project);
        return this.mapperElement;
    }
}

