/* share/include/lam_config.h.  Generated automatically by configure.  */
/* share/include/lam_config.h.in.  Generated automatically from configure.in by autoheader.  */
/* -*- c -*-
 *
 *	LAM configuation header file.
 *      See the top-level LICENSE file for license and copyright
 *      information.
 *
 *	$Id: acconfig.h,v 6.45 2002/04/05 18:07:43 brbarret Exp $
 *
 * Function: - OS, CPU and compiler dependent configuration
 */

#ifndef _LAM_CONFIG_H
#define _LAM_CONFIG_H



/*
 * Version and configuration information
 */
#define LAM_ARCH "powerpc-apple-darwin1.4.1"
#define LAM_RPI "tcp"
#define LAM_VERSION "6.6b2cvs20020411"
#define LAM_MAJOR_VERSION 6
#define LAM_MINOR_VERSION 6
#define LAM_RELEASE_VERSION 0
#define LAM_ALPHA_VERSION 0
#define LAM_BETA_VERSION 2
#define LAM_CVS_VERSION 20020411

/*
 * The prefix -- used here only to trigger re-compilation (by
 * dependency analysis) if ./configure is run again with a different
 * path.
 */
#define LAM_PREFIX "/usr/local"

/*
 * Do we want debugging support?
 */
#define LAM_WANT_DEBUG 0

/*
 * Do we want to install all the TRILLIUM stuff or not?
 *
 * NOTE: This does NOT affect whether the stuff gets installed.  That
 * is all done by Automake / Autoconf at configure time.  All this
 * does is tell certain binaries (like lamboot) whether or not they
 * can expect to find all the trillium-only binaries installed!
 */
#define LAM_WANT_TRILLIUM_INSTALL 0

/*
 * Signal used internally by LAM.
 */
#define LAM_SIGUSR SIGUSR2

/*
 * Choose the RPI. Set *ONE* of these to 1.
 */
#define LAM_RPI_TCP 1
#define LAM_RPI_SHM_SYSV                0
#define LAM_RPI_SHM_USYSV               0
#define LAM_RPI_GM                      0

/*
 * Does gm have gm_fork?
 * (This really needs to be taken out of here and put into an AH_TEMPLATE)
 */
#define LAM_RPI_GM_HAVE_GM_FORK         0

/*
 * Some RPI's allow the use of the "shortcircuit" to bypass the normal
 * queue progression if the queue is empty.
 */
#define SHORTCIRCUIT 1

/*
 * Define as 1 if you have it.
 * Slightly risky here -- only define this if is hasn't already been
 * defined.  Prevents redefinitions from other libraries (hopefully
 * they're set to the same value!)
 */
#ifndef HAVE_ATEXIT
#define HAVE_ATEXIT 1
#endif
#ifndef HAVE_GETCWD
#define HAVE_GETCWD 1
#endif
#ifndef HAVE_SNPRINTF
#define HAVE_SNPRINTF 1
#endif
#ifndef HAVE_ATOLL
#define HAVE_ATOLL                      0
#endif
#ifndef HAVE_STRTOLL
#define HAVE_STRTOLL                    0
#endif
#ifndef HAVE_SCHED_H
#define HAVE_SCHED_H 1
#endif
#ifndef HAVE_STROPTS_H
#define HAVE_STROPTS_H                  0
#endif
#ifndef HAVE_GRP_H
#define HAVE_GRP_H 1
#endif
#ifndef HAVE_NETINET_TCP_H
#define HAVE_NETINET_TCP_H 1
#endif
#ifndef HAVE_RPC_TYPES_H
#define HAVE_RPC_TYPES_H 1
#endif
#ifndef HAVE_RPC_XDR_H
#define HAVE_RPC_XDR_H 1
#endif

/*
 * Use to select for IMPI support or not
 */
#define LAM_WANT_IMPI 0
#define LAM_WANT_IMPI_SERVER            0
#define LAM_IMPI_SERVER                 "bogus"

/*
 * Check the characteristics of our C++ compiler
 * Only do this if we're compiling IMPI!
 */
#if LAM_WANT_IMPI
#define LAM_CXX_NOTHROW_NEW             0
#define LAM_CXX_NOTHROW_NEW_ARG         0
#define LAM_CXX_EXCEPTIONS              0
#define LAM_CXX_BOOL 1
#define LAM_CXX_TRUE_FALSE 1
#if !LAM_CXX_BOOL
/* If we do not have bool, we do not have true or false either */
typedef enum { false, true } bool;
#else
/*
 * If we do have bool, we may or may not have true and false (!).
 * Can't just typedef true and false, though, because some compilers
 * will make typedef types as small as possible, which may not be the
 * same type/size as "bool" (e.g., if bool is and int)
 */
#if !LAM_CXX_TRUE_FALSE
bool false = (bool) 0;
bool true = (bool) 1;
#endif
#endif

#endif /* LAM_WANT_IMPI */

/*
 * Various LAM tests
 */
#define LAM_HAVE_SA_RESTART 1
#define LAM_HAVE_SA_LEN 1
#define LAM_HAVE_UNION_SEMUN 0
#define LAM_HAVE_FIONBIO 0
#define LAM_HAVE_BSD43_FD_PASSING 0
#define LAM_HAVE_BSD44_FD_PASSING 1
#define LAM_HAVE_SVR4_FD_PASSING 0
#define LAM_CMSG_DATA_OFFSET_ERROR            0
#define LAM_HAVE_OPENPTY 1
#define LAM_HAVE_BSD_PTYS 1
#define LAM_HAVE_SYSV_PTYS 0
#define LAM_HAVE_SYSV_SEMAPHORES 1
#define LAM_HAVE_SYSV_SHMEM 1

/*
 * Define as 1 if have yield() or sched_yield() function.
 */
#ifndef HAVE_SCHED_YIELD
#define HAVE_SCHED_YIELD 1
#endif

/*
 * Define as 1 if you need it.
 */
#define LAM_NEED_SYS_SELECT_H 1

/*
 * Set *ONE* of these to 1 according to the format the FORTRAN compiler
 * uses for external names.
 */
#define LAM_WANT_FORTRAN 1
#define LAM_FORTRANNOUNDERSCORE         0
#define LAM_FORTRANCAPS                 0
#define LAM_FORTRANUNDERSCORE           0
#define LAM_FORTRANDOUBLEUNDERSCORE 1

/*
 * Predefined types
 */
#define LAM_HAVE_int2 0
#define LAM_HAVE_uint2 0
#define LAM_HAVE_int4 0
#define LAM_HAVE_uint4 0
#define LAM_HAVE_int8 0
#define LAM_HAVE_uint8 0
#define LAM_HAVE_float4 0
#define LAM_HAVE_float8 0

/*
 * Type sizes.
 * Very, very annoying because of standardized AC_CHECK_SIZEOF macro...
 */
#define LAM_SIZEOF_SHORT 2
#define LAM_SIZEOF_WCHAR 4
#define LAM_SIZEOF_INT 4
#define LAM_SIZEOF_LONG 4
#define LAM_SIZEOF_LONG_LONG 8
#define LAM_SIZEOF_FLOAT 4
#define LAM_SIZEOF_DOUBLE 8
#define LAM_SIZEOF_LONG_DOUBLE 8
#define LAM_SIZEOF_VOID_P 4

#define LAM_ALIGNMENT_SHORT 2
#define LAM_ALIGNMENT_WCHAR 4
#define LAM_ALIGNMENT_INT 4
#define LAM_ALIGNMENT_LONG 4
#define LAM_ALIGNMENT_LONG_LONG 4
#define LAM_ALIGNMENT_FLOAT 4
#define LAM_ALIGNMENT_DOUBLE 4
#define LAM_ALIGNMENT_LONG_DOUBLE 4
#define LAM_ALIGNMENT_VOID_P 4

#define LAM_SIZEOF_FORTRAN_INT 
#define LAM_SIZEOF_FORTRAN_REAL 
#define LAM_SIZEOF_FORTRAN_DBLPREC 
#define LAM_SIZEOF_FORTRAN_COMPLEX 
#define LAM_SIZEOF_FORTRAN_DBLCOMPLEX 

#define LAM_ALIGNMENT_FORTRAN_INT 4
#define LAM_ALIGNMENT_FORTRAN_REAL 4
#define LAM_ALIGNMENT_FORTRAN_COMPLEX 4
#define LAM_ALIGNMENT_FORTRAN_DBLPREC 4
#define LAM_ALIGNMENT_FORTRAN_DBLCOMPLEX 4

/*
 * Use select for spinlock yielding even when OS yield functionality is
 * available.
 */
#define LAM_USE_SELECT_YIELD 0

/*
 * Define to 1 if the struct stat elements are not int4's
 * Currently, this is only for the portland group compilers
 */
#define LAM_STAT_MEMBERS_INT4 1

/*
 * Which threads package do we have?
 */
#define LAM_HAVE_SOL_THREADS 0
#if LAM_HAVE_SOL_THREADS
#include <thread.h>
#include <synch.h>
typedef thread_t lam_thread_t;
typedef mutex_t lam_real_mutex_t;
#endif

#define LAM_HAVE_PTHREADS 0
#if LAM_HAVE_PTHREADS
#include <pthread.h>
typedef pthread_t lam_thread_t;
typedef pthread_mutex_t lam_real_mutex_t;
#endif

#define LAM_HAVE_THREADS (LAM_HAVE_SOL_THREADS || LAM_HAVE_PTHREADS)
#if !LAM_HAVE_THREADS
typedef int lam_thread_t;
typedef int lam_real_mutex_t;
#endif

/*
 * Define to 1 if we want ROMIO support
 * Some architectures need -laio in conjunction with ROMIO
 */
#define LAM_WANT_ROMIO 1
#define HAVE_LIBAIO 0

/*
 * Do we want the profiling layer?
 */
#define LAM_WANT_PROFILE 1

/*
 * Define to 1 if we want MPI 2 C++ bindings support
 */
#define LAM_WANT_MPI2CPP 1

/*
 * Some compilers do not define __STDC__ correctly (e.g., Solaris
 * workshop, at least version 4.2).  As such, the LAM header files
 * will not include full ANSI prototyping, which is a real pain for
 * users.  We can override that here -- set to 1 if you want full
 * ANSI prototypes.
 */
#define LAM_CONFIG_FORCE_PROTOS 1

#if __STDC__ || defined(c_plusplus) || defined(__cplusplus) || LAM_CONFIG_FORCE_PROTOS
#define LAM_WANT_PROTOS                  1
#else
#define LAM_WANT_PROTOS                  0
#endif

/*
 * Use to select if definitely want to zero out memory before using it.
 * This affects lower layers of message passing API, where purify, bcheck,
 * and other memory-checking debuggers will sometimes complain about
 * "read from uninitialized" and the like, when the code actually shows
 * that it is ok.  That is, LAM will function correctly with or without
 * this flag -- this flag only affects what purify/bcheck/etc. will report.
 * Note that there will be slightly more overhead in message passing if
 * this flag is enabled.
 */
#define LAM_DISINFECT 0
#if LAM_DISINFECT
#include <string.h>
#define LAM_ZERO_ME(a)                   memset(&(a), 0, sizeof((a)));
#else
#define LAM_ZERO_ME(a)
#endif

/*
 * Keep the compilers that were chosen in configure for use in the
 * wrapper compilers hcc, hcp, and hf77.  The C++ compiler is defined
 * in tools/hcc/hcp.in
 */

#define LAM_CC "gcc"
#define LAM_CXX "g++"
#define LAM_F77 "fort77"

/*
 * Find out the right type for the option length parameter to
 * getsockopt() , and the length parameter in recvfrom().  #$%#%&#
 * AIX!!!
 */
#define LAM_SOCK_OPTLEN_T int
#define LAM_RECVFROM_LEN_T int

/*
 * Values that are necessary because of our standardized acinclude.m4,
 * but not used anywhere in LAM
 */
#define LAM_CXX_STL 1
#define LAM_HAVE__PROTO                  0

/*
 * dlo timeouts for the lamd
 */
#define LAM_TO_BOOT 60
#define LAM_TO_DLO_ACK 1
#define LAM_TO_DLO_IDLE 120

/*
 * What remote agent program do we want?
 */
#define LAM_RSH "ssh "
#define LAM_RSH_NEED_MINUSMINUS 0

/*
 * Do we have bproc (AKA Scyld) libraries?
 */
#define LAM_HAVE_BPROC                   0

/*
 * System libraries
 */
#define LAM_SYSLIBS " "
#define LAM_HBIND ""

/*
 * $#%^#$^#$%^ HP-UX fortran!!!!
 */
#define LAM_FLIBPATH "-L"

/*
 * What do we do to rm
 */
#define LAM_RM "/bin/rm -f"


/*
 * This used to be part of mpi2c++/acconfig.h.
 */
#define _MPIPP_USEEXCEPTIONS_ 1
#define _MPIPP_DEBUG_         0

#define MPI2CPP_SIZEOF_INT 4
#define MPI2CPP_SIZEOF_BOOL_T 4

/*
 * Compile for Profiling?
 */
#define _MPIPP_PROFILING_ 0

/*
 * What kind of signals do we have?
 */
#define MPI2CPP_BSD_SIGNAL    0
#define MPI2CPP_SYSV_SIGNAL 1

/*
 * #$%@#%@#%@#% AIX!!!!
 */
#define MPI2CPP_AIX 0

/*
 * Are we on a 32 or 64 bit system?
 */
#define MPI2CPP_ATTR int


/* Define if you have the `atexit' function. */
#define HAVE_ATEXIT 1

/* Define if you have the `atoll' function. */
/* #undef HAVE_ATOLL */

/* Define if you have the <dlfcn.h> header file. */
#define HAVE_DLFCN_H 1

/* Define if you have the `getcwd' function. */
#define HAVE_GETCWD 1

/* Define if you have the <gm.h> header file. */
/* #undef HAVE_GM_H */

/* Define if you have the <grp.h> header file. */
#define HAVE_GRP_H 1

/* Define if you have the `gm' library (-lgm). */
/* #undef HAVE_LIBGM */

/* Define if you have the <netinet/tcp.h> header file. */
#define HAVE_NETINET_TCP_H 1

/* Define if you have the <pty.h> header file. */
/* #undef HAVE_PTY_H */

/* Define if you have the <rpc/types.h> header file. */
#define HAVE_RPC_TYPES_H 1

/* Define if you have the <rpc/xdr.h> header file. */
#define HAVE_RPC_XDR_H 1

/* Define if you have the <sched.h> header file. */
#define HAVE_SCHED_H 1

/* Define if you have the `sched_yield' function. */
#define HAVE_SCHED_YIELD 1

/* Define if you have the `snprintf' function. */
#define HAVE_SNPRINTF 1

/* Define if you have the <strings.h> header file. */
#define HAVE_STRINGS_H 1

/* Define if you have the <stropts.h> header file. */
/* #undef HAVE_STROPTS_H */

/* Define if you have the `strtoll' function. */
/* #undef HAVE_STRTOLL */

/* Define if you have the <sys/ipc.h> header file. */
#define HAVE_SYS_IPC_H 1

/* Define if you have the <sys/sem.h> header file. */
#define HAVE_SYS_SEM_H 1

/* Define if you have the <sys/shm.h> header file. */
#define HAVE_SYS_SHM_H 1

/* Define if you have the `yield' function. */
/* #undef HAVE_YIELD */

/* Define if your processor stores words with the most significant byte first
   (like Motorola and SPARC, unlike Intel and VAX). */
#define WORDS_BIGENDIAN 1

/* Define if on AIX 3.
   System headers sometimes define this.
   We just want to avoid a redefinition error message.  */
#ifndef _ALL_SOURCE
/* # undef _ALL_SOURCE */
#endif

/*
 * This used to be part of mpi2c++/acinclude.h.  These things can
 * safely be hardwired -- they are not determined by configure
 * anymore.
 */
#define MPI2CPP_HAVE_BOOL     1

#if MPI2CPP_SIZEOF_INT != MPI2CPP_SIZEOF_BOOL_T
#define _MPIPP_BOOL_NE_INT_   1
#else
#define _MPIPP_BOOL_NE_INT_   0
#endif

/*
 * LAM has (the proper) MPI_ERR_PENDING, so set this to 0
 */
#define MPI2CPP_HAVE_PENDING  0

/*
 * LAS has MPI_GET_VERSION, so set this to 1
 */
#define MPI2CPP_HAVE_MPI_GET_VERSION  1

/*
 * LAM has both of these, so set them to 1
 */
#define MPI2CPP_HAVE_STATUS_IGNORE    1
#define MPI2CPP_HAVE_STATUSES_IGNORE  1

/*
 * LAM and the fortran datatypes
 */
#define MPI2CPP_FORTRAN 1
#define MPI2CPP_ALL_OPTIONAL_FORTRAN 1
#define MPI2CPP_SOME_OPTIONAL_FORTRAN 0
#define MPI2CPP_OPTIONAL_C 1

#if _MPIPP_PROFILING_
#define _REAL_MPI_ PMPI
#else
#define _REAL_MPI_ MPI
#endif

/*
 * Assuming all compilers have "namespace" these days
 */
#define _MPIPP_USENAMESPACE_  1
#define _MPIPP_STATIC_
#define _MPIPP_EXTERN_ extern

/*
 * Assuming all compilers have "bool" these days
 */
#if defined(c_plusplus) || defined(__cplusplus)
typedef bool MPI2CPP_BOOL_T;
#define MPI2CPP_FALSE false
#define MPI2CPP_TRUE true
#endif

/*
 * Architecture/OS's that will need flags in the test suite to ignore
 * certain tests.  They're largely ignored now, but they have to be
 * set or g++ -Wundef will complain loudly.
 */
#define MPI2CPP_LAM63 0
#define MPI2CPP_LAM631 0
#define MPI2CPP_LAM632 0
#define MPI2CPP_LAM633 0
#define MPI2CPP_LAM64 0
#define MPI2CPP_LAMUNKNOWN 0
#define MPI2CPP_LAM 1

#define MPI2CPP_MPICH120 0
#define MPI2CPP_MPICH121 0
#define MPI2CPP_MPICHUNKNOWN 0
#define MPI2CPP_MPICH 0

#define MPI2CPP_IBM21014 0
#define MPI2CPP_IBM21015 0
#define MPI2CPP_IBM21016 0
#define MPI2CPP_IBM21017 0
#define MPI2CPP_IBM21018 0
#define MPI2CPP_IBM2_3_0_0 0
#define MPI2CPP_IBM2_4_0_0 0
#define MPI2CPP_IBMUNKNOWN 0
#define MPI2CPP_IBM_SP 0

#define MPI2CPP_SGI20 0
#define MPI2CPP_SGI30 0
#define MPI2CPP_SGI31 0
#define MPI2CPP_SGI32 0
#define MPI2CPP_SGIUNKNOWN 0

#define MPI2CPP_HPUX0102 0
#define MPI2CPP_HPUX0103 0
#define MPI2CPP_HPUX0105 0
#define MPI2CPP_HPUXUNKNOWN 0
#define MPI2CPP_HPUX_OS 0

#define MPI2CPP_CRAY 0
#define MPI2CPP_CRAY1104 0
#define MPI2CPP_CRAYUNKNOWN 0

#define MPI2CPP_G_PLUS_PLUS 0

/*
 * Can virtual functions return derived class instead
 * of base class?
 *
 * We seem to have lost this test somewhere along the line...
 */
#define MPI2CPP_VIRTUAL_FUNC_RET 1


/*
 * Some combinations for simplicity
 */
#define LAM_HAVE_FD_PASSING (LAM_HAVE_BSD44_FD_PASSING || LAM_HAVE_BSD43_FD_PASSING || LAM_HAVE_SYSV_FD_PASSING)
#define LAM_HAVE_PTYS (LAM_HAVE_BSD_PTYS || LAM_HAVE_SYSV_PTYS)

/*
 * Grumble.  AC_C_BIGENDIAN #defines WORDS_BIGENDIAN to 1 if we're on
 * a big endian machine.  But it leaves it undefined if we're on a
 * little endian machine (same for HAVE_YIELD).  This causes "gcc
 * -Wundef" to complain when we use "#if WORDS_BIGENDIAN".  So #define
 * it here to be 0 if it isn't already defined.
 */
#ifndef WORDS_BIGENDIAN
#define WORDS_BIGENDIAN 1
#endif
#ifndef HAVE_YIELD
#define HAVE_YIELD                       0
#endif

/*
 * In some places, we need to swap the endian (particularly in IMPI)
 */
#if LAM_WANT_IMPI
#if WORDS_BIGENDIAN
#define LAM_SWAP_ENDIAN(x, y)
#else
#define LAM_SWAP_ENDIAN(x, y) lam_swap_endian(x, y)
#endif
#endif

/*
 * Some compilers complain when sizeof(long double) == sizeof(double)
 * Example: gcc/linux 2.95.2 on alpha (64 bit)
 */
#if LAM_SIZEOF_DOUBLE == LAM_SIZEOF_LONG_DOUBLE
typedef double LAM_LONG_DOUBLE;
#else
typedef long double LAM_LONG_DOUBLE;
#endif


/*
 * For one reason or another (not worth listing here), autoheader
 * isn't smart enough to copy these lines automatically.  Hence, we
 */

/*
 * Some OS's are missing prototypes */
#define LAM_HAVE_snprintf_PROTO 1
#define LAM_HAVE_gethostname_PROTO 1

/*
 * If we don't have the gethostname proto, make it
 */
#if !LAM_HAVE_gethostname_PROTO
#if defined(c_plusplus) || defined(__cplusplus)
extern "C" {
#endif
int gethostname(char *name, int namelen);
#if defined(c_plusplus) || defined(__cplusplus)
}
#endif
#endif

/*
 * Define as 1 if broken.
 * Can't find an OS that's broken these days, but let's keep it here
 * just to be safe.
 */
#define LAM_BROKEN_SET_INET_SO_BUFSIZES 0
#define LAM_BROKEN_SET_UNIX_SO_BUFSIZES 0

/*
 * GER define
 *
 * per-process-pair minimum envelope slots
 */
#define MPI_GER                         8

/*
 * See if we can use "const" or not
 */
#define CONST                           const

/*
 * Define as 1 if floating point is IEEE.
 */
#define HAVE_IEEE_FP                    1

/*
 * Provide a cast to go from an int to a (void*), or empty if
 * sizeof(void*) == sizeof(int).  This is necessary on arches where we
 * need to first promote an int up to an integer type of the same size
 * as (void*), and then cast that to (void*), eg., Alpha Linux.
 *
 * Weird logic here so that we avoid the cast whenever possible -- so
 * we end up duplicating the "no cast" case.  For example, if we only
 * had to no cast case at the end, if we are on a architecture where
 * sizeof(int) == sizeof(long) == sizeof(void*) (e.g., Solaris 2.6),
 * we'll always end up casting through long.  Icky.
 */
#if LAM_SIZEOF_INT == LAM_SIZEOF_VOID_P
#define LAM_INT_TO_VOID_P
#elif LAM_SIZEOF_VOID_P == LAM_SIZEOF_LONG
#define LAM_INT_TO_VOID_P (long)
#elif LAM_SIZEOF_VOID_P == LAM_SIZEOF_LONG_LONG
#define LAM_INT_TO_VOID_P (long long)
#else
#define LAM_INT_TO_VOID_P
#endif


/*
 * prototypes
 */
#ifndef __ARGS
#if LAM_WANT_PROTOS
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#endif	/* _LAM_CONFIG_H */
