/////////////////////////////////////////////////////////////////////////////
// File:            gnFeature.h
// Purpose:         implements the gnBaseFeature for generic features
// Description:     
// Changes:        
// Version:         libGenome 0.1.0 
// Author:          Aaron Darling 
// Last Edited:     April 15, 2001, 10:34:50pm 
// Modified by:     
// Copyright:       (c) Aaron Darling 
// Licenses:        Proprietary 
/////////////////////////////////////////////////////////////////////////////
#ifndef _gnFeature_h_
#define _gnFeature_h_

#include "gn/gnDefs.h"

#include <string>
#include <vector>
#include "gn/gnBaseFeature.h"
#include "gn/gnBaseQualifier.h"

/**
 * gnFeature stores sequence features in memory.
 * It contains a list of locations and qualifiers which are used to describe this feature.
 * It can be referred to by ID.
 */
class GNDLLEXPORT gnFeature : public gnBaseFeature
{
public:
	/**
	 * Empty constructor.
	 */
	gnFeature( );
	/**
	 * Creates a memory feature with the specified name.
	 * @param name The name of the feature.
	 */
	gnFeature( string& name, uint32 id = 0, gnLocation::gnLocationType lt = gnLocation::LT_Nothing, boolean broken = false );
	/**
	 * Copy constructor.
	 * @param s The gnFeature to copy.
	 */
	gnFeature( const gnFeature& s );
	/**
	 * Destructor, frees memory.
	 */
	~gnFeature();
// Clone
	gnFeature* Clone() const;

private:
}; // class gnFeature

inline
gnFeature* gnFeature::Clone() const
{
	return new gnFeature(*this);
}

#endif
	// _gnFeature_h_
