/////////////////////////////////////////////////////////////////////////////
// File:            gnStringQualifier.h
// Purpose:         abstract Qualifier class
// Description:     Provides an interface for Qualifiers in memory and on disk.
// Changes:        
// Version:         libGenome 0.1.0 
// Author:          Aaron Darling 
// Last Edited:     April 15, 2001, 10:34:50pm 
// Modified by:     
// Copyright:       (c) Aaron Darling 
// Licenses:        Proprietary 
/////////////////////////////////////////////////////////////////////////////
#ifndef _gnStringQualifier_h_
#define _gnStringQualifier_h_

#include "gn/gnDefs.h"

#include <string>
#include "gn/gnClone.h"
#include "gn/gnBaseQualifier.h"

/**
 * gnStringQualifier stores a sequence qualifier in memory.
 * Use gnStringQualifier for a general purpose qualifier class.
 */
class GNDLLEXPORT gnStringQualifier : public gnBaseQualifier
{
public:
	/**
	 * Empty constructor.
	 */
	gnStringQualifier();
	/**
	 * Create a gnStringQualifier.
	 * @param name The qualifier name.
	 * @param value The qualifier.
	 */
	gnStringQualifier(const string& name, const string& value);
	/**
	 * Copy constructor.
	 * @param s The gnStringQualifier to copy.
	 */
	gnStringQualifier(const gnStringQualifier& s);
	/**
	 * Destructor, frees memory.
	 */
	~gnStringQualifier(){}

	gnStringQualifier* Clone() const;

	string GetName() const;
	string GetValue() const;
	/**
	 * Set the name of qualifier stored in this class.
	 * @param name The qualifier name as a string.
	 */
	void SetName(const string& name);
	/**
	 * Set the qualifier stored in this class.
	 * @param value The header as a string.
	 */
	void SetValue(const string& value);
	
	uint32 GetNameLength() const;
	uint32 GetValueLength() const;
private:
	string m_name;
	string m_value;
}; //class gnStringQualifier

inline
gnStringQualifier::gnStringQualifier(){
	m_name = "";
	m_value = "";
}
inline
gnStringQualifier::gnStringQualifier(const string& name, const string& value){
	m_name = name;
	m_value = value;
}
inline
gnStringQualifier::gnStringQualifier(const gnStringQualifier& s){
	m_name = string(s.m_name);
	m_value = string(s.m_value);
}
inline
gnStringQualifier* gnStringQualifier::Clone() const{
	return new gnStringQualifier(*this);
}
inline
string gnStringQualifier::GetName() const{
	return m_name;
}
inline
string gnStringQualifier::GetValue() const{
	return m_value;
}
inline
void gnStringQualifier::SetName(const string& name){
	m_name = name;
}
inline
void gnStringQualifier::SetValue(const string& value){
	m_value = value;
}
inline
uint32 gnStringQualifier::GetNameLength() const{
	return m_name.length();
}
inline
uint32 gnStringQualifier::GetValueLength() const{
	return m_value.length();
}


#endif
	// _gnStringQualifier_h_
