#ifndef LIBGRASS_H
#define LIBGRASS_H

#ifdef __cplusplus
extern "C" {
#endif

#include "gis.h"

#ifdef __cplusplus
#define class _class
#endif

#include "imagery.h"

#ifdef __cplusplus
#undef class
#endif

/* gisinit2.c */
int G_gisinit_2( char *, char *, char *, char * );

/* gisinit.c */
int G__get_gisinit();

/* elist.c */
char ** G_fetch_list_element( char *, char * );
char ** G_fetch_list_locations( char * gisdbase );
char ** G_fetch_list_mapsets( char * location_path );
char ** G_fetch_list_files( char * directory );

void    G_free_list( char ** );
char  **G_add_to_list( char **, char * );

/* opencell2.c */
char *G_path_peel_element( char * );
int G_check_cell( char *name, char **ret_mapset, char **ret_cell );
int G_open_cell_old_2( char * );

/* group2.c */
int I_check_group( char *name, char **ret_mapset, char **ret_group );

/* get_proj4_def.c */
char *G_get_cell_as_proj4( char *cell, char *mapset );
char *G_kv_to_proj4( struct Key_Value *in_proj_keys, 
                     struct Key_Value *in_units_keys );
int G_proj4_to_kv( char *proj4, 
                   struct Key_Value **out_proj_keys, 
                   struct Key_Value **out_units_keys );

/* make_loc.c */
int G__make_location( char *location_name, struct Cell_head *wind, 
    struct Key_Value *proj_info, struct Key_Value *proj_units,
    FILE *report_file );
void G_set_cellhd_from_projinfo( struct Cell_head *wind, 
                                 struct Key_Value *proj_info );

/* comp_proj.c */
int 
G_compare_projections( struct Key_Value *proj_info1, 
                       struct Key_Value *proj_units1, 
                       struct Key_Value *proj_info2, 
                       struct Key_Value *proj_units2 );

#ifdef __cplusplus
}
#endif

#endif /* ndef LIBGRASS_H */
