#ifndef CFG_H
#define CFG_H

/* cfg - persistent configuration properties interface
 */

struct cfg {
	struct linkedlist *list;
};

struct cfg *cfg_new(void);
void cfg_del(void *this);

int cfg_load(struct cfg *this, const char *filename);
int cfg_store(struct cfg *this, const char *filename);

int cfg_get_str(struct cfg *this, char *dst, int dn, const char *def, const char *name);
int cfg_vget_str(struct cfg *this, char *dst, int dn, const char *def, const char *name, ...);
int cfg_get_int(struct cfg *this, int *dst, int def, const char *name);
int cfg_vget_int(struct cfg *this, int *dst, int def, const char *name, ...);

int cfg_set_str(struct cfg *this, const char *src, int sn, const char *name);

#endif /* CFG_H */

