/* $Id: dstring.h.in,v 1.7 2002/12/26 09:34:11 aa5779 Exp $ */
/*
	Copyright (C) 2001, 2002 Artem V. Andreev (artem@AA5779.spb.edu)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef DSTRING_H
#define DSTRING_H

/*** \group[Definitions in dstring.h] */
/*** \struct
The handler type for dstrings. Fields of this structure should never be accessed directly.
Moreover, dstring objects should only be created/destroyed with special functions
(i.e. no over duration except dynamic)
*/
typedef struct dstring
{
	int curlen;
	int maxlen;
	int fixcnt;
	char *str;
	struct dstring *next;
	struct dstring *prev;
} dstring;

/*** \typedefs[2]
Function types for search/comparison and string transformation resp.
*/
typedef int (*ds_predicate_t)(int, int, void *);
typedef int (*ds_iterator_t)(int, void *);


/*** \macro[DS_BODY] Gives direct access to the contents of a dstring
\note Read-only access is recommended, though currently there is no
formal restriction on modification
*/
#define DS_BODY(ds) ((ds)->str)

dstring *ds_create(const char *src);
dstring *ds_createch(int ch);
dstring *ds_fromint(long val, int base, int len);
dstring *ds_fromuint(unsigned long val, int base, int len);
dstring *ds_fromllint(long long val, int base, int len);
dstring *ds_fromullint(unsigned long long val, int base, int len);

dstring *ds_fromptr(void *ptr);

dstring *ds_fromdouble(double val);

int ds_dbl_set_precision(int precision);
// present even if fp is disabled

dstring *ds_checkvalid(dstring *src);

dstring *ds_fix(dstring *src);

dstring *ds_unfix(dstring *src);
void ds_destroy(dstring *src);

dstring *ds_compact(dstring *src);

void ds_squeeze(int threshold);

/*** \enum
Various memory usage paramters.
Undocumented until somebody really makes use of them :).
*/
enum dsmu_params { dsmu_reserved, dsmu_unfixed, dsmu_unfixed_cnt,
					dsmu_squeeze, dsmu_lastsqueeze_mem,
					dsmu_lastsqueeze_cnt
				};

int ds_memory_usage(int param);

int ds_length(dstring *src);
int ds_isempty(dstring *src);

dstring *ds_copy(dstring *src);
dstring *ds_assign(dstring *dest, dstring *src);
dstring *ds_concat(dstring *arg1, dstring *arg2);
dstring *ds_append(dstring *dest, dstring *arg2);

dstring *ds_appendstr(dstring *dest, const char *arg2);
dstring *ds_appendch(dstring *dest, int ch);

dstring *ds_substr(dstring *src, int start, int len);
dstring *ds_setsubstr(dstring *dest, int start, int len, dstring *arg);

int ds_isprefix(dstring *base, dstring *prefix);
int ds_issuffix(dstring *base, dstring *suffix);
dstring *ds_commonprefix(dstring *str1, dstring *str2);

int ds_std_predicate(int ch, int ch1, void *extra);
int ds_p_casefold(int ch, int ch1, void *extra);

int ds_find(dstring *dest, int startpos, dstring *substr, ds_predicate_t userp, void *extra);
int ds_rfind(dstring *dest, dstring *substr, ds_predicate_t userp, void *extra);

int ds_compare(dstring *arg1, dstring *arg2, ds_predicate_t userp, void *extra);
int ds_comparestr(dstring *arg1, const char *arg2, ds_predicate_t userp, void *extra);
int ds_collate(dstring *arg1, dstring *arg2);

dstring *ds_tocollate(dstring *arg);

dstring *ds_reversip(dstring *src);

dstring *ds_reverse(dstring *src);

int ds_t_toupper(int ch, void *extra);

int ds_t_tolower(int ch, void *extra);

dstring *ds_transform(dstring *src, ds_iterator_t func, int inplace, void *extra);

void ds_foreach(dstring *src, ds_iterator_t func, void *extra);

#ifndef DSTRING_IMP
extern int ds_reserved_mem_limit;
extern int ds_unfix_mem_limit;
extern int ds_unfix_max_cnt;
#endif

/*** \endgroup */
#endif
