package Lire::AsciiDlf::Summary;

use strict;

use vars qw/ $VERSION @ISA /;

use Lire::Summary;
use Lire::AsciiDlf::Aggregator;
use Lire::Report::Entry;

use Carp;

BEGIN {
    ($VERSION)	= '$Revision: 1.9 $' =~ m!Revision: ([.\d]+)!;
    @ISA = qw/ Lire::Summary Lire::AsciiDlf::Aggregator /;
}

sub init_report {
    my ($self, $dlf_info) = @_;

    $self->{data} = [];
    my $i = 0;
    foreach my $op ( @{$self->ops}) {
	$op->init_report( $dlf_info );
	$self->{data}[$i++] = $op->init_group_data();
    }

    $self;
}

sub update_report {
    my ( $self, $dlf ) = @_;

    my $i = 0;
    foreach my $op ( @{$self->ops} ) {
	$op->update_group_data( $dlf, $self->{data}[$i++] );
    }

    $self;
}

sub end_report {
    my ( $self ) = @_;

    my $i = 0;
    foreach my $op ( @{$self->ops} ) {
	$op->end_group_data( $self->{data}[$i++] );
    }

    $self;
}

sub create_entries {
    my ( $self, $group ) = @_;

    # FIXME: This needs to be updated to something more sensible
    # in the presentation upgrade.
    my $i = 0;
    foreach my $op ( @{$self->ops} ) {
	my $entry = new Lire::Report::Entry;

	$entry->add_name( ucfirst $op->name, $op->name );
	$entry->add_value()
	  if UNIVERSAL::isa( $op, "Lire::NestableAggregator" );

	$op->add_entry_value( $entry, $self->{data}[$i++] );

	$group->add_entry( $entry );
    }

    $self;
}


# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::AsciiDlf::Summary -

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: Summary.pm,v 1.9 2002/06/08 21:56:38 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
