package Lire::Merge::MergeFactory;

use strict;

use Lire::ReportSpecFactory;
use Lire::Merge::ReportSpec;
use Lire::Merge::Group;
use Lire::Merge::GroupOp;
use Lire::Merge::Rangegroup;
use Lire::Merge::Records;
use Lire::Merge::Summary;
use Lire::Merge::Timegroup;
use Lire::Merge::Timeslot;

use vars qw/ $VERSION @ISA/;

BEGIN {
    @ISA = qw/Lire::ReportSpecFactory/;
    ($VERSION)	= '$Revision: 1.1 $' =~ m!Revision: ([.\d]+)!;
}

sub new {
    my $proto = shift;
    my $class = ref $proto || $proto;

    bless {}, $class;
}

sub create_report_spec {
    my $self = shift;

    return new Lire::Merge::ReportSpec( @_ );
}

sub create_group {
    my $self = shift;

    return new Lire::Merge::Group( @_ );
}

sub create_rangegroup {
    my $self = shift;

    return new Lire::Merge::Rangegroup( @_ );
}

sub create_summary {
    my $self = shift;

    return new Lire::Merge::Summary( @_ );
}

sub create_timegroup {
    my $self = shift;

    return new Lire::Merge::Timegroup( @_ );
}

sub create_timeslot {
    my $self = shift;

    return new Lire::Merge::Timeslot( @_ );
}

sub create_sum {
    my $self = shift;

    return new Lire::Merge::GroupOp::Sum( @_ );
}

sub create_avg {
    my $self = shift;

    return new Lire::Merge::GroupOp::Avg( @_ );
}

sub create_min {
    my $self = shift;

    return new Lire::Merge::GroupOp::Min( @_ );
}

sub create_max {
    my $self = shift;

    return new Lire::Merge::GroupOp::Max( @_ );
}

sub create_count {
    my $self = shift;

    return new Lire::Merge::GroupOp::Count( @_ );
}

sub create_records {
    my $self = shift;

    return new Lire::Merge::Records( @_ );
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::Merge::MergeFactory - ReportSpecFactory for the Merge package

=head1 SYNOPSIS

    use Lire::Merge::Factory;
    use Lire::ReportConfig;

    my $factory = new Lire::Merge::MergeFactory;
    my $cfg = eval { new_from_file Lire::ReportConfig( "report.cfg", "www", 
		     $factory ) };

=head1 DESCRIPTION

This is a Lire::ReportSpecFactory(3pm) subclass which will instantiate
implementation of the report specification objects which support
reports merging.

=head1 SEE ALSO

Lire::ReportSpecFactory(3pm) Lire::AsciiDlf::AsciiDlfFactory(3pm)

=head1 VERSION

$Id: MergeFactory.pm,v 1.1 2002/05/27 21:40:10 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2002 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
