package Lire::Merge::Records;

use strict;

use vars qw/ $VERSION @ISA /;

use Lire::Records;
use Lire::Merge::GroupOp;
use Lire::Report::Group;

use POSIX qw/ strftime /;

use Carp;

BEGIN {
    ($VERSION)	= '$Revision: 1.4 $' =~ m!Revision: ([.\d]+)!;
    @ISA = qw/ Lire::Records Lire::Merge::GroupOp /;
}

sub init_merge {
    my ( $self, $period_start, $period_end ) = @_;

    $self;
}

sub init_group_data {
    my ( $self ) = @_;

    return [];
}

sub merge_entries {
    my ( $self, $group, $data ) = @_;

    # Just copy reference to the entries
    foreach my $e ( $group->entries ) {
	push @$data, $e;
    }
}

sub end_group_data {
    my ( $self, $data ) = @_;

    $self;
}

sub add_entry_value {
    my ( $self, $entry, $data ) = @_;

    my $group = new Lire::Report::Group;
    $self->create_entries( $group, $data );
    $entry->add_group( $group );
}

sub create_entries {
    my ( $self, $group, $data ) = @_;

    foreach my $e ( @$data ) {
	$group->add_entry( $e );
    }
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::Merge::Records -

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: Records.pm,v 1.4 2002/08/16 22:48:59 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
