package Lire::Merge::ReportSpec;

use strict;

use vars qw/ $VERSION @ISA /;

use Lire::ReportSpec;

use Carp;

use constant INITED	=> 1;
use constant FINISHED	=> 2;

BEGIN {
    ($VERSION)	= '$Revision: 1.2 $' =~ m!Revision: ([.\d]+)!;
    @ISA = qw( Lire::ReportSpec );
}

sub init_merge {
    my ( $self ) = shift;

    if ( $self->extension ) {
	$self->{_calc} = $self->extension;
    } else {
	$self->{_calc} = $self->calc_spec;
    }
    $self->{_calc}->init_merge( @_ );
    $self->{_state} = INITED;

    $self;
}

sub merge_subreport {
    my ($self, $subreport ) = @_;

    croak "init_merge() wasn't called"
      unless $self->{_state} == INITED;

    $self->{_calc}->merge_entries( $subreport );

    $self;
}

sub end_merge {
    my $self = shift;

    croak "init_merge() wasn't called"
      unless $self->{_state} == INITED;

    $self->{_state} = FINISHED;
    $self->{_calc}->end_merge( @_ );

    $self;
}

sub create_entries {
    my ( $self, $subreport ) = @_;

    croak "end_merge() wasn't called"
      unless $self->{_state} == FINISHED;

    # Create the subreport object
    $self->{_calc}->create_entries( $subreport );
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::Merge::ReportSpec -

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: ReportSpec.pm,v 1.2 2002/06/08 21:55:00 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2002 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut


