package Lire::NestableAggregator;

use strict;

use Lire::Aggregator;
use Lire::GroupOp;
use Lire::DataTypes qw( :special );
use Carp;

use vars qw( @ISA $VERSION %ELEMENT_ID );

BEGIN {
    @ISA = qw/ Lire::Aggregator Lire::GroupOp /;
    ($VERSION)	= '$Revision: 1.1 $' =~ m!Revision: ([.\d]+)!;
    %ELEMENT_ID = ();
}

sub new {
    my $proto = shift;
    my $class = ref $proto || $proto;
    my %args = @_;

    my $report_spec = $args{report_spec};
    croak "report_spec parameter isn't of type Lire::ReportSpec"
      unless UNIVERSAL::isa( $report_spec, "Lire::ReportSpec" );

    croak "missing element_name parameter"
      unless defined $args{element_name};

    $ELEMENT_ID{$args{element_name}} ||= 0;

    my $name;
    if ( defined $args{name}) {
	$name = $args{name};
    } else {
	$name = "*" . $args{element_name} . "*" . 
	  $ELEMENT_ID{$args{element_name}}++;
    }

    my $self = bless {
		      report_spec   => $report_spec,
		      element_name  => $args{element_name},
		      ops	    => [],
		      op	    => $args{element_name},
		      name	    => $name,
		     }, $class;

    if ( $args{parent} ) {
	croak "parent argument ($args{parent}) must be of type Lire::Aggregator"
	  unless UNIVERSAL::isa( $args{parent}, "Lire::Aggregator" );
	$self->{parent} = $args{parent};
    }

    $self;
}

sub name {
    $_[0]->{name};
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::NestableAggregator - Base class for aggregators that can nest.

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: NestableAggregator.pm,v 1.1 2002/03/16 23:10:00 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
